/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze.load;

import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.schema.MemUsageUtil;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnCategory;
import org.apache.iotdb.confignode.rpc.thrift.TDatabaseSchema;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.load.LoadAnalyzeException;
import org.apache.iotdb.db.exception.load.LoadRuntimeOutOfMemoryException;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.plan.Coordinator;
import org.apache.iotdb.db.queryengine.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.queryengine.plan.execution.config.TableConfigTaskVisitor;
import org.apache.iotdb.db.queryengine.plan.execution.config.executor.ClusterConfigTaskExecutor;
import org.apache.iotdb.db.queryengine.plan.execution.config.metadata.relational.CreateDBTask;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.ColumnSchema;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.ITableDeviceSchemaValidation;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.Metadata;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.QualifiedObjectName;
import org.apache.iotdb.db.schemaengine.table.DataNodeTableCache;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModEntry;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModificationFile;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.FileTimeIndex;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.ITimeIndex;
import org.apache.iotdb.db.storageengine.load.memory.LoadTsFileMemoryBlock;
import org.apache.iotdb.db.storageengine.load.memory.LoadTsFileMemoryManager;
import org.apache.iotdb.db.utils.ModificationUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.TableSchema;
import org.apache.tsfile.read.TsFileSequenceReader;
import org.apache.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadTsFileTableSchemaCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoadTsFileTableSchemaCache.class);
    private static final int BATCH_FLUSH_TABLE_DEVICE_NUMBER;
    private static final long ANALYZE_SCHEMA_MEMORY_SIZE_IN_BYTES;
    private final LoadTsFileMemoryBlock block;
    private String database;
    private boolean needToCreateDatabase;
    private Map<String, TableSchema> tableSchemaMap;
    private final Metadata metadata;
    private final MPPQueryContext context;
    private Map<String, Set<IDeviceID>> currentBatchTable2Devices;
    private Map<String, Pair<Integer, Map<Integer, Integer>>> tableIdColumnMapper = new HashMap<String, Pair<Integer, Map<Integer, Integer>>>();
    private Collection<ModEntry> currentModifications;
    private ITimeIndex currentTimeIndex;
    private long batchTable2DevicesMemoryUsageSizeInBytes = 0L;
    private long tableIdColumnMapperMemoryUsageSizeInBytes = 0L;
    private long currentModificationsMemoryUsageSizeInBytes = 0L;
    private long currentTimeIndexMemoryUsageSizeInBytes = 0L;
    private int currentBatchDevicesCount = 0;

    public LoadTsFileTableSchemaCache(Metadata metadata, MPPQueryContext context, boolean needToCreateDatabase) throws LoadRuntimeOutOfMemoryException {
        this.block = LoadTsFileMemoryManager.getInstance().allocateMemoryBlock(ANALYZE_SCHEMA_MEMORY_SIZE_IN_BYTES);
        this.metadata = metadata;
        this.context = context;
        this.currentBatchTable2Devices = new HashMap<String, Set<IDeviceID>>();
        this.currentModifications = new ArrayList<ModEntry>();
        this.needToCreateDatabase = needToCreateDatabase;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void setTableSchemaMap(Map<String, TableSchema> tableSchemaMap) {
        this.tableSchemaMap = tableSchemaMap;
    }

    public void autoCreateAndVerify(IDeviceID device) throws LoadAnalyzeException {
        try {
            if (ModificationUtils.isDeviceDeletedByMods(this.currentModifications, this.currentTimeIndex, device)) {
                return;
            }
        }
        catch (IllegalPathException e) {
            LOGGER.warn("Failed to check if device {} is deleted by mods. Will see it as not deleted.", (Object)device, (Object)e);
        }
        this.createTableAndDatabaseIfNecessary(device.getTableName());
        this.addDevice(device);
        if (this.shouldFlushDevices()) {
            this.flush();
        }
    }

    private void addDevice(IDeviceID device) {
        String tableName = device.getTableName();
        long memoryUsageSizeInBytes = 0L;
        if (!this.currentBatchTable2Devices.containsKey(tableName)) {
            memoryUsageSizeInBytes += MemUsageUtil.computeStringMemUsage((String)tableName);
        }
        if (this.currentBatchTable2Devices.computeIfAbsent(tableName, k -> new HashSet()).add(device)) {
            memoryUsageSizeInBytes += device.ramBytesUsed();
            ++this.currentBatchDevicesCount;
        }
        if (memoryUsageSizeInBytes > 0L) {
            this.batchTable2DevicesMemoryUsageSizeInBytes += memoryUsageSizeInBytes;
            this.block.addMemoryUsage(memoryUsageSizeInBytes);
        }
    }

    private boolean shouldFlushDevices() {
        return !this.block.hasEnoughMemory() || this.currentBatchDevicesCount >= BATCH_FLUSH_TABLE_DEVICE_NUMBER;
    }

    public void flush() {
        this.doAutoCreateAndVerify();
        this.clearDevices();
    }

    private void doAutoCreateAndVerify() throws SemanticException {
        if (this.currentBatchTable2Devices.isEmpty()) {
            return;
        }
        try {
            this.getTableSchemaValidationIterator().forEachRemaining(o -> this.metadata.validateDeviceSchema((ITableDeviceSchemaValidation)o, this.context));
        }
        catch (Exception e) {
            LOGGER.warn("Auto create or verify schema error.", (Throwable)e);
            throw new SemanticException(String.format("Auto create or verify schema error.  Detail: %s.", e.getMessage()));
        }
    }

    private Iterator<ITableDeviceSchemaValidation> getTableSchemaValidationIterator() {
        return this.currentBatchTable2Devices.keySet().stream().map(this::createTableSchemaValidation).iterator();
    }

    private ITableDeviceSchemaValidation createTableSchemaValidation(final String tableName) {
        return new ITableDeviceSchemaValidation(){

            @Override
            public String getDatabase() {
                return LoadTsFileTableSchemaCache.this.database;
            }

            @Override
            public String getTableName() {
                return tableName;
            }

            @Override
            public List<Object[]> getDeviceIdList() {
                ArrayList<Object[]> devices = new ArrayList<Object[]>();
                Pair idColumnCountAndMapper = (Pair)LoadTsFileTableSchemaCache.this.tableIdColumnMapper.get(tableName);
                if (Objects.isNull(idColumnCountAndMapper)) {
                    LOGGER.warn("Failed to find id column mapping for table {}", (Object)tableName);
                }
                for (IDeviceID device : (Set)LoadTsFileTableSchemaCache.this.currentBatchTable2Devices.get(tableName)) {
                    if (Objects.isNull(idColumnCountAndMapper)) {
                        devices.add(Arrays.copyOfRange(device.getSegments(), 1, device.getSegments().length));
                        continue;
                    }
                    Object[] deviceIdArray = new String[((Integer)idColumnCountAndMapper.getLeft()).intValue()];
                    for (Map.Entry fileColumn2RealColumn : ((Map)idColumnCountAndMapper.getRight()).entrySet()) {
                        int fileColumnIndex = (Integer)fileColumn2RealColumn.getKey();
                        int realColumnIndex = (Integer)fileColumn2RealColumn.getValue();
                        deviceIdArray[realColumnIndex] = fileColumnIndex + 1 < device.getSegments().length ? device.getSegments()[fileColumnIndex + 1] : null;
                    }
                    devices.add(LoadTsFileTableSchemaCache.truncateNullSuffixesOfDeviceIdSegments(deviceIdArray));
                }
                return devices;
            }

            @Override
            public List<String> getAttributeColumnNameList() {
                return Collections.emptyList();
            }

            @Override
            public List<Object[]> getAttributeValueList() {
                return Collections.nCopies(((Set)LoadTsFileTableSchemaCache.this.currentBatchTable2Devices.get(tableName)).size(), new Object[0]);
            }
        };
    }

    private static Object[] truncateNullSuffixesOfDeviceIdSegments(Object[] segments) {
        int lastNonNullIndex;
        for (lastNonNullIndex = segments.length - 1; lastNonNullIndex >= 1 && segments[lastNonNullIndex] == null; --lastNonNullIndex) {
        }
        return Arrays.copyOf(segments, lastNonNullIndex + 1);
    }

    public void createTableAndDatabaseIfNecessary(String tableName) throws LoadAnalyzeException {
        org.apache.iotdb.db.queryengine.plan.relational.metadata.TableSchema fileSchema;
        org.apache.iotdb.db.queryengine.plan.relational.metadata.TableSchema realSchema;
        TableSchema schema = this.tableSchemaMap.remove(tableName);
        if (Objects.isNull(schema)) {
            return;
        }
        Coordinator.getInstance().getAccessControl().checkCanInsertIntoTable(this.context.getSession().getUserName(), new QualifiedObjectName(this.database, tableName));
        if (this.needToCreateDatabase) {
            this.autoCreateTableDatabaseIfAbsent(this.database);
            this.needToCreateDatabase = false;
        }
        if (Objects.isNull(realSchema = (org.apache.iotdb.db.queryengine.plan.relational.metadata.TableSchema)this.metadata.validateTableHeaderSchema(this.database, fileSchema = org.apache.iotdb.db.queryengine.plan.relational.metadata.TableSchema.fromTsFileTableSchema(tableName, schema), this.context, true, true).orElse(null))) {
            throw new LoadAnalyzeException(String.format("Failed to validate schema for table {%s, %s}", fileSchema.getTableName(), fileSchema));
        }
        this.verifyTableDataTypeAndGenerateIdColumnMapper(fileSchema, realSchema);
    }

    private void autoCreateTableDatabaseIfAbsent(String database) throws LoadAnalyzeException {
        TableConfigTaskVisitor.validateDatabaseName(database);
        if (DataNodeTableCache.getInstance().isDatabaseExist(database)) {
            return;
        }
        Coordinator.getInstance().getAccessControl().checkCanCreateDatabase(this.context.getSession().getUserName(), database);
        CreateDBTask task = new CreateDBTask(new TDatabaseSchema(database).setIsTableModel(true), true);
        try {
            ListenableFuture<ConfigTaskResult> future = task.execute(ClusterConfigTaskExecutor.getInstance());
            ConfigTaskResult result = (ConfigTaskResult)future.get();
            if (result.getStatusCode().getStatusCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                throw new LoadAnalyzeException(String.format("Auto create database failed: %s, status code: %s", database, result.getStatusCode()));
            }
        }
        catch (Exception e) {
            throw new LoadAnalyzeException("Auto create database failed because: " + e.getMessage());
        }
    }

    private void verifyTableDataTypeAndGenerateIdColumnMapper(org.apache.iotdb.db.queryengine.plan.relational.metadata.TableSchema fileSchema, org.apache.iotdb.db.queryengine.plan.relational.metadata.TableSchema realSchema) throws LoadAnalyzeException {
        int realIdColumnCount = realSchema.getIdColumns().size();
        Map idColumnMapping = (Map)this.tableIdColumnMapper.computeIfAbsent(realSchema.getTableName(), k -> new Pair((Object)realIdColumnCount, new HashMap())).getRight();
        HashMap<String, Integer> idColumnNameToIndex = new HashMap<String, Integer>();
        for (int i = 0; i < realSchema.getIdColumns().size(); ++i) {
            idColumnNameToIndex.put(realSchema.getIdColumns().get(i).getName(), i);
        }
        HashMap<String, ColumnSchema> fieldColumnNameToSchema = new HashMap<String, ColumnSchema>();
        for (ColumnSchema column : realSchema.getColumns()) {
            if (column.getColumnCategory() != TsTableColumnCategory.FIELD) continue;
            fieldColumnNameToSchema.put(column.getName(), column);
        }
        int idColumnIndex = 0;
        for (ColumnSchema fileColumn : fileSchema.getColumns()) {
            if (fileColumn.getColumnCategory() == TsTableColumnCategory.TAG) {
                Integer realIndex = (Integer)idColumnNameToIndex.get(fileColumn.getName());
                if (realIndex != null) {
                    idColumnMapping.put(idColumnIndex++, realIndex);
                    continue;
                }
                throw new LoadAnalyzeException(String.format("Id column %s in TsFile is not found in IoTDB table %s", fileColumn.getName(), realSchema.getTableName()));
            }
            if (fileColumn.getColumnCategory() != TsTableColumnCategory.FIELD) continue;
            ColumnSchema realColumn = (ColumnSchema)fieldColumnNameToSchema.get(fileColumn.getName());
            if (!LOGGER.isDebugEnabled() || realColumn != null && fileColumn.getType().equals(realColumn.getType())) continue;
            LOGGER.debug("Data type mismatch for column {} in table {}, type in TsFile: {}, type in IoTDB: {}", new Object[]{realColumn.getName(), realSchema.getTableName(), fileColumn.getType(), realColumn.getType()});
        }
        this.updateTableIdColumnMapperMemoryUsageSizeInBytes();
    }

    private void updateTableIdColumnMapperMemoryUsageSizeInBytes() {
        this.block.reduceMemoryUsage(this.tableIdColumnMapperMemoryUsageSizeInBytes);
        this.tableIdColumnMapperMemoryUsageSizeInBytes = 0L;
        for (Map.Entry<String, Pair<Integer, Map<Integer, Integer>>> entry : this.tableIdColumnMapper.entrySet()) {
            this.tableIdColumnMapperMemoryUsageSizeInBytes += MemUsageUtil.computeStringMemUsage((String)entry.getKey());
            this.tableIdColumnMapperMemoryUsageSizeInBytes += 4L + 8L * (long)((Map)entry.getValue().getRight()).size();
        }
        this.block.addMemoryUsage(this.tableIdColumnMapperMemoryUsageSizeInBytes);
    }

    public void setCurrentModificationsAndTimeIndex(TsFileResource resource, TsFileSequenceReader reader) throws IOException {
        this.clearModificationsAndTimeIndex();
        this.currentModifications = ModificationFile.readAllModifications(resource.getTsFile(), false);
        for (ModEntry modification : this.currentModifications) {
            this.currentModificationsMemoryUsageSizeInBytes += (long)modification.serializedSize();
        }
        long newMemorySize = this.currentModificationsMemoryUsageSizeInBytes > ANALYZE_SCHEMA_MEMORY_SIZE_IN_BYTES / 2L ? this.currentModificationsMemoryUsageSizeInBytes + ANALYZE_SCHEMA_MEMORY_SIZE_IN_BYTES : ANALYZE_SCHEMA_MEMORY_SIZE_IN_BYTES;
        this.block.forceResize(newMemorySize);
        this.block.addMemoryUsage(this.currentModificationsMemoryUsageSizeInBytes);
        if (!this.currentModifications.isEmpty() && resource.resourceFileExists()) {
            AtomicInteger deviceCount = new AtomicInteger();
            reader.getAllDevicesIteratorWithIsAligned().forEachRemaining(o -> deviceCount.getAndIncrement());
            this.currentTimeIndex = resource.getTimeIndex();
            if (this.currentTimeIndex instanceof FileTimeIndex) {
                this.currentTimeIndex = resource.buildDeviceTimeIndex();
            }
            this.currentTimeIndexMemoryUsageSizeInBytes = this.currentTimeIndex.calculateRamSize();
            this.block.addMemoryUsage(this.currentTimeIndexMemoryUsageSizeInBytes);
        }
    }

    public void setCurrentTimeIndex(ITimeIndex timeIndex) {
        this.currentTimeIndex = timeIndex;
    }

    public void close() {
        this.clearDevices();
        this.clearIdColumnMapper();
        this.clearModificationsAndTimeIndex();
        this.block.close();
        this.currentBatchTable2Devices = null;
        this.tableIdColumnMapper = null;
    }

    private void clearDevices() {
        this.currentBatchTable2Devices.clear();
        this.block.reduceMemoryUsage(this.batchTable2DevicesMemoryUsageSizeInBytes);
        this.batchTable2DevicesMemoryUsageSizeInBytes = 0L;
        this.currentBatchDevicesCount = 0;
    }

    private void clearModificationsAndTimeIndex() {
        this.currentModifications.clear();
        this.currentTimeIndex = null;
        this.block.reduceMemoryUsage(this.currentModificationsMemoryUsageSizeInBytes);
        this.block.reduceMemoryUsage(this.currentTimeIndexMemoryUsageSizeInBytes);
        this.currentModificationsMemoryUsageSizeInBytes = 0L;
        this.currentTimeIndexMemoryUsageSizeInBytes = 0L;
    }

    public void clearIdColumnMapper() {
        this.tableIdColumnMapper.clear();
        this.block.reduceMemoryUsage(this.tableIdColumnMapperMemoryUsageSizeInBytes);
        this.tableIdColumnMapperMemoryUsageSizeInBytes = 0L;
    }

    static {
        IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();
        BATCH_FLUSH_TABLE_DEVICE_NUMBER = CONFIG.getLoadTsFileAnalyzeSchemaBatchFlushTableDeviceNumber();
        ANALYZE_SCHEMA_MEMORY_SIZE_IN_BYTES = CONFIG.getLoadTsFileAnalyzeSchemaMemorySizeInBytes() <= 0L ? (long)BATCH_FLUSH_TABLE_DEVICE_NUMBER << 10 : CONFIG.getLoadTsFileAnalyzeSchemaMemorySizeInBytes();
    }
}

