/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.node;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.TwoChildProcessNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;

public class SemiJoinNode
extends TwoChildProcessNode {
    private final Symbol sourceJoinSymbol;
    private final Symbol filteringSourceJoinSymbol;
    private final Symbol semiJoinOutput;

    public SemiJoinNode(PlanNodeId id, PlanNode source, PlanNode filteringSource, Symbol sourceJoinSymbol, Symbol filteringSourceJoinSymbol, Symbol semiJoinOutput) {
        super(id, source, filteringSource);
        this.sourceJoinSymbol = Objects.requireNonNull(sourceJoinSymbol, "sourceJoinSymbol is null");
        this.filteringSourceJoinSymbol = Objects.requireNonNull(filteringSourceJoinSymbol, "filteringSourceJoinSymbol is null");
        this.semiJoinOutput = Objects.requireNonNull(semiJoinOutput, "semiJoinOutput is null");
        if (source != null) {
            Preconditions.checkArgument((boolean)source.getOutputSymbols().contains(sourceJoinSymbol), (Object)"Source does not contain join symbol");
        }
        if (filteringSource != null) {
            Preconditions.checkArgument((boolean)filteringSource.getOutputSymbols().contains(filteringSourceJoinSymbol), (Object)"Filtering source does not contain filtering join symbol");
        }
    }

    public PlanNode getSource() {
        return this.leftChild;
    }

    public PlanNode getFilteringSource() {
        return this.rightChild;
    }

    public Symbol getSourceJoinSymbol() {
        return this.sourceJoinSymbol;
    }

    public Symbol getFilteringSourceJoinSymbol() {
        return this.filteringSourceJoinSymbol;
    }

    public Symbol getSemiJoinOutput() {
        return this.semiJoinOutput;
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return ImmutableList.builder().addAll(this.leftChild.getOutputSymbols()).add((Object)this.semiJoinOutput).build();
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitSemiJoin(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Preconditions.checkArgument((newChildren.size() == 2 ? 1 : 0) != 0, (Object)"expected newChildren to contain 2 nodes");
        return new SemiJoinNode(this.getPlanNodeId(), newChildren.get(0), newChildren.get(1), this.sourceJoinSymbol, this.filteringSourceJoinSymbol, this.semiJoinOutput);
    }

    @Override
    public PlanNode clone() {
        return new SemiJoinNode(this.getPlanNodeId(), null, null, this.sourceJoinSymbol, this.filteringSourceJoinSymbol, this.semiJoinOutput);
    }

    @Override
    public List<String> getOutputColumnNames() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        SemiJoinNode other = (SemiJoinNode)obj;
        return Objects.equals(this.sourceJoinSymbol, other.sourceJoinSymbol) && Objects.equals(this.filteringSourceJoinSymbol, other.filteringSourceJoinSymbol) && Objects.equals(this.semiJoinOutput, other.semiJoinOutput);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.sourceJoinSymbol, this.filteringSourceJoinSymbol, this.semiJoinOutput);
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.TABLE_SEMI_JOIN_NODE.serialize(byteBuffer);
        Symbol.serialize(this.sourceJoinSymbol, byteBuffer);
        Symbol.serialize(this.filteringSourceJoinSymbol, byteBuffer);
        Symbol.serialize(this.semiJoinOutput, byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.TABLE_SEMI_JOIN_NODE.serialize(stream);
        Symbol.serialize(this.sourceJoinSymbol, stream);
        Symbol.serialize(this.filteringSourceJoinSymbol, stream);
        Symbol.serialize(this.semiJoinOutput, stream);
    }

    public static SemiJoinNode deserialize(ByteBuffer byteBuffer) {
        Symbol sourceJoinSymbol = Symbol.deserialize(byteBuffer);
        Symbol filteringSourceJoinSymbol = Symbol.deserialize(byteBuffer);
        Symbol semiJoinOutput = Symbol.deserialize(byteBuffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new SemiJoinNode(planNodeId, null, null, sourceJoinSymbol, filteringSourceJoinSymbol, semiJoinOutput);
    }
}

