/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.attribute.update;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.ToLongFunction;
import javax.annotation.Nonnull;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.commons.utils.ThriftCommonsSerDeUtils;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.TableDeviceCacheAttributeGuard;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.TableDeviceSchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.schema.TableDeviceAttributeCommitUpdateNode;
import org.apache.iotdb.db.schemaengine.rescon.MemSchemaRegionStatistics;
import org.apache.iotdb.db.schemaengine.schemaregion.attribute.update.GeneralRegionAttributeSecurityService;
import org.apache.iotdb.db.schemaengine.schemaregion.attribute.update.UpdateClearContainer;
import org.apache.iotdb.db.schemaengine.schemaregion.attribute.update.UpdateContainer;
import org.apache.iotdb.db.schemaengine.schemaregion.attribute.update.UpdateDetailContainer;
import org.apache.iotdb.db.schemaengine.schemaregion.attribute.update.UpdateDetailContainerStatistics;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceAttributeCacheUpdater {
    private static final Logger logger = LoggerFactory.getLogger(DeviceAttributeCacheUpdater.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    public static final int UPDATE_DETAIL_CONTAINER_SEND_MIN_LIMIT_BYTES = 1024;
    private final Set<TDataNodeLocation> targetDataNodeLocations = new HashSet<TDataNodeLocation>();
    private final ConcurrentMap<TDataNodeLocation, UpdateContainer> attributeUpdateMap = new ConcurrentHashMap<TDataNodeLocation, UpdateContainer>();
    private final AtomicLong version = new AtomicLong(0L);
    private final MemSchemaRegionStatistics regionStatistics;
    private final String databaseName;
    private final Map<TDataNodeLocation, UpdateDetailContainerStatistics> updateContainerStatistics = new HashMap<TDataNodeLocation, UpdateDetailContainerStatistics>();

    public DeviceAttributeCacheUpdater(MemSchemaRegionStatistics regionStatistics, String databaseName) {
        this.regionStatistics = regionStatistics;
        this.databaseName = databaseName;
    }

    public void update(String tableName, String[] deviceId, Map<String, Binary> attributeMap) {
        this.targetDataNodeLocations.forEach(location -> {
            if (location.getDataNodeId() == config.getDataNodeId()) {
                this.removeLocation((TDataNodeLocation)location);
                return;
            }
            if (!this.attributeUpdateMap.containsKey(location)) {
                UpdateContainer newContainer;
                if (!this.regionStatistics.isAllowToCreateNewSeries()) {
                    newContainer = new UpdateClearContainer();
                    this.requestMemory(UpdateClearContainer.INSTANCE_SIZE);
                } else {
                    newContainer = new UpdateDetailContainer();
                    this.requestMemory(UpdateDetailContainer.INSTANCE_SIZE);
                    this.updateContainerStatistics.put((TDataNodeLocation)location, new UpdateDetailContainerStatistics());
                }
                this.attributeUpdateMap.put((TDataNodeLocation)location, newContainer);
            }
            long size = ((UpdateContainer)this.attributeUpdateMap.get(location)).updateAttribute(tableName, deviceId, attributeMap);
            this.updateContainerStatistics.computeIfPresent((TDataNodeLocation)location, (k, v) -> {
                v.addEntrySize(size);
                return v;
            });
            this.updateMemory(size);
        });
    }

    public void invalidate(String tableName) {
        this.invalidate((UpdateContainer container) -> container.invalidate(tableName));
    }

    public void invalidate(String[] pathNodes) {
        this.invalidate((UpdateContainer container) -> container.invalidate(pathNodes));
    }

    public void invalidate(String tableName, String attributeName) {
        this.invalidate((UpdateContainer container) -> container.invalidate(tableName, attributeName));
    }

    private void invalidate(ToLongFunction<UpdateContainer> updateFunction) {
        this.attributeUpdateMap.forEach((location, container) -> {
            long size = updateFunction.applyAsLong((UpdateContainer)container);
            this.releaseMemory(size);
            this.updateContainerStatistics.computeIfPresent((TDataNodeLocation)location, (k, v) -> {
                v.decreaseEntrySize(size);
                return v;
            });
        });
    }

    public Pair<Long, Map<TDataNodeLocation, byte[]>> getAttributeUpdateInfo(@Nonnull AtomicInteger limit, @Nonnull AtomicBoolean hasRemaining) {
        HashMap<TDataNodeLocation, byte[]> updateBytes = new HashMap<TDataNodeLocation, byte[]>();
        for (Map.Entry entry : this.attributeUpdateMap.entrySet()) {
            TDataNodeLocation location = (TDataNodeLocation)entry.getKey();
            UpdateContainer container = (UpdateContainer)entry.getValue();
            if (location.getDataNodeId() == config.getDataNodeId()) continue;
            if (limit.get() < 1024 && container instanceof UpdateDetailContainer) {
                hasRemaining.set(true);
                continue;
            }
            if (limit.get() <= 5) {
                hasRemaining.set(true);
                break;
            }
            limit.addAndGet(-5);
            updateBytes.put(location, container.getUpdateContent(limit, hasRemaining));
        }
        return new Pair((Object)this.version.get(), updateBytes);
    }

    public void commit(TableDeviceAttributeCommitUpdateNode node) {
        Set<TDataNodeLocation> shrunkNodes = node.getShrunkNodes();
        this.targetDataNodeLocations.removeAll(shrunkNodes);
        shrunkNodes.forEach(this::removeLocation);
        if (this.version.get() == node.getVersion()) {
            this.removeLocation(node.getLeaderLocation());
        }
        node.getCommitMap().forEach((location, bytes) -> this.attributeUpdateMap.computeIfPresent((TDataNodeLocation)location, (dataNode, container) -> {
            if (container instanceof UpdateDetailContainer || this.version.get() == node.getVersion()) {
                Pair<Long, Boolean> result = container.updateSelfByCommitContainer(DeviceAttributeCacheUpdater.getContainer(bytes));
                this.releaseMemory((Long)result.getLeft());
                if (Boolean.TRUE.equals(result.getRight())) {
                    this.releaseMemory(container instanceof UpdateDetailContainer ? UpdateDetailContainer.INSTANCE_SIZE : UpdateClearContainer.INSTANCE_SIZE);
                    this.updateContainerStatistics.remove(dataNode);
                    return null;
                }
                if (this.updateContainerStatistics.containsKey(dataNode)) {
                    this.updateContainerStatistics.get(dataNode).decreaseEntrySize((Long)result.getLeft());
                }
            }
            return container;
        }));
    }

    private void removeLocation(TDataNodeLocation location) {
        if (this.attributeUpdateMap.containsKey(location)) {
            this.releaseMemory(this.updateContainerStatistics.containsKey(location) ? this.updateContainerStatistics.get(location).getContainerSize() : ((UpdateClearContainer)this.attributeUpdateMap.get(location)).ramBytesUsed());
            this.attributeUpdateMap.remove(location);
            this.updateContainerStatistics.remove(location);
        }
    }

    public static UpdateContainer getContainer(byte[] bytes) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        UpdateContainer result = null;
        try {
            result = ReadWriteIOUtils.readBool((InputStream)inputStream) ? new UpdateDetailContainer() : new UpdateClearContainer();
            result.deserialize(inputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public boolean addLocation(TDataNodeLocation dataNodeLocation) {
        return this.targetDataNodeLocations.add(dataNodeLocation);
    }

    public void afterUpdate() {
        this.version.incrementAndGet();
        this.degrade();
        GeneralRegionAttributeSecurityService.getInstance().advanceExecution();
    }

    private void degrade() {
        if (this.regionStatistics.isAllowToCreateNewSeries()) {
            return;
        }
        TreeSet<Object> degradeSet = new TreeSet<Object>(Comparator.comparingLong(v -> this.updateContainerStatistics.get(v).getDegradePriority()).reversed());
        this.updateContainerStatistics.forEach((k, v) -> {
            if (v.needDegrade()) {
                degradeSet.add(k);
            }
        });
        for (TDataNodeLocation tDataNodeLocation : degradeSet) {
            if (this.regionStatistics.isAllowToCreateNewSeries()) {
                return;
            }
            UpdateClearContainer newContainer = ((UpdateDetailContainer)this.attributeUpdateMap.get(tDataNodeLocation)).degrade();
            this.updateMemory(newContainer.ramBytesUsed() - this.updateContainerStatistics.get(tDataNodeLocation).getContainerSize());
            this.attributeUpdateMap.put(tDataNodeLocation, newContainer);
            this.updateContainerStatistics.remove(tDataNodeLocation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean createSnapshot(File targetDir) {
        File snapshotTmp = SystemFileFactory.INSTANCE.getFile(targetDir, "device_attribute_remote_updater.snapshot.tmp");
        File snapshot = SystemFileFactory.INSTANCE.getFile(targetDir, "device_attribute_remote_updater.snapshot");
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(snapshotTmp);
            BufferedOutputStream outputStream = new BufferedOutputStream(fileOutputStream);
            try {
                this.serialize(outputStream);
            }
            finally {
                outputStream.flush();
                fileOutputStream.getFD().sync();
                outputStream.close();
            }
            if (snapshot.exists() && !FileUtils.deleteFileIfExist((File)snapshot)) {
                logger.error("Failed to delete old snapshot {} while creating device attribute remote updater snapshot.", (Object)snapshot.getName());
                boolean bl = false;
                return bl;
            }
            if (!snapshotTmp.renameTo(snapshot)) {
                logger.error("Failed to rename {} to {} while creating device attribute remote updater snapshot.", (Object)snapshotTmp.getName(), (Object)snapshot.getName());
                FileUtils.deleteFileIfExist((File)snapshot);
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            logger.error("Failed to create device attribute remote updater snapshot due to {}", (Object)e.getMessage(), (Object)e);
            FileUtils.deleteFileIfExist((File)snapshot);
            boolean bl = false;
            return bl;
        }
        finally {
            FileUtils.deleteFileIfExist((File)snapshotTmp);
        }
    }

    private void serialize(OutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((long)this.version.get(), (OutputStream)outputStream);
        ReadWriteIOUtils.write((int)this.targetDataNodeLocations.size(), (OutputStream)outputStream);
        for (TDataNodeLocation tDataNodeLocation : this.targetDataNodeLocations) {
            DeviceAttributeCacheUpdater.serializeNodeLocation4AttributeUpdate(tDataNodeLocation, outputStream);
        }
        ReadWriteIOUtils.write((int)this.attributeUpdateMap.size(), (OutputStream)outputStream);
        for (Map.Entry entry : this.attributeUpdateMap.entrySet()) {
            DeviceAttributeCacheUpdater.serializeNodeLocation4AttributeUpdate((TDataNodeLocation)entry.getKey(), outputStream);
            ((UpdateContainer)entry.getValue()).serialize(outputStream);
        }
    }

    public void loadFromSnapshot(File snapshotDir) throws IOException {
        File snapshot = SystemFileFactory.INSTANCE.getFile(snapshotDir, "device_attribute_remote_updater.snapshot");
        if (!snapshot.exists()) {
            logger.info("Device attribute remote updater snapshot {} not found, consider it as upgraded from the older version, will not update remote", (Object)snapshot);
            return;
        }
        try (BufferedInputStream inputStream = new BufferedInputStream(Files.newInputStream(snapshot.toPath(), new OpenOption[0]));){
            this.deserialize(inputStream);
        }
        catch (Exception e) {
            logger.warn("Load device attribute remote updater snapshot from {} failed, continue...", (Object)snapshotDir);
        }
    }

    private void deserialize(InputStream inputStream) throws IOException {
        int i;
        this.version.set(ReadWriteIOUtils.readLong((InputStream)inputStream));
        int size = ReadWriteIOUtils.readInt((InputStream)inputStream);
        for (i = 0; i < size; ++i) {
            this.targetDataNodeLocations.add(DeviceAttributeCacheUpdater.deserializeNodeLocationForAttributeUpdate(inputStream));
        }
        size = ReadWriteIOUtils.readInt((InputStream)inputStream);
        for (i = 0; i < size; ++i) {
            TDataNodeLocation location = DeviceAttributeCacheUpdater.deserializeNodeLocationForAttributeUpdate(inputStream);
            boolean isDetails = ReadWriteIOUtils.readBool((InputStream)inputStream);
            UpdateContainer container = isDetails ? new UpdateDetailContainer() : new UpdateClearContainer();
            container.deserialize(inputStream);
            if (config.getDataNodeId() == location.getDataNodeId() && config.getInternalAddress().equals(location.getInternalEndPoint().getIp()) && config.getInternalPort() == location.getInternalEndPoint().getPort()) {
                TableDeviceCacheAttributeGuard guard = TableDeviceSchemaFetcher.getInstance().getAttributeGuard();
                guard.setVersion(this.regionStatistics.getSchemaRegionId(), this.version.get());
                guard.handleContainer(this.databaseName, container);
                continue;
            }
            this.attributeUpdateMap.put(location, container);
            if (!isDetails) continue;
            this.updateContainerStatistics.put(location, new UpdateDetailContainerStatistics());
        }
    }

    public static void serializeNodeLocation4AttributeUpdate(TDataNodeLocation location, ByteBuffer buffer) {
        ReadWriteIOUtils.write((int)location.getDataNodeId(), (ByteBuffer)buffer);
        ThriftCommonsSerDeUtils.serializeTEndPoint((TEndPoint)location.getInternalEndPoint(), (ByteBuffer)buffer);
    }

    public static void serializeNodeLocation4AttributeUpdate(TDataNodeLocation location, OutputStream stream) throws IOException {
        ReadWriteIOUtils.write((int)location.getDataNodeId(), (OutputStream)stream);
        ThriftCommonsSerDeUtils.serializeTEndPoint((TEndPoint)location.getInternalEndPoint(), (OutputStream)stream);
    }

    public static TDataNodeLocation deserializeNodeLocationForAttributeUpdate(ByteBuffer buffer) {
        return new TDataNodeLocation(ReadWriteIOUtils.readInt((ByteBuffer)buffer), null, ThriftCommonsSerDeUtils.deserializeTEndPoint((ByteBuffer)buffer), null, null, null);
    }

    public static TDataNodeLocation deserializeNodeLocationForAttributeUpdate(InputStream inputStream) throws IOException {
        return new TDataNodeLocation(ReadWriteIOUtils.readInt((InputStream)inputStream), null, ThriftCommonsSerDeUtils.deserializeTEndPoint((InputStream)inputStream), null, null, null);
    }

    private void updateMemory(long size) {
        if (size > 0L) {
            this.requestMemory(size);
        } else {
            this.releaseMemory(size);
        }
    }

    private void requestMemory(long size) {
        if (this.regionStatistics != null) {
            this.regionStatistics.requestMemory(size);
        }
    }

    private void releaseMemory(long size) {
        if (this.regionStatistics != null) {
            this.regionStatistics.releaseMemory(size);
        }
    }
}

