/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.snapshot;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.DirectoryNotLegalException;
import org.apache.iotdb.db.storageengine.dataregion.DataRegion;
import org.apache.iotdb.db.storageengine.dataregion.modification.ModificationFile;
import org.apache.iotdb.db.storageengine.dataregion.snapshot.SnapshotLogger;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotTaker {
    private static final Logger LOGGER = LoggerFactory.getLogger(SnapshotTaker.class);
    private final DataRegion dataRegion;
    private SnapshotLogger snapshotLogger;
    private List<TsFileResource> seqFiles;
    private List<TsFileResource> unseqFiles;

    public SnapshotTaker(DataRegion dataRegion) {
        this.dataRegion = dataRegion;
    }

    public boolean takeFullSnapshot(String snapshotDirPath, boolean flushBeforeSnapshot) throws DirectoryNotLegalException, IOException {
        File snapshotDir = new File(snapshotDirPath);
        String snapshotId = snapshotDir.getName();
        return this.takeFullSnapshot(snapshotDirPath, snapshotId, snapshotId, flushBeforeSnapshot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean takeFullSnapshot(String snapshotDirPath, String tempSnapshotId, String finalSnapshotId, boolean flushBeforeSnapshot) throws DirectoryNotLegalException, IOException {
        File snapshotDir = new File(snapshotDirPath);
        if (snapshotDir.exists() && snapshotDir.listFiles() != null && Objects.requireNonNull(snapshotDir.listFiles()).length > 0) {
            throw new DirectoryNotLegalException(String.format("%s already exists and is not empty", snapshotDirPath));
        }
        if (!snapshotDir.exists() && !snapshotDir.mkdirs()) {
            throw new IOException(String.format("Failed to create directory %s", snapshotDir));
        }
        File snapshotLog = new File(snapshotDir, "snapshot.log");
        try {
            boolean success;
            this.snapshotLogger = new SnapshotLogger(snapshotLog);
            this.snapshotLogger.logSnapshotId(finalSnapshotId);
            try {
                this.readLockTheFile();
                if (flushBeforeSnapshot) {
                    try {
                        this.dataRegion.writeLock("snapshotTaker");
                        this.dataRegion.syncCloseAllWorkingTsFileProcessors();
                    }
                    finally {
                        this.dataRegion.writeUnlock();
                    }
                }
                success = (success = this.createSnapshot(this.seqFiles, tempSnapshotId)) && this.createSnapshot(this.unseqFiles, tempSnapshotId);
            }
            finally {
                this.readUnlockTheFile();
            }
            if (!success) {
                LOGGER.warn("Failed to take snapshot for {}-{}, clean up", (Object)this.dataRegion.getDatabaseName(), (Object)this.dataRegion.getDataRegionId());
                this.cleanUpWhenFail(finalSnapshotId);
            } else {
                this.snapshotLogger.logEnd();
                LOGGER.info("Successfully take snapshot for {}-{}, snapshot directory is {}", new Object[]{this.dataRegion.getDatabaseName(), this.dataRegion.getDataRegionId(), snapshotDir.getParentFile().getAbsolutePath() + File.separator + finalSnapshotId});
            }
            boolean bl = success;
            return bl;
        }
        catch (Exception e) {
            LOGGER.error("Exception occurs when taking snapshot for {}-{}", new Object[]{this.dataRegion.getDatabaseName(), this.dataRegion.getDataRegionId(), e});
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                this.snapshotLogger.close();
            }
            catch (Exception e) {
                LOGGER.error("Failed to close snapshot logger", (Throwable)e);
            }
        }
    }

    public boolean cleanSnapshot() {
        return SnapshotTaker.clearSnapshotOfDataRegion(this.dataRegion);
    }

    public static boolean clearSnapshotOfDataRegion(DataRegion dataRegion) {
        String[] dataDirs = IoTDBDescriptor.getInstance().getConfig().getDataDirs();
        boolean allSuccess = true;
        for (String dataDir : dataDirs) {
            StringBuilder pathBuilder = new StringBuilder(dataDir);
            pathBuilder.append(File.separator).append("snapshot");
            pathBuilder.append(File.separator).append(dataRegion.getDatabaseName());
            pathBuilder.append("-").append(dataRegion.getDataRegionId());
            try {
                String path = pathBuilder.toString();
                if (!new File(path).exists()) continue;
                FileUtils.recursivelyDeleteFolder((String)path);
            }
            catch (IOException e) {
                allSuccess = false;
                LOGGER.warn("Clear snapshot dir fail, you should manually delete this dir before do region migration again: {}", (Object)pathBuilder, (Object)e);
            }
        }
        return allSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readLockTheFile() {
        TsFileManager manager = this.dataRegion.getTsFileManager();
        manager.readLock();
        try {
            this.seqFiles = manager.getTsFileList(true);
            this.unseqFiles = manager.getTsFileList(false);
            for (TsFileResource resource : this.seqFiles) {
                resource.readLock();
            }
            for (TsFileResource resource : this.unseqFiles) {
                resource.readLock();
            }
        }
        finally {
            manager.readUnlock();
        }
    }

    private void readUnlockTheFile() {
        for (TsFileResource resource : this.seqFiles) {
            resource.readUnlock();
        }
        for (TsFileResource resource : this.unseqFiles) {
            resource.readUnlock();
        }
    }

    private boolean createSnapshot(List<TsFileResource> resources, String snapshotId) {
        try {
            for (TsFileResource resource : resources) {
                if (!resource.isClosed()) continue;
                File tsFile = resource.getTsFile();
                if (!resource.isClosed()) continue;
                File snapshotTsFile = this.getSnapshotFilePathForTsFile(tsFile, snapshotId);
                File snapshotResourceFile = new File(snapshotTsFile.getAbsolutePath() + ".resource");
                File snapshotDir = snapshotTsFile.getParentFile();
                this.createHardLink(snapshotTsFile, tsFile);
                if (resource.exclusiveModFileExists()) {
                    this.copyFile(ModificationFile.getExclusiveMods(snapshotTsFile), ModificationFile.getExclusiveMods(tsFile));
                }
                if (resource.sharedModFileExists()) {
                    File sharedModFile = resource.getSharedModFile().getFile();
                    File snapshotSharedModFile = new File(snapshotDir, sharedModFile.getName());
                    if (!snapshotSharedModFile.exists()) {
                        this.copyFile(snapshotSharedModFile, sharedModFile);
                    }
                    ModificationFile sharedModFileTemp = resource.getSharedModFile();
                    resource.setSharedModFile(new ModificationFile(snapshotSharedModFile, false), false);
                    resource.serialize(snapshotResourceFile.getAbsolutePath());
                    resource.setSharedModFile(sharedModFileTemp, false);
                    continue;
                }
                this.createHardLink(snapshotResourceFile, new File(tsFile.getAbsolutePath() + ".resource"));
            }
            return true;
        }
        catch (IOException e) {
            LOGGER.error("Catch IOException when creating snapshot", (Throwable)e);
            return false;
        }
    }

    private void createHardLink(File target, File source) throws IOException {
        if (!target.getParentFile().exists()) {
            LOGGER.error("Hard link target dir {} doesn't exist", (Object)target.getParentFile());
        }
        if (!this.checkHardLinkSourceFile(source)) {
            return;
        }
        Files.deleteIfExists(target.toPath());
        Files.createLink(target.toPath(), source.toPath());
        this.snapshotLogger.logFile(source);
    }

    private boolean checkHardLinkSourceFile(File source) {
        for (int retry = 10; !source.exists() && retry > 0; --retry) {
            LOGGER.warn("Hard link source file {} doesn't exist, will retry for {} times...", (Object)source, (Object)retry);
            try {
                Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
                continue;
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
            }
        }
        if (!source.exists()) {
            File parent = source.getParentFile();
            LOGGER.error("Hard link source file {} doesn't exist, this file will be ignored.", (Object)source);
            String tryMsg = "Try to show all files in parent dir...";
            tryMsg = parent == null ? tryMsg + "Cannot show files because parent dir is null" : tryMsg + Arrays.toString(parent.listFiles());
            LOGGER.error(tryMsg);
            return false;
        }
        return true;
    }

    private void copyFile(File target, File source) throws IOException {
        if (!target.getParentFile().exists()) {
            LOGGER.error("Copy target dir {} doesn't exist", (Object)target.getParentFile());
        }
        if (!source.exists()) {
            LOGGER.error("Copy source file {} doesn't exist", (Object)source);
        }
        Files.deleteIfExists(target.toPath());
        Files.copy(source.toPath(), target.toPath(), new CopyOption[0]);
        this.snapshotLogger.logFile(source);
    }

    public File getSnapshotFilePathForTsFile(File tsFile, String snapshotId) throws IOException {
        int i;
        String[] splittedPath = tsFile.getAbsolutePath().split(File.separator.equals("\\") ? "\\\\" : File.separator);
        StringBuilder stringBuilder = new StringBuilder();
        for (i = 0; i < splittedPath.length - 5; ++i) {
            stringBuilder.append(splittedPath[i]);
            stringBuilder.append(File.separator);
        }
        stringBuilder.append("snapshot");
        stringBuilder.append(File.separator);
        stringBuilder.append(this.dataRegion.getDatabaseName());
        stringBuilder.append("-");
        stringBuilder.append(this.dataRegion.getDataRegionId());
        stringBuilder.append(File.separator);
        stringBuilder.append(snapshotId);
        stringBuilder.append(File.separator);
        while (i < splittedPath.length - 1) {
            stringBuilder.append(splittedPath[i]);
            stringBuilder.append(File.separator);
            ++i;
        }
        File dir = new File(stringBuilder.toString());
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Cannot create directory " + dir.getAbsolutePath());
        }
        return new File(dir, tsFile.getName());
    }

    private void cleanUpWhenFail(String snapshotId) {
        LOGGER.info("Cleaning up snapshot dir for {}", (Object)snapshotId);
        for (String dataDir : IoTDBDescriptor.getInstance().getConfig().getLocalDataDirs()) {
            File dataDirForThisSnapshot = new File(dataDir + File.separator + "snapshot" + File.separator + snapshotId);
            if (!dataDirForThisSnapshot.exists()) continue;
            try {
                FileUtils.recursivelyDeleteFolder((String)dataDirForThisSnapshot.getAbsolutePath());
            }
            catch (IOException e) {
                LOGGER.error("Failed to delete folder {} when cleaning up", (Object)dataDirForThisSnapshot.getAbsolutePath());
            }
        }
    }
}

