/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.primitive;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.factory.primitive.LongLists;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import org.eclipse.collections.impl.utility.internal.IterableIterate;

public class ChunkLongIterable
extends AbstractLazyIterable<LongIterable> {
    private final LongIterable adapted;
    private final int size;

    public ChunkLongIterable(LongIterable delegate, int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        this.adapted = delegate;
        this.size = size;
    }

    @Override
    public Iterator<LongIterable> iterator() {
        return new ChunkLongIterator(this.adapted, this.size);
    }

    @Override
    public void each(Procedure<? super LongIterable> procedure) {
        IterableIterate.forEach(this, procedure);
    }

    public static class ChunkLongIterator
    implements Iterator<LongIterable> {
        private final LongIterator iterator;
        private final int size;
        private final Function0<MutableLongCollection> speciesNewStrategy;

        public ChunkLongIterator(LongIterable iterable, int size) {
            if (size <= 0) {
                throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
            }
            this.size = size;
            this.iterator = iterable.longIterator();
            this.speciesNewStrategy = iterable instanceof MutableLongCollection ? ((MutableLongCollection)iterable)::newEmpty : LongLists.mutable::empty;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public LongIterable next() {
            if (!this.iterator.hasNext()) {
                throw new NoSuchElementException();
            }
            MutableLongCollection result = this.speciesNewStrategy.value();
            for (int i = this.size; i > 0 && this.iterator.hasNext(); --i) {
                result.add(this.iterator.next());
            }
            return result;
        }
    }
}

