/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  The ASF licenses this file to You
 * under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.jackrabbit.jcr2spi;

import org.apache.jackrabbit.test.AbstractJCRTest;

import javax.jcr.RepositoryException;
import javax.jcr.NodeIterator;

/**
 * <code>TestConnect</code>...
 */
public class TestConnect extends AbstractJCRTest {

    public void testConnect() throws RepositoryException {
        System.out.println("UserID: " + superuser.getUserID());
        for (NodeIterator it = superuser.getRootNode().getNodes(); it.hasNext(); ) {
            System.out.println(it.nextNode().getPath());
        }
    }
}
