/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.model.message.view;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.time.Instant;
import java.util.Optional;
import org.apache.james.jmap.api.model.Preview;
import org.apache.james.jmap.draft.model.BlobId;
import org.apache.james.jmap.draft.model.Emailer;
import org.apache.james.jmap.draft.model.Keywords;
import org.apache.james.jmap.draft.model.Number;
import org.apache.james.jmap.draft.model.PreviewDTO;
import org.apache.james.jmap.draft.model.message.view.MessageHeaderView;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="propertiesFilter")
public class MessageFastView
extends MessageHeaderView {
    private final PreviewDTO preview;
    private final boolean hasAttachment;

    public static Builder<? extends Builder> builder() {
        return new Builder();
    }

    @VisibleForTesting
    MessageFastView(MessageId id, BlobId blobId, String threadId, ImmutableSet<MailboxId> mailboxIds, Optional<String> inReplyToMessageId, ImmutableMap<String, String> headers, Optional<Emailer> from, ImmutableList<Emailer> to, ImmutableList<Emailer> cc, ImmutableList<Emailer> bcc, ImmutableList<Emailer> replyTo, String subject, Instant date, Number size, PreviewDTO preview, Keywords keywords, boolean hasAttachment) {
        super(id, blobId, threadId, mailboxIds, inReplyToMessageId, headers, from, to, cc, bcc, replyTo, subject, date, size, keywords);
        this.preview = preview;
        this.hasAttachment = hasAttachment;
    }

    public PreviewDTO getPreview() {
        return this.preview;
    }

    public boolean isHasAttachment() {
        return this.hasAttachment;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder<S extends Builder<S>>
    extends MessageHeaderView.Builder<S> {
        protected Optional<Preview> preview = Optional.empty();
        protected Optional<Boolean> hasAttachment = Optional.empty();

        protected Builder() {
        }

        public S preview(Preview preview) {
            this.preview = Optional.of(preview);
            return (S)this;
        }

        public S preview(Optional<Preview> preview) {
            this.preview = preview;
            return (S)this;
        }

        public S hasAttachment(boolean hasAttachment) {
            this.hasAttachment = Optional.of(hasAttachment);
            return (S)this;
        }

        @Override
        public MessageFastView build() {
            this.checkState();
            return new MessageFastView(this.id, this.blobId, this.threadId, (ImmutableSet<MailboxId>)this.mailboxIds, Optional.ofNullable(this.inReplyToMessageId), (ImmutableMap<String, String>)this.headers, this.from, (ImmutableList<Emailer>)this.to.build(), (ImmutableList<Emailer>)this.cc.build(), (ImmutableList<Emailer>)this.bcc.build(), (ImmutableList<Emailer>)this.replyTo.build(), this.subject, this.date, this.size, PreviewDTO.from(this.preview), this.keywords.orElse(Keywords.DEFAULT_VALUE), this.hasAttachment.get());
        }

        @Override
        public void checkState() {
            super.checkState();
            Preconditions.checkState((this.preview != null ? 1 : 0) != 0, (Object)"'preview' is mandatory");
            Preconditions.checkState((boolean)this.hasAttachment.isPresent(), (Object)"'hasAttachment' should be present");
        }
    }
}

