/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.function.library.cdt;

import java.util.List;
import java.util.Map;
import org.apache.jena.cdt.CDTFactory;
import org.apache.jena.cdt.CDTKey;
import org.apache.jena.cdt.CDTValue;
import org.apache.jena.cdt.CompositeDatatypeList;
import org.apache.jena.cdt.CompositeDatatypeMap;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionBase2;
import org.apache.jena.sparql.function.library.cdt.CDTLiteralFunctionUtils;

public class GetFct
extends FunctionBase2 {
    @Override
    public NodeValue exec(NodeValue nv1, NodeValue nv2) {
        Node n1 = nv1.asNode();
        if (CompositeDatatypeList.isListLiteral(n1)) {
            return this.getFromList(n1, nv2);
        }
        if (CompositeDatatypeMap.isMapLiteral(n1)) {
            return this.getFromMap(n1, nv2);
        }
        throw new ExprEvalException("Neither a list nor a map literal: " + String.valueOf(nv1));
    }

    protected NodeValue getFromList(Node n1, NodeValue nv2) {
        if (!nv2.isInteger()) {
            throw new ExprEvalException("Not an integer literal: " + String.valueOf(nv2));
        }
        int index = nv2.getInteger().intValue();
        if (index < 1) {
            throw new ExprEvalException("Out of bounds index value: " + String.valueOf(nv2));
        }
        List<CDTValue> list = CDTLiteralFunctionUtils.getList(n1);
        if (index > list.size()) {
            throw new ExprEvalException("Out of bounds index value: " + String.valueOf(nv2));
        }
        CDTValue value = list.get(index - 1);
        if (value.isNull()) {
            throw new ExprEvalException("accessing null value from list");
        }
        if (value.isNode()) {
            return NodeValue.makeNode(value.asNode());
        }
        throw new ExprEvalException("Unexpected type of CDTValue: " + value.getClass().getName());
    }

    protected NodeValue getFromMap(Node n1, NodeValue nv2) {
        Node n2 = nv2.asNode();
        if (!n2.isURI() && !n2.isLiteral()) {
            throw new ExprEvalException("Not a valid map key: " + String.valueOf(nv2));
        }
        Map<CDTKey, CDTValue> map = CDTLiteralFunctionUtils.getMap(n1);
        if (map.isEmpty()) {
            throw new ExprEvalException("empty map");
        }
        CDTKey key = CDTFactory.createKey(n2);
        CDTValue value = map.get(key);
        if (value == null) {
            throw new ExprEvalException("key is not in the map");
        }
        if (value.isNull()) {
            throw new ExprEvalException("value for key is in null");
        }
        if (value.isNode()) {
            return NodeValue.makeNode(value.asNode());
        }
        throw new ExprEvalException("Unexpected type of CDTValue: " + value.getClass().getName());
    }
}

