/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib;

import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.function.Function;
import org.apache.jena.atlas.lib.cache.CacheInfo;

public interface Cache<Key, Value> {
    public boolean containsKey(Key var1);

    public Value getIfPresent(Key var1);

    @Deprecated(forRemoval=true)
    default public Value getOrFill(Key key, Callable<Value> callable) {
        return (Value)this.get(key, k -> {
            try {
                return callable.call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    public Value get(Key var1, Function<Key, Value> var2);

    public void put(Key var1, Value var2);

    public void remove(Key var1);

    public Iterator<Key> keys();

    public boolean isEmpty();

    public void clear();

    public long size();

    default public CacheInfo stats() {
        return null;
    }
}

