/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.KnnFieldVectorsWriter;
import org.apache.lucene.codecs.NormsConsumer;
import org.apache.lucene.codecs.NormsFormat;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.codecs.PointsFormat;
import org.apache.lucene.codecs.PointsWriter;
import org.apache.lucene.document.InvertableType;
import org.apache.lucene.document.KnnByteVectorField;
import org.apache.lucene.document.KnnFloatVectorField;
import org.apache.lucene.document.StoredValue;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.BinaryDocValuesWriter;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesLeafReader;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.DocValuesWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.index.FreqProxTermsWriter;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexSorter;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LiveIndexWriterConfig;
import org.apache.lucene.index.NormValuesWriter;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.NumericDocValuesWriter;
import org.apache.lucene.index.PointValuesWriter;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedDocValuesWriter;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedNumericDocValuesWriter;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.SortedSetDocValuesWriter;
import org.apache.lucene.index.Sorter;
import org.apache.lucene.index.SortingStoredFieldsConsumer;
import org.apache.lucene.index.SortingTermVectorsConsumer;
import org.apache.lucene.index.StoredFieldsConsumer;
import org.apache.lucene.index.TermVectorsConsumer;
import org.apache.lucene.index.TermsHash;
import org.apache.lucene.index.TermsHashPerField;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.index.VectorValuesConsumer;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.ByteBlockPool;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefHash;
import org.apache.lucene.util.Counter;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.IntBlockPool;
import org.apache.lucene.util.RamUsageEstimator;

final class IndexingChain
implements Accountable {
    final Counter bytesUsed = Counter.newCounter();
    final FieldInfos.Builder fieldInfos;
    final TermsHash termsHash;
    final ByteBlockPool docValuesBytePool;
    final StoredFieldsConsumer storedFieldsConsumer;
    final VectorValuesConsumer vectorValuesConsumer;
    final TermVectorsConsumer termVectorsWriter;
    private PerField[] fieldHash = new PerField[2];
    private int hashMask = 1;
    private int totalFieldCount;
    private long nextFieldGen;
    private PerField[] fields = new PerField[1];
    private PerField[] docFields = new PerField[2];
    private final InfoStream infoStream;
    private final ByteBlockPool.Allocator byteBlockAllocator;
    private final LiveIndexWriterConfig indexWriterConfig;
    private final int indexCreatedVersionMajor;
    private final Consumer<Throwable> abortingExceptionConsumer;
    private boolean hasHitAbortingException;

    IndexingChain(int indexCreatedVersionMajor, SegmentInfo segmentInfo, Directory directory, FieldInfos.Builder fieldInfos, LiveIndexWriterConfig indexWriterConfig, Consumer<Throwable> abortingExceptionConsumer) {
        this.indexCreatedVersionMajor = indexCreatedVersionMajor;
        this.byteBlockAllocator = new ByteBlockPool.DirectTrackingAllocator(this.bytesUsed);
        IntBlockAllocator intBlockAllocator = new IntBlockAllocator(this.bytesUsed);
        this.indexWriterConfig = indexWriterConfig;
        assert (segmentInfo.getIndexSort() == indexWriterConfig.getIndexSort());
        this.fieldInfos = fieldInfos;
        this.infoStream = indexWriterConfig.getInfoStream();
        this.abortingExceptionConsumer = abortingExceptionConsumer;
        this.vectorValuesConsumer = new VectorValuesConsumer(indexWriterConfig.getCodec(), directory, segmentInfo, this.infoStream);
        if (segmentInfo.getIndexSort() == null) {
            this.storedFieldsConsumer = new StoredFieldsConsumer(indexWriterConfig.getCodec(), directory, segmentInfo);
            this.termVectorsWriter = new TermVectorsConsumer(intBlockAllocator, this.byteBlockAllocator, directory, segmentInfo, indexWriterConfig.getCodec());
        } else {
            this.storedFieldsConsumer = new SortingStoredFieldsConsumer(indexWriterConfig.getCodec(), directory, segmentInfo);
            this.termVectorsWriter = new SortingTermVectorsConsumer(intBlockAllocator, this.byteBlockAllocator, directory, segmentInfo, indexWriterConfig.getCodec());
        }
        this.termsHash = new FreqProxTermsWriter(intBlockAllocator, this.byteBlockAllocator, this.bytesUsed, this.termVectorsWriter);
        this.docValuesBytePool = new ByteBlockPool(this.byteBlockAllocator);
    }

    private void onAbortingException(Throwable th) {
        assert (th != null);
        this.hasHitAbortingException = true;
        this.abortingExceptionConsumer.accept(th);
    }

    private LeafReader getDocValuesLeafReader() {
        return new DocValuesLeafReader(){

            @Override
            public NumericDocValues getNumericDocValues(String field) {
                PerField pf = IndexingChain.this.getPerField(field);
                if (pf == null) {
                    return null;
                }
                if (pf.fieldInfo.getDocValuesType() == DocValuesType.NUMERIC) {
                    return (NumericDocValues)pf.docValuesWriter.getDocValues();
                }
                return null;
            }

            @Override
            public BinaryDocValues getBinaryDocValues(String field) {
                PerField pf = IndexingChain.this.getPerField(field);
                if (pf == null) {
                    return null;
                }
                if (pf.fieldInfo.getDocValuesType() == DocValuesType.BINARY) {
                    return (BinaryDocValues)pf.docValuesWriter.getDocValues();
                }
                return null;
            }

            @Override
            public SortedDocValues getSortedDocValues(String field) throws IOException {
                PerField pf = IndexingChain.this.getPerField(field);
                if (pf == null) {
                    return null;
                }
                if (pf.fieldInfo.getDocValuesType() == DocValuesType.SORTED) {
                    return (SortedDocValues)pf.docValuesWriter.getDocValues();
                }
                return null;
            }

            @Override
            public SortedNumericDocValues getSortedNumericDocValues(String field) throws IOException {
                PerField pf = IndexingChain.this.getPerField(field);
                if (pf == null) {
                    return null;
                }
                if (pf.fieldInfo.getDocValuesType() == DocValuesType.SORTED_NUMERIC) {
                    return (SortedNumericDocValues)pf.docValuesWriter.getDocValues();
                }
                return null;
            }

            @Override
            public SortedSetDocValues getSortedSetDocValues(String field) throws IOException {
                PerField pf = IndexingChain.this.getPerField(field);
                if (pf == null) {
                    return null;
                }
                if (pf.fieldInfo.getDocValuesType() == DocValuesType.SORTED_SET) {
                    return (SortedSetDocValues)pf.docValuesWriter.getDocValues();
                }
                return null;
            }

            @Override
            public FieldInfos getFieldInfos() {
                return IndexingChain.this.fieldInfos.finish();
            }
        };
    }

    private Sorter.DocMap maybeSortSegment(SegmentWriteState state) throws IOException {
        Sort indexSort = state.segmentInfo.getIndexSort();
        if (indexSort == null) {
            return null;
        }
        LeafReader docValuesReader = this.getDocValuesLeafReader();
        Function<Object, Object> comparatorWrapper = Function.identity();
        if (state.segmentInfo.getHasBlocks() && state.fieldInfos.getParentField() != null) {
            NumericDocValues readerValues = docValuesReader.getNumericDocValues(state.fieldInfos.getParentField());
            if (readerValues == null) {
                throw new CorruptIndexException("missing doc values for parent field \"" + state.fieldInfos.getParentField() + "\"", "IndexingChain");
            }
            BitSet parents = BitSet.of(readerValues, state.segmentInfo.maxDoc());
            comparatorWrapper = in -> (docID1, docID2) -> in.compare(parents.nextSetBit(docID1), parents.nextSetBit(docID2));
        }
        ArrayList<IndexSorter.DocComparator> comparators = new ArrayList<IndexSorter.DocComparator>();
        for (int i = 0; i < indexSort.getSort().length; ++i) {
            SortField sortField = indexSort.getSort()[i];
            IndexSorter sorter = sortField.getIndexSorter();
            if (sorter == null) {
                throw new UnsupportedOperationException("Cannot sort index using sort field " + sortField);
            }
            IndexSorter.DocComparator docComparator = sorter.getDocComparator(docValuesReader, state.segmentInfo.maxDoc());
            comparators.add((IndexSorter.DocComparator)comparatorWrapper.apply(docComparator));
        }
        Sorter sorter = new Sorter(indexSort);
        return sorter.sort(state.segmentInfo.maxDoc(), (IndexSorter.DocComparator[])comparators.toArray(IndexSorter.DocComparator[]::new));
    }

    Sorter.DocMap flush(SegmentWriteState state) throws IOException {
        Sorter.DocMap sortMap = this.maybeSortSegment(state);
        int maxDoc = state.segmentInfo.maxDoc();
        long t0 = System.nanoTime();
        this.writeNorms(state, sortMap);
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - t0) + " ms to write norms");
        }
        SegmentReadState readState = new SegmentReadState(state.directory, state.segmentInfo, state.fieldInfos, IOContext.READ, state.segmentSuffix);
        t0 = System.nanoTime();
        this.writeDocValues(state, sortMap);
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - t0) + " ms to write docValues");
        }
        t0 = System.nanoTime();
        this.writePoints(state, sortMap);
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - t0) + " ms to write points");
        }
        t0 = System.nanoTime();
        this.vectorValuesConsumer.flush(state, sortMap);
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - t0) + " ms to write vectors");
        }
        t0 = System.nanoTime();
        this.storedFieldsConsumer.finish(maxDoc);
        this.storedFieldsConsumer.flush(state, sortMap);
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - t0) + " ms to finish stored fields");
        }
        t0 = System.nanoTime();
        HashMap<String, TermsHashPerField> fieldsToFlush = new HashMap<String, TermsHashPerField>();
        for (int i = 0; i < this.fieldHash.length; ++i) {
            PerField perField = this.fieldHash[i];
            while (perField != null) {
                if (perField.invertState != null) {
                    fieldsToFlush.put(perField.fieldInfo.name, perField.termsHashPerField);
                }
                perField = perField.next;
            }
        }
        try (NormsProducer norms = readState.fieldInfos.hasNorms() ? state.segmentInfo.getCodec().normsFormat().normsProducer(readState) : null;){
            NormsProducer normsMergeInstance = null;
            if (norms != null) {
                normsMergeInstance = norms.getMergeInstance();
            }
            this.termsHash.flush(fieldsToFlush, state, sortMap, normsMergeInstance);
        }
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - t0) + " ms to write postings and finish vectors");
        }
        t0 = System.nanoTime();
        this.indexWriterConfig.getCodec().fieldInfosFormat().write(state.directory, state.segmentInfo, "", state.fieldInfos, IOContext.DEFAULT);
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - t0) + " ms to write fieldInfos");
        }
        return sortMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePoints(SegmentWriteState state, Sorter.DocMap sortMap) throws IOException {
        block12: {
            PointsWriter pointsWriter;
            block11: {
                pointsWriter = null;
                boolean success = false;
                try {
                    for (int i = 0; i < this.fieldHash.length; ++i) {
                        PerField perField = this.fieldHash[i];
                        while (perField != null) {
                            if (perField.pointValuesWriter != null) {
                                if (perField.fieldInfo.getPointDimensionCount() > 0) {
                                    if (pointsWriter == null) {
                                        PointsFormat fmt = state.segmentInfo.getCodec().pointsFormat();
                                        if (fmt == null) {
                                            throw new IllegalStateException("field=\"" + perField.fieldInfo.name + "\" was indexed as points but codec does not support points");
                                        }
                                        pointsWriter = fmt.fieldsWriter(state);
                                    }
                                    perField.pointValuesWriter.flush(state, sortMap, pointsWriter);
                                }
                                perField.pointValuesWriter = null;
                            }
                            perField = perField.next;
                        }
                    }
                    if (pointsWriter != null) {
                        pointsWriter.finish();
                    }
                    if (!(success = true)) break block11;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(pointsWriter);
                    } else {
                        IOUtils.closeWhileHandlingException(pointsWriter);
                    }
                    throw throwable;
                }
                IOUtils.close(pointsWriter);
                break block12;
            }
            IOUtils.closeWhileHandlingException(pointsWriter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDocValues(SegmentWriteState state, Sorter.DocMap sortMap) throws IOException {
        DocValuesConsumer dvConsumer;
        block16: {
            block15: {
                dvConsumer = null;
                boolean success = false;
                try {
                    for (int i = 0; i < this.fieldHash.length; ++i) {
                        PerField perField = this.fieldHash[i];
                        while (perField != null) {
                            if (perField.docValuesWriter != null) {
                                if (perField.fieldInfo.getDocValuesType() == DocValuesType.NONE) {
                                    throw new AssertionError((Object)("segment=" + state.segmentInfo + ": field=\"" + perField.fieldInfo.name + "\" has no docValues but wrote them"));
                                }
                                if (dvConsumer == null) {
                                    DocValuesFormat fmt = state.segmentInfo.getCodec().docValuesFormat();
                                    dvConsumer = fmt.fieldsConsumer(state);
                                }
                                perField.docValuesWriter.flush(state, sortMap, dvConsumer);
                                perField.docValuesWriter = null;
                            } else if (perField.fieldInfo != null && perField.fieldInfo.getDocValuesType() != DocValuesType.NONE) {
                                throw new AssertionError((Object)("segment=" + state.segmentInfo + ": field=\"" + perField.fieldInfo.name + "\" has docValues but did not write them"));
                            }
                            perField = perField.next;
                        }
                    }
                    success = true;
                    if (!success) break block15;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(dvConsumer);
                    } else {
                        IOUtils.closeWhileHandlingException(dvConsumer);
                    }
                    throw throwable;
                }
                IOUtils.close(dvConsumer);
                break block16;
            }
            IOUtils.closeWhileHandlingException(dvConsumer);
        }
        if (!state.fieldInfos.hasDocValues()) {
            if (dvConsumer != null) {
                throw new AssertionError((Object)("segment=" + state.segmentInfo + ": fieldInfos has no docValues but wrote them"));
            }
        } else if (dvConsumer == null) {
            throw new AssertionError((Object)("segment=" + state.segmentInfo + ": fieldInfos has docValues but did not wrote them"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeNorms(SegmentWriteState state, Sorter.DocMap sortMap) throws IOException {
        block10: {
            NormsConsumer normsConsumer;
            block9: {
                boolean success = false;
                normsConsumer = null;
                try {
                    if (state.fieldInfos.hasNorms()) {
                        NormsFormat normsFormat = state.segmentInfo.getCodec().normsFormat();
                        assert (normsFormat != null);
                        normsConsumer = normsFormat.normsConsumer(state);
                        for (FieldInfo fi : state.fieldInfos) {
                            PerField perField = this.getPerField(fi.name);
                            assert (perField != null);
                            if (fi.omitsNorms() || fi.getIndexOptions() == IndexOptions.NONE) continue;
                            assert (perField.norms != null) : "field=" + fi.name;
                            perField.norms.finish(state.segmentInfo.maxDoc());
                            perField.norms.flush(state, sortMap, normsConsumer);
                        }
                    }
                    if (!(success = true)) break block9;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(normsConsumer);
                    } else {
                        IOUtils.closeWhileHandlingException(normsConsumer);
                    }
                    throw throwable;
                }
                IOUtils.close(normsConsumer);
                break block10;
            }
            IOUtils.closeWhileHandlingException(normsConsumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void abort() throws IOException {
        try (Closeable finalizer = this.termsHash::abort;){
            this.storedFieldsConsumer.abort();
            this.vectorValuesConsumer.abort();
        }
        finally {
            Arrays.fill(this.fieldHash, null);
        }
    }

    private void rehash() {
        int newHashSize = this.fieldHash.length * 2;
        assert (newHashSize > this.fieldHash.length);
        PerField[] newHashArray = new PerField[newHashSize];
        int newHashMask = newHashSize - 1;
        for (int j = 0; j < this.fieldHash.length; ++j) {
            PerField fp0 = this.fieldHash[j];
            while (fp0 != null) {
                int hashPos2 = fp0.fieldName.hashCode() & newHashMask;
                PerField nextFP0 = fp0.next;
                fp0.next = newHashArray[hashPos2];
                newHashArray[hashPos2] = fp0;
                fp0 = nextFP0;
            }
        }
        this.fieldHash = newHashArray;
        this.hashMask = newHashMask;
    }

    private void startStoredFields(int docID) throws IOException {
        try {
            this.storedFieldsConsumer.startDocument(docID);
        }
        catch (Throwable th) {
            this.onAbortingException(th);
            throw th;
        }
    }

    private void finishStoredFields() throws IOException {
        try {
            this.storedFieldsConsumer.finishDocument();
        }
        catch (Throwable th) {
            this.onAbortingException(th);
            throw th;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processDocument(int docID, Iterable<? extends IndexableField> document) throws IOException {
        int fieldCount = 0;
        int indexedFieldCount = 0;
        long fieldGen = this.nextFieldGen++;
        int docFieldIdx = 0;
        this.termsHash.startDocument();
        this.startStoredFields(docID);
        try {
            for (IndexableField indexableField : document) {
                IndexableFieldType fieldType = indexableField.fieldType();
                boolean isReserved = indexableField.getClass() == ReservedField.class;
                PerField pf = this.getOrAddPerField(indexableField.name(), false);
                if (pf.reserved != isReserved) {
                    throw new IllegalArgumentException("\"" + indexableField.name() + "\" is a reserved field and should not be added to any document");
                }
                if (pf.fieldGen != fieldGen) {
                    this.fields[fieldCount++] = pf;
                    pf.fieldGen = fieldGen;
                    pf.reset(docID);
                }
                if (docFieldIdx >= this.docFields.length) {
                    this.oversizeDocFields();
                }
                this.docFields[docFieldIdx++] = pf;
                IndexingChain.updateDocFieldSchema(indexableField.name(), pf.schema, fieldType);
            }
            for (int i = 0; i < fieldCount; ++i) {
                PerField perField = this.fields[i];
                if (perField.fieldInfo == null) {
                    this.initializeFieldInfo(perField);
                    continue;
                }
                perField.schema.assertSameSchema(perField.fieldInfo);
            }
            docFieldIdx = 0;
            for (IndexableField indexableField : document) {
                if (this.processField(docID, indexableField, this.docFields[docFieldIdx])) {
                    this.fields[indexedFieldCount] = this.docFields[docFieldIdx];
                    ++indexedFieldCount;
                }
                ++docFieldIdx;
            }
        }
        finally {
            if (!this.hasHitAbortingException) {
                for (int i = 0; i < indexedFieldCount; ++i) {
                    this.fields[i].finish(docID);
                }
                this.finishStoredFields();
                try {
                    this.termsHash.finishDocument(docID);
                }
                catch (Throwable th) {
                    this.abortingExceptionConsumer.accept(th);
                    throw th;
                }
            }
        }
    }

    private void oversizeDocFields() {
        PerField[] newDocFields = new PerField[ArrayUtil.oversize(this.docFields.length + 1, RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
        System.arraycopy(this.docFields, 0, newDocFields, 0, this.docFields.length);
        this.docFields = newDocFields;
    }

    private void initializeFieldInfo(PerField pf) throws IOException {
        FieldSchema s = pf.schema;
        if (this.indexWriterConfig.getIndexSort() != null && s.docValuesType != DocValuesType.NONE) {
            Sort indexSort = this.indexWriterConfig.getIndexSort();
            this.validateIndexSortDVType(indexSort, pf.fieldName, s.docValuesType);
        }
        if (s.vectorDimension != 0) {
            IndexingChain.validateMaxVectorDimension(pf.fieldName, s.vectorDimension, this.indexWriterConfig.getCodec().knnVectorsFormat().getMaxDimensions(pf.fieldName));
        }
        FieldInfo fi = this.fieldInfos.add(new FieldInfo(pf.fieldName, -1, s.storeTermVector, s.omitNorms, false, s.indexOptions, s.docValuesType, -1L, s.attributes, s.pointDimensionCount, s.pointIndexDimensionCount, s.pointNumBytes, s.vectorDimension, s.vectorEncoding, s.vectorSimilarityFunction, pf.fieldName.equals(this.fieldInfos.getSoftDeletesFieldName()), pf.fieldName.equals(this.fieldInfos.getParentFieldName())));
        pf.setFieldInfo(fi);
        if (fi.getIndexOptions() != IndexOptions.NONE) {
            pf.setInvertState();
        }
        DocValuesType dvType = fi.getDocValuesType();
        switch (dvType) {
            case NONE: {
                break;
            }
            case NUMERIC: {
                pf.docValuesWriter = new NumericDocValuesWriter(fi, this.bytesUsed);
                break;
            }
            case BINARY: {
                pf.docValuesWriter = new BinaryDocValuesWriter(fi, this.bytesUsed);
                break;
            }
            case SORTED: {
                pf.docValuesWriter = new SortedDocValuesWriter(fi, this.bytesUsed, this.docValuesBytePool);
                break;
            }
            case SORTED_NUMERIC: {
                pf.docValuesWriter = new SortedNumericDocValuesWriter(fi, this.bytesUsed);
                break;
            }
            case SORTED_SET: {
                pf.docValuesWriter = new SortedSetDocValuesWriter(fi, this.bytesUsed, this.docValuesBytePool);
                break;
            }
            default: {
                throw new AssertionError((Object)("unrecognized DocValues.Type: " + dvType));
            }
        }
        if (fi.getPointDimensionCount() != 0) {
            pf.pointValuesWriter = new PointValuesWriter(this.bytesUsed, fi);
        }
        if (fi.getVectorDimension() != 0) {
            try {
                pf.knnFieldVectorsWriter = this.vectorValuesConsumer.addField(fi);
            }
            catch (Throwable th) {
                this.onAbortingException(th);
                throw th;
            }
        }
    }

    private boolean processField(int docID, IndexableField field, PerField pf) throws IOException {
        DocValuesType dvType;
        IndexableFieldType fieldType = field.fieldType();
        boolean indexedField = false;
        if (fieldType.indexOptions() != IndexOptions.NONE) {
            if (pf.first) {
                pf.invert(docID, field, true);
                pf.first = false;
                indexedField = true;
            } else {
                pf.invert(docID, field, false);
            }
        }
        if (fieldType.stored()) {
            StoredValue storedValue = field.storedValue();
            if (storedValue == null) {
                throw new IllegalArgumentException("Cannot store a null value");
            }
            if (storedValue.getType() == StoredValue.Type.STRING && storedValue.getStringValue().length() > IndexWriter.MAX_STORED_STRING_LENGTH) {
                throw new IllegalArgumentException("stored field \"" + field.name() + "\" is too large (" + storedValue.getStringValue().length() + " characters) to store");
            }
            try {
                this.storedFieldsConsumer.writeField(pf.fieldInfo, storedValue);
            }
            catch (Throwable th) {
                this.onAbortingException(th);
                throw th;
            }
        }
        if ((dvType = fieldType.docValuesType()) != DocValuesType.NONE) {
            this.indexDocValue(docID, pf, dvType, field);
        }
        if (fieldType.pointDimensionCount() != 0) {
            pf.pointValuesWriter.addPackedValue(docID, field.binaryValue());
        }
        if (fieldType.vectorDimension() != 0) {
            this.indexVectorValue(docID, pf, fieldType.vectorEncoding(), field);
        }
        return indexedField;
    }

    private PerField getOrAddPerField(String fieldName, boolean reserved) {
        int hashPos = fieldName.hashCode() & this.hashMask;
        PerField pf = this.fieldHash[hashPos];
        while (pf != null && !pf.fieldName.equals(fieldName)) {
            pf = pf.next;
        }
        if (pf == null) {
            FieldSchema schema = new FieldSchema(fieldName);
            pf = new PerField(fieldName, this.indexCreatedVersionMajor, schema, this.indexWriterConfig.getSimilarity(), this.indexWriterConfig.getInfoStream(), this.indexWriterConfig.getAnalyzer(), reserved);
            pf.next = this.fieldHash[hashPos];
            this.fieldHash[hashPos] = pf;
            ++this.totalFieldCount;
            if (this.totalFieldCount >= this.fieldHash.length / 2) {
                this.rehash();
            }
            if (this.totalFieldCount > this.fields.length) {
                PerField[] newFields = new PerField[ArrayUtil.oversize(this.totalFieldCount, RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
                System.arraycopy(this.fields, 0, newFields, 0, this.fields.length);
                this.fields = newFields;
            }
        }
        return pf;
    }

    private static void updateDocFieldSchema(String fieldName, FieldSchema schema, IndexableFieldType fieldType) {
        if (fieldType.indexOptions() != IndexOptions.NONE) {
            schema.setIndexOptions(fieldType.indexOptions(), fieldType.omitNorms(), fieldType.storeTermVectors());
        } else {
            IndexingChain.verifyUnIndexedFieldType(fieldName, fieldType);
        }
        if (fieldType.docValuesType() != DocValuesType.NONE) {
            schema.setDocValues(fieldType.docValuesType());
        }
        if (fieldType.pointDimensionCount() != 0) {
            schema.setPoints(fieldType.pointDimensionCount(), fieldType.pointIndexDimensionCount(), fieldType.pointNumBytes());
        }
        if (fieldType.vectorDimension() != 0) {
            schema.setVectors(fieldType.vectorEncoding(), fieldType.vectorSimilarityFunction(), fieldType.vectorDimension());
        }
        if (fieldType.getAttributes() != null && !fieldType.getAttributes().isEmpty()) {
            schema.updateAttributes(fieldType.getAttributes());
        }
    }

    private static void verifyUnIndexedFieldType(String name, IndexableFieldType ft) {
        if (ft.storeTermVectors()) {
            throw new IllegalArgumentException("cannot store term vectors for a field that is not indexed (field=\"" + name + "\")");
        }
        if (ft.storeTermVectorPositions()) {
            throw new IllegalArgumentException("cannot store term vector positions for a field that is not indexed (field=\"" + name + "\")");
        }
        if (ft.storeTermVectorOffsets()) {
            throw new IllegalArgumentException("cannot store term vector offsets for a field that is not indexed (field=\"" + name + "\")");
        }
        if (ft.storeTermVectorPayloads()) {
            throw new IllegalArgumentException("cannot store term vector payloads for a field that is not indexed (field=\"" + name + "\")");
        }
    }

    private static void validateMaxVectorDimension(String fieldName, int vectorDim, int maxVectorDim) {
        if (vectorDim > maxVectorDim) {
            throw new IllegalArgumentException("Field [" + fieldName + "] vector's dimensions must be <= [" + maxVectorDim + "]; got " + vectorDim);
        }
    }

    private void validateIndexSortDVType(Sort indexSort, final String fieldToValidate, final DocValuesType dvType) throws IOException {
        for (final SortField sortField : indexSort.getSort()) {
            IndexSorter sorter = sortField.getIndexSorter();
            if (sorter == null) {
                throw new IllegalStateException("Cannot sort index with sort order " + sortField);
            }
            sorter.getDocComparator(new DocValuesLeafReader(){

                @Override
                public NumericDocValues getNumericDocValues(String field) {
                    if (Objects.equals(field, fieldToValidate) && dvType != DocValuesType.NUMERIC) {
                        throw new IllegalArgumentException("SortField " + sortField + " expected field [" + field + "] to be NUMERIC but it is [" + dvType + "]");
                    }
                    return DocValues.emptyNumeric();
                }

                @Override
                public BinaryDocValues getBinaryDocValues(String field) {
                    if (Objects.equals(field, fieldToValidate) && dvType != DocValuesType.BINARY) {
                        throw new IllegalArgumentException("SortField " + sortField + " expected field [" + field + "] to be BINARY but it is [" + dvType + "]");
                    }
                    return DocValues.emptyBinary();
                }

                @Override
                public SortedDocValues getSortedDocValues(String field) {
                    if (Objects.equals(field, fieldToValidate) && dvType != DocValuesType.SORTED) {
                        throw new IllegalArgumentException("SortField " + sortField + " expected field [" + field + "] to be SORTED but it is [" + dvType + "]");
                    }
                    return DocValues.emptySorted();
                }

                @Override
                public SortedNumericDocValues getSortedNumericDocValues(String field) {
                    if (Objects.equals(field, fieldToValidate) && dvType != DocValuesType.SORTED_NUMERIC) {
                        throw new IllegalArgumentException("SortField " + sortField + " expected field [" + field + "] to be SORTED_NUMERIC but it is [" + dvType + "]");
                    }
                    return DocValues.emptySortedNumeric();
                }

                @Override
                public SortedSetDocValues getSortedSetDocValues(String field) {
                    if (Objects.equals(field, fieldToValidate) && dvType != DocValuesType.SORTED_SET) {
                        throw new IllegalArgumentException("SortField " + sortField + " expected field [" + field + "] to be SORTED_SET but it is [" + dvType + "]");
                    }
                    return DocValues.emptySortedSet();
                }

                @Override
                public FieldInfos getFieldInfos() {
                    throw new UnsupportedOperationException();
                }
            }, 0);
        }
    }

    private void indexDocValue(int docID, PerField fp, DocValuesType dvType, IndexableField field) {
        switch (dvType) {
            case NUMERIC: {
                if (field.numericValue() == null) {
                    throw new IllegalArgumentException("field=\"" + fp.fieldInfo.name + "\": null value not allowed");
                }
                ((NumericDocValuesWriter)fp.docValuesWriter).addValue(docID, field.numericValue().longValue());
                break;
            }
            case BINARY: {
                ((BinaryDocValuesWriter)fp.docValuesWriter).addValue(docID, field.binaryValue());
                break;
            }
            case SORTED: {
                ((SortedDocValuesWriter)fp.docValuesWriter).addValue(docID, field.binaryValue());
                break;
            }
            case SORTED_NUMERIC: {
                ((SortedNumericDocValuesWriter)fp.docValuesWriter).addValue(docID, field.numericValue().longValue());
                break;
            }
            case SORTED_SET: {
                ((SortedSetDocValuesWriter)fp.docValuesWriter).addValue(docID, field.binaryValue());
                break;
            }
            default: {
                throw new AssertionError((Object)("unrecognized DocValues.Type: " + dvType));
            }
        }
    }

    private void indexVectorValue(int docID, PerField pf, VectorEncoding vectorEncoding, IndexableField field) throws IOException {
        switch (vectorEncoding) {
            case BYTE: {
                pf.knnFieldVectorsWriter.addValue(docID, ((KnnByteVectorField)field).vectorValue());
                break;
            }
            case FLOAT32: {
                pf.knnFieldVectorsWriter.addValue(docID, ((KnnFloatVectorField)field).vectorValue());
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown vector encoding=" + vectorEncoding);
            }
        }
    }

    private PerField getPerField(String name) {
        int hashPos = name.hashCode() & this.hashMask;
        PerField fp = this.fieldHash[hashPos];
        while (fp != null && !fp.fieldName.equals(name)) {
            fp = fp.next;
        }
        return fp;
    }

    @Override
    public long ramBytesUsed() {
        return this.bytesUsed.get() + this.storedFieldsConsumer.accountable.ramBytesUsed() + this.termVectorsWriter.accountable.ramBytesUsed() + this.vectorValuesConsumer.getAccountable().ramBytesUsed();
    }

    @Override
    public Collection<Accountable> getChildResources() {
        return List.of(this.storedFieldsConsumer.accountable, this.termVectorsWriter.accountable, this.vectorValuesConsumer.getAccountable());
    }

    DocIdSetIterator getHasDocValues(String field) {
        PerField perField = this.getPerField(field);
        if (perField != null && perField.docValuesWriter != null) {
            if (perField.fieldInfo.getDocValuesType() == DocValuesType.NONE) {
                return null;
            }
            return perField.docValuesWriter.getDocValues();
        }
        return null;
    }

    <T extends IndexableField> ReservedField<T> markAsReserved(T field) {
        this.getOrAddPerField(field.name(), true);
        return new ReservedField<T>(field);
    }

    static final class ReservedField<T extends IndexableField>
    implements IndexableField {
        private final T delegate;

        private ReservedField(T delegate) {
            this.delegate = delegate;
        }

        T getDelegate() {
            return this.delegate;
        }

        @Override
        public String name() {
            return this.delegate.name();
        }

        @Override
        public IndexableFieldType fieldType() {
            return this.delegate.fieldType();
        }

        @Override
        public TokenStream tokenStream(Analyzer analyzer, TokenStream reuse) {
            return this.delegate.tokenStream(analyzer, reuse);
        }

        @Override
        public BytesRef binaryValue() {
            return this.delegate.binaryValue();
        }

        @Override
        public String stringValue() {
            return this.delegate.stringValue();
        }

        @Override
        public CharSequence getCharSequenceValue() {
            return this.delegate.getCharSequenceValue();
        }

        @Override
        public Reader readerValue() {
            return this.delegate.readerValue();
        }

        @Override
        public Number numericValue() {
            return this.delegate.numericValue();
        }

        @Override
        public StoredValue storedValue() {
            return this.delegate.storedValue();
        }

        @Override
        public InvertableType invertableType() {
            return this.delegate.invertableType();
        }
    }

    private static final class FieldSchema {
        private final String name;
        private int docID = 0;
        private final Map<String, String> attributes = new HashMap<String, String>();
        private boolean omitNorms = false;
        private boolean storeTermVector = false;
        private IndexOptions indexOptions = IndexOptions.NONE;
        private DocValuesType docValuesType = DocValuesType.NONE;
        private int pointDimensionCount = 0;
        private int pointIndexDimensionCount = 0;
        private int pointNumBytes = 0;
        private int vectorDimension = 0;
        private VectorEncoding vectorEncoding = VectorEncoding.FLOAT32;
        private VectorSimilarityFunction vectorSimilarityFunction = VectorSimilarityFunction.EUCLIDEAN;
        private static String errMsg = "Inconsistency of field data structures across documents for field ";

        FieldSchema(String name) {
            this.name = name;
        }

        private void assertSame(String label, boolean expected, boolean given) {
            if (expected != given) {
                this.raiseNotSame(label, expected, given);
            }
        }

        private void assertSame(String label, int expected, int given) {
            if (expected != given) {
                this.raiseNotSame(label, expected, given);
            }
        }

        private <T extends Enum<?>> void assertSame(String label, T expected, T given) {
            if (expected != given) {
                this.raiseNotSame(label, expected, given);
            }
        }

        private void raiseNotSame(String label, Object expected, Object given) {
            throw new IllegalArgumentException(errMsg + "[" + this.name + "] of doc [" + this.docID + "]. " + label + ": expected '" + expected + "', but it has '" + given + "'.");
        }

        void updateAttributes(Map<String, String> attrs) {
            attrs.forEach((k, v) -> this.attributes.put((String)k, (String)v));
        }

        void setIndexOptions(IndexOptions newIndexOptions, boolean newOmitNorms, boolean newStoreTermVector) {
            if (this.indexOptions == IndexOptions.NONE) {
                this.indexOptions = newIndexOptions;
                this.omitNorms = newOmitNorms;
                this.storeTermVector = newStoreTermVector;
            } else {
                this.assertSame("index options", this.indexOptions, newIndexOptions);
                this.assertSame("omit norms", this.omitNorms, newOmitNorms);
                this.assertSame("store term vector", this.storeTermVector, newStoreTermVector);
            }
        }

        void setDocValues(DocValuesType newDocValuesType) {
            if (this.docValuesType == DocValuesType.NONE) {
                this.docValuesType = newDocValuesType;
            } else {
                this.assertSame("doc values type", this.docValuesType, newDocValuesType);
            }
        }

        void setPoints(int dimensionCount, int indexDimensionCount, int numBytes) {
            if (this.pointIndexDimensionCount == 0) {
                this.pointDimensionCount = dimensionCount;
                this.pointIndexDimensionCount = indexDimensionCount;
                this.pointNumBytes = numBytes;
            } else {
                this.assertSame("point dimension", this.pointDimensionCount, dimensionCount);
                this.assertSame("point index dimension", this.pointIndexDimensionCount, indexDimensionCount);
                this.assertSame("point num bytes", this.pointNumBytes, numBytes);
            }
        }

        void setVectors(VectorEncoding encoding, VectorSimilarityFunction similarityFunction, int dimension) {
            if (this.vectorDimension == 0) {
                this.vectorEncoding = encoding;
                this.vectorSimilarityFunction = similarityFunction;
                this.vectorDimension = dimension;
            } else {
                this.assertSame("vector encoding", this.vectorEncoding, encoding);
                this.assertSame("vector similarity function", this.vectorSimilarityFunction, similarityFunction);
                this.assertSame("vector dimension", this.vectorDimension, dimension);
            }
        }

        void reset(int doc) {
            this.docID = doc;
            this.omitNorms = false;
            this.storeTermVector = false;
            this.indexOptions = IndexOptions.NONE;
            this.docValuesType = DocValuesType.NONE;
            this.pointDimensionCount = 0;
            this.pointIndexDimensionCount = 0;
            this.pointNumBytes = 0;
            this.vectorDimension = 0;
            this.vectorEncoding = VectorEncoding.FLOAT32;
            this.vectorSimilarityFunction = VectorSimilarityFunction.EUCLIDEAN;
        }

        void assertSameSchema(FieldInfo fi) {
            this.assertSame("index options", fi.getIndexOptions(), this.indexOptions);
            this.assertSame("omit norms", fi.omitsNorms(), this.omitNorms);
            this.assertSame("store term vector", fi.hasVectors(), this.storeTermVector);
            this.assertSame("doc values type", fi.getDocValuesType(), this.docValuesType);
            this.assertSame("vector similarity function", fi.getVectorSimilarityFunction(), this.vectorSimilarityFunction);
            this.assertSame("vector encoding", fi.getVectorEncoding(), this.vectorEncoding);
            this.assertSame("vector dimension", fi.getVectorDimension(), this.vectorDimension);
            this.assertSame("point dimension", fi.getPointDimensionCount(), this.pointDimensionCount);
            this.assertSame("point index dimension", fi.getPointIndexDimensionCount(), this.pointIndexDimensionCount);
            this.assertSame("point num bytes", fi.getPointNumBytes(), this.pointNumBytes);
        }
    }

    private static class IntBlockAllocator
    extends IntBlockPool.Allocator {
        private final Counter bytesUsed;

        IntBlockAllocator(Counter bytesUsed) {
            super(8192);
            this.bytesUsed = bytesUsed;
        }

        @Override
        public int[] getIntBlock() {
            int[] b = new int[8192];
            this.bytesUsed.addAndGet(32768L);
            return b;
        }

        @Override
        public void recycleIntBlocks(int[][] blocks, int offset, int length) {
            this.bytesUsed.addAndGet(-(length * 32768));
        }
    }

    private final class PerField
    implements Comparable<PerField> {
        final String fieldName;
        final int indexCreatedVersionMajor;
        final FieldSchema schema;
        final boolean reserved;
        FieldInfo fieldInfo;
        final Similarity similarity;
        FieldInvertState invertState;
        TermsHashPerField termsHashPerField;
        DocValuesWriter<?> docValuesWriter;
        PointValuesWriter pointValuesWriter;
        KnnFieldVectorsWriter<?> knnFieldVectorsWriter;
        long fieldGen = -1L;
        PerField next;
        NormValuesWriter norms;
        TokenStream tokenStream;
        private final InfoStream infoStream;
        private final Analyzer analyzer;
        private boolean first;

        PerField(String fieldName, int indexCreatedVersionMajor, FieldSchema schema, Similarity similarity, InfoStream infoStream, Analyzer analyzer, boolean reserved) {
            this.fieldName = fieldName;
            this.indexCreatedVersionMajor = indexCreatedVersionMajor;
            this.schema = schema;
            this.similarity = similarity;
            this.infoStream = infoStream;
            this.analyzer = analyzer;
            this.reserved = reserved;
        }

        void reset(int docId) {
            this.first = true;
            this.schema.reset(docId);
        }

        void setFieldInfo(FieldInfo fieldInfo) {
            assert (this.fieldInfo == null);
            this.fieldInfo = fieldInfo;
        }

        void setInvertState() {
            this.invertState = new FieldInvertState(this.indexCreatedVersionMajor, this.fieldInfo.name, this.fieldInfo.getIndexOptions());
            this.termsHashPerField = IndexingChain.this.termsHash.addField(this.invertState, this.fieldInfo);
            if (!this.fieldInfo.omitsNorms()) {
                assert (this.norms == null);
                this.norms = new NormValuesWriter(this.fieldInfo, IndexingChain.this.bytesUsed);
            }
            if (this.fieldInfo.hasVectors()) {
                IndexingChain.this.termVectorsWriter.setHasVectors();
            }
        }

        @Override
        public int compareTo(PerField other) {
            return this.fieldName.compareTo(other.fieldName);
        }

        public void finish(int docID) throws IOException {
            if (!this.fieldInfo.omitsNorms()) {
                long normValue;
                if (this.invertState.length == 0) {
                    normValue = 0L;
                } else {
                    normValue = this.similarity.computeNorm(this.invertState);
                    if (normValue == 0L) {
                        throw new IllegalStateException("Similarity " + this.similarity + " return 0 for non-empty field");
                    }
                }
                this.norms.addValue(docID, normValue);
            }
            this.termsHashPerField.finish();
        }

        public void invert(int docID, IndexableField field, boolean first) throws IOException {
            assert (field.fieldType().indexOptions().compareTo(IndexOptions.DOCS) >= 0);
            if (first) {
                this.invertState.reset();
            }
            switch (field.invertableType()) {
                case BINARY: {
                    this.invertTerm(docID, field, first);
                    break;
                }
                case TOKEN_STREAM: {
                    this.invertTokenStream(docID, field, first);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void invertTokenStream(int docID, IndexableField field, boolean first) throws IOException {
            boolean analyzed = field.fieldType().tokenized() && this.analyzer != null;
            boolean succeededInProcessingField = false;
            try (TokenStream stream = this.tokenStream = field.tokenStream(this.analyzer, this.tokenStream);){
                stream.reset();
                this.invertState.setAttributeSource(stream);
                this.termsHashPerField.start(field, first);
                while (stream.incrementToken()) {
                    int posIncr = this.invertState.posIncrAttribute.getPositionIncrement();
                    this.invertState.position += posIncr;
                    if (this.invertState.position < this.invertState.lastPosition) {
                        if (posIncr == 0) {
                            throw new IllegalArgumentException("first position increment must be > 0 (got 0) for field '" + field.name() + "'");
                        }
                        if (posIncr < 0) {
                            throw new IllegalArgumentException("position increment must be >= 0 (got " + posIncr + ") for field '" + field.name() + "'");
                        }
                        throw new IllegalArgumentException("position overflowed Integer.MAX_VALUE (got posIncr=" + posIncr + " lastPosition=" + this.invertState.lastPosition + " position=" + this.invertState.position + ") for field '" + field.name() + "'");
                    }
                    if (this.invertState.position > 0x7FFFFF7F) {
                        throw new IllegalArgumentException("position " + this.invertState.position + " is too large for field '" + field.name() + "': max allowed position is 2147483519");
                    }
                    this.invertState.lastPosition = this.invertState.position;
                    if (posIncr == 0) {
                        ++this.invertState.numOverlap;
                    }
                    int startOffset = this.invertState.offset + this.invertState.offsetAttribute.startOffset();
                    int endOffset = this.invertState.offset + this.invertState.offsetAttribute.endOffset();
                    if (startOffset < this.invertState.lastStartOffset || endOffset < startOffset) {
                        throw new IllegalArgumentException("startOffset must be non-negative, and endOffset must be >= startOffset, and offsets must not go backwards startOffset=" + startOffset + ",endOffset=" + endOffset + ",lastStartOffset=" + this.invertState.lastStartOffset + " for field '" + field.name() + "'");
                    }
                    this.invertState.lastStartOffset = startOffset;
                    try {
                        this.invertState.length = Math.addExact(this.invertState.length, this.invertState.termFreqAttribute.getTermFrequency());
                    }
                    catch (ArithmeticException ae) {
                        throw new IllegalArgumentException("too many tokens for field \"" + field.name() + "\"", ae);
                    }
                    try {
                        this.termsHashPerField.add(this.invertState.termAttribute.getBytesRef(), docID);
                    }
                    catch (BytesRefHash.MaxBytesLengthExceededException e2) {
                        byte[] prefix = new byte[30];
                        BytesRef bigTerm = this.invertState.termAttribute.getBytesRef();
                        System.arraycopy(bigTerm.bytes, bigTerm.offset, prefix, 0, 30);
                        String msg = "Document contains at least one immense term in field=\"" + this.fieldInfo.name + "\" (whose UTF8 encoding is longer than the max length 32766), all of which were skipped.  Please correct the analyzer to not produce such terms.  The prefix of the first immense term is: '" + Arrays.toString(prefix) + "...', original message: " + e2.getMessage();
                        if (this.infoStream.isEnabled("IW")) {
                            this.infoStream.message("IW", "ERROR: " + msg);
                        }
                        throw new IllegalArgumentException(msg, e2);
                    }
                    catch (Throwable th) {
                        IndexingChain.this.onAbortingException(th);
                        throw th;
                    }
                }
                stream.end();
                this.invertState.position += this.invertState.posIncrAttribute.getPositionIncrement();
                this.invertState.offset += this.invertState.offsetAttribute.endOffset();
                succeededInProcessingField = true;
            }
            finally {
                if (!succeededInProcessingField && this.infoStream.isEnabled("DW")) {
                    this.infoStream.message("DW", "An exception was thrown while processing field " + this.fieldInfo.name);
                }
            }
            if (analyzed) {
                this.invertState.position += this.analyzer.getPositionIncrementGap(this.fieldInfo.name);
                this.invertState.offset += this.analyzer.getOffsetGap(this.fieldInfo.name);
            }
        }

        private void invertTerm(int docID, IndexableField field, boolean first) throws IOException {
            BytesRef binaryValue = field.binaryValue();
            if (binaryValue == null) {
                throw new IllegalArgumentException("Field " + field.name() + " returns TERM for invertableType() and null for binaryValue(), which is illegal");
            }
            IndexableFieldType fieldType = field.fieldType();
            if (fieldType.tokenized() || fieldType.indexOptions().compareTo(IndexOptions.DOCS_AND_FREQS) > 0 || fieldType.storeTermVectorPositions() || fieldType.storeTermVectorOffsets() || fieldType.storeTermVectorPayloads()) {
                throw new IllegalArgumentException("Fields that are tokenized or index proximity data must produce a non-null TokenStream, but " + field.name() + " did not");
            }
            this.invertState.setAttributeSource(null);
            ++this.invertState.position;
            ++this.invertState.length;
            this.termsHashPerField.start(field, first);
            this.invertState.length = Math.addExact(this.invertState.length, 1);
            try {
                this.termsHashPerField.add(binaryValue, docID);
            }
            catch (BytesRefHash.MaxBytesLengthExceededException e2) {
                byte[] prefix = new byte[30];
                System.arraycopy(binaryValue.bytes, binaryValue.offset, prefix, 0, 30);
                String msg = "Document contains at least one immense term in field=\"" + this.fieldInfo.name + "\" (whose length is longer than the max length 32766), all of which were skipped. The prefix of the first immense term is: '" + Arrays.toString(prefix) + "...'";
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "ERROR: " + msg);
                }
                throw new IllegalArgumentException(msg, e2);
            }
        }
    }
}

