/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.converter;

import java.util.Set;
import org.apache.sis.converter.SystemConverter;
import org.apache.sis.math.Fraction;
import org.apache.sis.math.FunctionProperty;
import org.apache.sis.util.ObjectConverter;
import org.apache.sis.util.UnconvertibleObjectException;
import org.apache.sis.util.resources.Errors;

public final class FractionConverter
extends SystemConverter<Fraction, Integer> {
    private static final long serialVersionUID = 862676960870569201L;
    public static final FractionConverter INSTANCE = new FractionConverter();

    public FractionConverter() {
        super(Fraction.class, Integer.class);
    }

    @Override
    public ObjectConverter<Fraction, Integer> unique() {
        return INSTANCE;
    }

    @Override
    public Set<FunctionProperty> properties() {
        return FractionConverter.bijective();
    }

    @Override
    public Integer apply(Fraction value) throws UnconvertibleObjectException {
        if (value.numerator % value.denominator == 0) {
            return value.numerator / value.denominator;
        }
        throw new UnconvertibleObjectException(Errors.format((short)8, value, Integer.class));
    }

    @Override
    public ObjectConverter<Integer, Fraction> inverse() {
        return FromInteger.INSTANCE;
    }

    public static final class FromInteger
    extends SystemConverter<Integer, Fraction> {
        private static final long serialVersionUID = 7411811921783941007L;
        public static final FromInteger INSTANCE = new FromInteger();

        public FromInteger() {
            super(Integer.class, Fraction.class);
        }

        @Override
        public ObjectConverter<Integer, Fraction> unique() {
            return INSTANCE;
        }

        @Override
        public ObjectConverter<Fraction, Integer> inverse() {
            return INSTANCE;
        }

        @Override
        public Set<FunctionProperty> properties() {
            return FromInteger.bijective();
        }

        @Override
        public Fraction apply(Integer value) {
            return new Fraction(value, 1);
        }
    }
}

