/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.jena.sparql.function.library.triple;

import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.function.FunctionRegistry;

public class TripleTermFunctions {
    public static void register(FunctionRegistry functionRegistry) {
        functionRegistry.put(ARQConstants.ARQFunctionLibraryURI+"subject",    TripleSubject.class);
        functionRegistry.put(ARQConstants.ARQFunctionLibraryURI+"predicate",  TriplePredicate.class);
        functionRegistry.put(ARQConstants.ARQFunctionLibraryURI+"object",     TripleObject.class);
        functionRegistry.put(ARQConstants.ARQFunctionLibraryURI+"triple",     TripleTerm.class);
        functionRegistry.put(ARQConstants.ARQFunctionLibraryURI+"isTriple",   IsTripleTerm.class);
    }
}
