/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.mock2;

import org.apache.juneau.marshall.Html;
import org.apache.juneau.marshall.Json;
import org.apache.juneau.marshall.Marshall;
import org.apache.juneau.marshall.MsgPack;
import org.apache.juneau.marshall.OpenApi;
import org.apache.juneau.marshall.PlainText;
import org.apache.juneau.marshall.SimpleJson;
import org.apache.juneau.marshall.Uon;
import org.apache.juneau.marshall.UrlEncoding;
import org.apache.juneau.marshall.Xml;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.rest.client.RestClient;
import org.apache.juneau.rest.client.RestClientBuilder;
import org.apache.juneau.rest.mock2.MockHttpClientConnectionManager;
import org.apache.juneau.rest.mock2.MockRest;
import org.apache.juneau.serializer.Serializer;

public class MockRestClient
extends RestClientBuilder {
    private MockRest.Builder mrb;

    protected MockRestClient(Object impl) {
        super(null, null);
        this.mrb = MockRest.create(impl);
        this.rootUrl("http://localhost");
    }

    public static MockRestClient create(Object impl) {
        return new MockRestClient(impl);
    }

    public static MockRestClient create(Object impl, Marshall m) {
        return MockRestClient.create(impl).marshall(m);
    }

    public static MockRestClient create(Object impl, Serializer s, Parser p) {
        return MockRestClient.create(impl).serializer(s).parser(p);
    }

    public static RestClient build(Object impl, Marshall m) {
        return MockRestClient.create(impl, m).build();
    }

    public static RestClient build(Object impl, Serializer s, Parser p) {
        return MockRestClient.create(impl, s, p).build();
    }

    public RestClient build() {
        this.httpClientConnectionManager(new MockHttpClientConnectionManager(this.mrb.build()));
        return super.build();
    }

    public MockRestClient debug() {
        this.mrb.debug();
        this.debug();
        return this;
    }

    public MockRestClient json() {
        this.marshall((Marshall)Json.DEFAULT);
        return this;
    }

    public MockRestClient simpleJson() {
        this.marshall((Marshall)SimpleJson.DEFAULT);
        return this;
    }

    public MockRestClient xml() {
        this.marshall((Marshall)Xml.DEFAULT);
        return this;
    }

    public MockRestClient html() {
        this.marshall((Marshall)Html.DEFAULT);
        return this;
    }

    public MockRestClient plainText() {
        this.marshall((Marshall)PlainText.DEFAULT);
        return this;
    }

    public MockRestClient msgpack() {
        this.marshall((Marshall)MsgPack.DEFAULT);
        return this;
    }

    public MockRestClient uon() {
        this.marshall((Marshall)Uon.DEFAULT);
        return this;
    }

    public MockRestClient urlEnc() {
        this.marshall((Marshall)UrlEncoding.DEFAULT);
        return this;
    }

    public MockRestClient openapi() {
        this.marshall((Marshall)OpenApi.DEFAULT);
        return this;
    }

    public MockRestClient marshall(Marshall value) {
        super.marshall(value);
        this.mrb.marshall(value);
        return this;
    }

    public MockRestClient serializer(Serializer value) {
        super.serializer(value);
        this.mrb.serializer(value);
        return this;
    }

    public MockRestClient parser(Parser value) {
        super.parser(value);
        this.mrb.parser(value);
        return this;
    }
}

