/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.html5;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.juneau.annotation.Beanp;
import org.apache.juneau.html.HtmlSerializer;
import org.apache.juneau.html.annotation.Html;
import org.apache.juneau.html.annotation.HtmlFormat;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.xml.annotation.Xml;
import org.apache.juneau.xml.annotation.XmlFormat;

@Html(format=HtmlFormat.XML)
public abstract class HtmlElement {
    private LinkedHashMap<String, Object> attrs;

    @Xml(format=XmlFormat.ATTRS)
    @Beanp(value="a")
    public LinkedHashMap<String, Object> getAttrs() {
        return this.attrs;
    }

    @Beanp(value="a")
    public HtmlElement setAttrs(LinkedHashMap<String, Object> attrs) {
        if (attrs != null) {
            for (Map.Entry<String, Object> e : attrs.entrySet()) {
                String key = e.getKey();
                if (!"url".equals(key) && !"href".equals(key) && !key.endsWith("action")) continue;
                e.setValue(StringUtils.toURI((Object)e.getValue()));
            }
        }
        this.attrs = attrs;
        return this;
    }

    public HtmlElement attr(String key, Object val) {
        if (this.attrs == null) {
            this.attrs = new LinkedHashMap();
        }
        if (val == null) {
            this.attrs.remove(key);
        } else {
            if ("url".equals(key) || "href".equals(key) || key.endsWith("action")) {
                val = StringUtils.toURI((Object)val);
            }
            this.attrs.put(key, val);
        }
        return this;
    }

    public HtmlElement attrUri(String key, Object val) {
        if (this.attrs == null) {
            this.attrs = new LinkedHashMap();
        }
        this.attrs.put(key, StringUtils.toURI((Object)val));
        return this;
    }

    public String getAttr(String key) {
        return this.getAttr(String.class, key);
    }

    public <T> T getAttr(Class<T> type, String key) {
        return (T)(this.attrs == null ? null : ObjectUtils.toType((Object)this.attrs.get(key), type));
    }

    public HtmlElement accesskey(String accesskey) {
        this.attr("accesskey", accesskey);
        return this;
    }

    public HtmlElement _class(String _class) {
        this.attr("class", _class);
        return this;
    }

    public HtmlElement contenteditable(Object contenteditable) {
        this.attr("contenteditable", contenteditable);
        return this;
    }

    public HtmlElement dir(String dir) {
        this.attr("dir", dir);
        return this;
    }

    public HtmlElement hidden(Object hidden) {
        this.attr("hidden", this.deminimize(hidden, "hidden"));
        return this;
    }

    public HtmlElement id(String id) {
        this.attr("id", id);
        return this;
    }

    public HtmlElement lang(String lang) {
        this.attr("lang", lang);
        return this;
    }

    public HtmlElement onabort(String onabort) {
        this.attr("onabort", onabort);
        return this;
    }

    public HtmlElement onblur(String onblur) {
        this.attr("onblur", onblur);
        return this;
    }

    public HtmlElement oncancel(String oncancel) {
        this.attr("oncancel", oncancel);
        return this;
    }

    public HtmlElement oncanplay(String oncanplay) {
        this.attr("oncanplay", oncanplay);
        return this;
    }

    public HtmlElement oncanplaythrough(String oncanplaythrough) {
        this.attr("oncanplaythrough", oncanplaythrough);
        return this;
    }

    public HtmlElement onchange(String onchange) {
        this.attr("onchange", onchange);
        return this;
    }

    public HtmlElement onclick(String onclick) {
        this.attr("onclick", onclick);
        return this;
    }

    public HtmlElement oncuechange(String oncuechange) {
        this.attr("oncuechange", oncuechange);
        return this;
    }

    public HtmlElement ondblclick(String ondblclick) {
        this.attr("ondblclick", ondblclick);
        return this;
    }

    public HtmlElement ondurationchange(String ondurationchange) {
        this.attr("ondurationchange", ondurationchange);
        return this;
    }

    public HtmlElement onemptied(String onemptied) {
        this.attr("onemptied", onemptied);
        return this;
    }

    public HtmlElement onended(String onended) {
        this.attr("onended", onended);
        return this;
    }

    public HtmlElement onerror(String onerror) {
        this.attr("onerror", onerror);
        return this;
    }

    public HtmlElement onfocus(String onfocus) {
        this.attr("onfocus", onfocus);
        return this;
    }

    public HtmlElement oninput(String oninput) {
        this.attr("oninput", oninput);
        return this;
    }

    public HtmlElement oninvalid(String oninvalid) {
        this.attr("oninvalid", oninvalid);
        return this;
    }

    public HtmlElement onkeydown(String onkeydown) {
        this.attr("onkeydown", onkeydown);
        return this;
    }

    public HtmlElement onkeypress(String onkeypress) {
        this.attr("onkeypress", onkeypress);
        return this;
    }

    public HtmlElement onkeyup(String onkeyup) {
        this.attr("onkeyup", onkeyup);
        return this;
    }

    public HtmlElement onload(String onload) {
        this.attr("onload", onload);
        return this;
    }

    public HtmlElement onloadeddata(String onloadeddata) {
        this.attr("onloadeddata", onloadeddata);
        return this;
    }

    public HtmlElement onloadedmetadata(String onloadedmetadata) {
        this.attr("onloadedmetadata", onloadedmetadata);
        return this;
    }

    public HtmlElement onloadstart(String onloadstart) {
        this.attr("onloadstart", onloadstart);
        return this;
    }

    public HtmlElement onmousedown(String onmousedown) {
        this.attr("onmousedown", onmousedown);
        return this;
    }

    public HtmlElement onmouseenter(String onmouseenter) {
        this.attr("onmouseenter", onmouseenter);
        return this;
    }

    public HtmlElement onmouseleave(String onmouseleave) {
        this.attr("onmouseleave", onmouseleave);
        return this;
    }

    public HtmlElement onmousemove(String onmousemove) {
        this.attr("onmousemove", onmousemove);
        return this;
    }

    public HtmlElement onmouseout(String onmouseout) {
        this.attr("onmouseout", onmouseout);
        return this;
    }

    public HtmlElement onmouseover(String onmouseover) {
        this.attr("onmouseover", onmouseover);
        return this;
    }

    public HtmlElement onmouseup(String onmouseup) {
        this.attr("onmouseup", onmouseup);
        return this;
    }

    public HtmlElement onmousewheel(String onmousewheel) {
        this.attr("onmousewheel", onmousewheel);
        return this;
    }

    public HtmlElement onpause(String onpause) {
        this.attr("onpause", onpause);
        return this;
    }

    public HtmlElement onplay(String onplay) {
        this.attr("onplay", onplay);
        return this;
    }

    public HtmlElement onplaying(String onplaying) {
        this.attr("onplaying", onplaying);
        return this;
    }

    public HtmlElement onprogress(String onprogress) {
        this.attr("onprogress", onprogress);
        return this;
    }

    public HtmlElement onratechange(String onratechange) {
        this.attr("onratechange", onratechange);
        return this;
    }

    public HtmlElement onreset(String onreset) {
        this.attr("onreset", onreset);
        return this;
    }

    public HtmlElement onresize(String onresize) {
        this.attr("onresize", onresize);
        return this;
    }

    public HtmlElement onscroll(String onscroll) {
        this.attr("onscroll", onscroll);
        return this;
    }

    public HtmlElement onseeked(String onseeked) {
        this.attr("onseeked", onseeked);
        return this;
    }

    public HtmlElement onseeking(String onseeking) {
        this.attr("onseeking", onseeking);
        return this;
    }

    public HtmlElement onselect(String onselect) {
        this.attr("onselect", onselect);
        return this;
    }

    public HtmlElement onshow(String onshow) {
        this.attr("onshow", onshow);
        return this;
    }

    public HtmlElement onstalled(String onstalled) {
        this.attr("onstalled", onstalled);
        return this;
    }

    public HtmlElement onsubmit(String onsubmit) {
        this.attr("onsubmit", onsubmit);
        return this;
    }

    public HtmlElement onsuspend(String onsuspend) {
        this.attr("onsuspend", onsuspend);
        return this;
    }

    public HtmlElement ontimeupdate(String ontimeupdate) {
        this.attr("ontimeupdate", ontimeupdate);
        return this;
    }

    public HtmlElement ontoggle(String ontoggle) {
        this.attr("ontoggle", ontoggle);
        return this;
    }

    public HtmlElement onvolumechange(String onvolumechange) {
        this.attr("onvolumechange", onvolumechange);
        return this;
    }

    public HtmlElement onwaiting(String onwaiting) {
        this.attr("onwaiting", onwaiting);
        return this;
    }

    public HtmlElement spellcheck(Object spellcheck) {
        this.attr("spellcheck", spellcheck);
        return this;
    }

    public HtmlElement style(String style) {
        this.attr("style", style);
        return this;
    }

    public HtmlElement tabindex(Object tabindex) {
        this.attr("tabindex", tabindex);
        return this;
    }

    public HtmlElement title(String title) {
        this.attr("title", title);
        return this;
    }

    public HtmlElement translate(Object translate) {
        this.attr("translate", translate);
        return this;
    }

    protected Object deminimize(Object value, String attr) {
        if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                return attr;
            }
            return null;
        }
        return value;
    }

    public String toString() {
        return HtmlSerializer.DEFAULT_SQ.toString((Object)this);
    }
}

