/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.Value;
import org.apache.juneau.collections.ASet;
import org.apache.juneau.collections.OList;
import org.apache.juneau.collections.OMap;
import org.apache.juneau.cp.Messages;
import org.apache.juneau.dto.swagger.Swagger;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.http.annotation.Body;
import org.apache.juneau.http.annotation.Contact;
import org.apache.juneau.http.annotation.FormData;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.annotation.License;
import org.apache.juneau.http.annotation.Path;
import org.apache.juneau.http.annotation.Query;
import org.apache.juneau.http.annotation.Response;
import org.apache.juneau.http.annotation.ResponseHeader;
import org.apache.juneau.http.annotation.Tag;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.json.SimpleJsonSerializer;
import org.apache.juneau.jsonschema.JsonSchemaGeneratorSession;
import org.apache.juneau.jsonschema.annotation.ExternalDocs;
import org.apache.juneau.jsonschema.annotation.Items;
import org.apache.juneau.jsonschema.annotation.Schema;
import org.apache.juneau.jsonschema.annotation.SubItems;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.reflect.ParamInfo;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestMethodContext;
import org.apache.juneau.rest.RestMethodParam;
import org.apache.juneau.rest.RestParamType;
import org.apache.juneau.rest.RestServletException;
import org.apache.juneau.rest.SwaggerException;
import org.apache.juneau.rest.annotation.MethodSwagger;
import org.apache.juneau.rest.annotation.ResourceSwagger;
import org.apache.juneau.rest.annotation.Rest;
import org.apache.juneau.rest.annotation.RestMethod;
import org.apache.juneau.rest.annotation.RestResource;
import org.apache.juneau.rest.util.AnnotationUtils;
import org.apache.juneau.rest.util.RestUtils;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.SerializerSessionArgs;
import org.apache.juneau.serializer.WriterSerializer;
import org.apache.juneau.svl.VarResolverSession;

final class SwaggerGenerator {
    private final VarResolverSession vr;
    private final Locale locale;
    private final RestContext context;
    private final JsonParser jp = JsonParser.create().ignoreUnknownBeanProperties().build();
    private final JsonSchemaGeneratorSession js;
    private final Class<?> c;
    private final Object resource;
    private final Messages mb;

    public SwaggerGenerator(RestContext context, VarResolverSession vr, Locale locale) {
        this.vr = vr;
        this.locale = locale;
        this.context = context;
        this.js = context.getJsonSchemaGenerator().createSession();
        this.c = context.getResource().getClass();
        this.resource = context.getResource();
        this.mb = context.getMessages().forLocale(locale);
    }

    public Swagger getSwagger() throws Exception {
        String s;
        Object info;
        ResourceSwagger r;
        OMap sInfo;
        ClassInfo rci = ClassInfo.of((Object)this.resource).resolved();
        rci.getSimpleName();
        OMap omSwagger = this.context.getClasspathResource(OMap.class, MediaType.JSON, rci.getSimpleName() + ".json", this.locale);
        if (omSwagger == null) {
            omSwagger = this.context.getClasspathResource(OMap.class, MediaType.JSON, rci.getSimpleName() + ".json", this.locale);
        }
        if (omSwagger == null) {
            omSwagger = new OMap();
        }
        for (Annotation rr : rci.getAnnotations(RestResource.class)) {
            sInfo = omSwagger.getMap("info", true);
            sInfo.ase("title", new Object[]{this.firstNonEmpty(sInfo.getString("title"), this.resolve(new String[][]{rr.title()}))});
            sInfo.ase("description", new Object[]{this.firstNonEmpty(sInfo.getString("description"), this.resolve(new String[][]{rr.description()}))});
            r = rr.swagger();
            omSwagger.appendAll((Map)this.parseMap(r.value(), "@ResourceSwagger(value) on class {0}", this.c));
            if (!AnnotationUtils.empty(r)) {
                info = omSwagger.getMap("info", true);
                info.ase("title", new Object[]{this.resolve(new String[][]{r.title()})}).ase("description", new Object[]{this.resolve(new String[][]{r.description()})}).ase("version", new Object[]{this.resolve(r.version())}).ase("termsOfService", new Object[]{this.resolve(new String[][]{r.termsOfService()})}).ase("contact", new Object[]{this.merge(info.getMap("contact"), this.toMap(r.contact(), "@ResourceSwagger(contact) on class {0}", this.c))}).ase("license", new Object[]{this.merge(info.getMap("license"), this.toMap(r.license(), "@ResourceSwagger(license) on class {0}", this.c))});
            }
            omSwagger.ase("externalDocs", new Object[]{this.merge(omSwagger.getMap("externalDocs"), this.toMap(r.externalDocs(), "@ResourceSwagger(externalDocs) on class {0}", this.c))}).ase("tags", new Object[]{this.merge(omSwagger.getList("tags"), this.toList(r.tags(), "@ResourceSwagger(tags) on class {0}", this.c))});
        }
        for (Annotation rr : rci.getAnnotations(Rest.class)) {
            sInfo = omSwagger.getMap("info", true);
            sInfo.ase("title", new Object[]{this.firstNonEmpty(sInfo.getString("title"), this.resolve(new String[][]{rr.title()}))}).ase("description", new Object[]{this.firstNonEmpty(sInfo.getString("description"), this.resolve(new String[][]{rr.description()}))});
            r = rr.swagger();
            omSwagger.appendAll((Map)this.parseMap(r.value(), "@ResourceSwagger(value) on class {0}", this.c));
            if (!AnnotationUtils.empty(r)) {
                info = omSwagger.getMap("info", true);
                info.ase("title", new Object[]{this.resolve(new String[][]{r.title()})}).ase("description", new Object[]{this.resolve(new String[][]{r.description()})}).ase("version", new Object[]{this.resolve(r.version())}).ase("termsOfService", new Object[]{this.resolve(new String[][]{r.termsOfService()})}).ase("contact", new Object[]{this.merge(info.getMap("contact"), this.toMap(r.contact(), "@ResourceSwagger(contact) on class {0}", this.c))}).ase("license", new Object[]{this.merge(info.getMap("license"), this.toMap(r.license(), "@ResourceSwagger(license) on class {0}", this.c))});
            }
            omSwagger.ase("externalDocs", new Object[]{this.merge(omSwagger.getMap("externalDocs"), this.toMap(r.externalDocs(), "@ResourceSwagger(externalDocs) on class {0}", this.c))}).ase("tags", new Object[]{this.merge(omSwagger.getList("tags"), this.toList(r.tags(), "@ResourceSwagger(tags) on class {0}", this.c))});
        }
        omSwagger.ase("externalDocs", new Object[]{this.parseMap(this.mb.findFirstString(new String[]{"externalDocs"}), "Messages/externalDocs on class {0}", this.c)});
        OMap info2 = omSwagger.getMap("info", true);
        info2.ase("title", new Object[]{this.resolve(this.mb.findFirstString(new String[]{"title"}))}).ase("description", new Object[]{this.resolve(this.mb.findFirstString(new String[]{"description"}))}).ase("version", new Object[]{this.resolve(this.mb.findFirstString(new String[]{"version"}))}).ase("termsOfService", new Object[]{this.resolve(this.mb.findFirstString(new String[]{"termsOfService"}))}).ase("contact", new Object[]{this.parseMap(this.mb.findFirstString(new String[]{"contact"}), "Messages/contact on class {0}", this.c)}).ase("license", new Object[]{this.parseMap(this.mb.findFirstString(new String[]{"license"}), "Messages/license on class {0}", this.c)});
        if (info2.isEmpty()) {
            omSwagger.remove((Object)"info");
        }
        OList produces = omSwagger.getList("produces", true);
        OList consumes = omSwagger.getList("consumes", true);
        if (consumes.isEmpty()) {
            consumes.addAll(this.context.getConsumes());
        }
        if (produces.isEmpty()) {
            produces.addAll(this.context.getProduces());
        }
        LinkedHashMap<Object, Object> tagMap = new LinkedHashMap<Object, Object>();
        if (omSwagger.containsKey((Object)"tags")) {
            for (Object om : omSwagger.getList("tags").elements(OMap.class)) {
                String name = om.getString("name");
                if (name == null) {
                    throw new SwaggerException(null, "Tag definition found without name in swagger JSON.", new Object[0]);
                }
                tagMap.put(name, om);
            }
        }
        if ((s = this.mb.findFirstString(new String[]{"tags"})) != null) {
            for (Iterator<Object> m : this.parseListOrCdl(s, "Messages/tags on class {0}", this.c).elements(OMap.class)) {
                String string = m.getString("name");
                if (string == null) {
                    throw new SwaggerException(null, "Tag definition found without name in resource bundle on class {0}", this.c);
                }
                if (tagMap.containsKey(string)) {
                    ((OMap)tagMap.get(string)).putAll(m);
                    continue;
                }
                tagMap.put(string, m);
            }
        }
        OMap definitions = omSwagger.getMap("definitions", true);
        for (String string : definitions.keySet()) {
            this.js.addBeanDef(string, new OMap((Map)definitions.getMap(string)));
        }
        for (RestMethodContext restMethodContext : this.context.getMethodContexts()) {
            List<MediaType> mProduces;
            List<MediaType> mConsumes;
            Object mpi;
            BeanSession bs = restMethodContext.createBeanSession();
            Method m = restMethodContext.method;
            MethodInfo mi = MethodInfo.of((Method)m);
            RestMethod rm = (RestMethod)mi.getLastAnnotation(RestMethod.class);
            String mn = m.getName();
            OMap op = this.getOperation(omSwagger, restMethodContext.getPathPattern(), restMethodContext.getHttpMethod().toLowerCase());
            MethodSwagger ms = rm.swagger();
            op.appendAll((Map)this.parseMap(ms.value(), "@MethodSwagger(value) on class {0} method {1}", this.c, m));
            op.ase("operationId", new Object[]{this.firstNonEmpty(this.resolve(ms.operationId()), op.getString("operationId"), mn)});
            op.ase("summary", new Object[]{this.firstNonEmpty(this.resolve(new String[][]{ms.summary()}), this.resolve(this.mb.findFirstString(new String[]{mn + ".summary"})), op.getString("summary"), this.resolve(rm.summary()))});
            op.ase("description", new Object[]{this.firstNonEmpty(this.resolve(new String[][]{ms.description()}), this.resolve(this.mb.findFirstString(new String[]{mn + ".description"})), op.getString("description"), this.resolve(new String[][]{rm.description()}))});
            op.ase("deprecated", new Object[]{this.firstNonEmpty(this.resolve(ms.deprecated()), m.getAnnotation(Deprecated.class) != null || m.getDeclaringClass().getAnnotation(Deprecated.class) != null ? "true" : null)});
            op.ase("tags", new Object[]{this.merge(this.parseListOrCdl(this.mb.findFirstString(new String[]{mn + ".tags"}), "Messages/tags on class {0} method {1}", this.c, m), this.parseListOrCdl(ms.tags(), "@MethodSwagger(tags) on class {0} method {1}", this.c, m))});
            op.ase("schemes", new Object[]{this.merge(this.parseListOrCdl(this.mb.findFirstString(new String[]{mn + ".schemes"}), "Messages/schemes on class {0} method {1}", this.c, m), this.parseListOrCdl(ms.schemes(), "@MethodSwagger(schemes) on class {0} method {1}", this.c, m))});
            op.ase("consumes", new Object[]{this.firstNonEmpty(this.parseListOrCdl(this.mb.findFirstString(new String[]{mn + ".consumes"}), "Messages/consumes on class {0} method {1}", this.c, m), this.parseListOrCdl(ms.consumes(), "@MethodSwagger(consumes) on class {0} method {1}", this.c, m))});
            op.ase("produces", new Object[]{this.firstNonEmpty(this.parseListOrCdl(this.mb.findFirstString(new String[]{mn + ".produces"}), "Messages/produces on class {0} method {1}", this.c, m), this.parseListOrCdl(ms.produces(), "@MethodSwagger(produces) on class {0} method {1}", this.c, m))});
            op.ase("parameters", new Object[]{this.merge(this.parseList(this.mb.findFirstString(new String[]{mn + ".parameters"}), "Messages/parameters on class {0} method {1}", this.c, m), this.parseList(ms.parameters(), "@MethodSwagger(parameters) on class {0} method {1}", this.c, m))});
            op.ase("responses", new Object[]{this.merge(this.parseMap(this.mb.findFirstString(new String[]{mn + ".responses"}), "Messages/responses on class {0} method {1}", this.c, m), this.parseMap(ms.responses(), "@MethodSwagger(responses) on class {0} method {1}", this.c, m))});
            op.ase("externalDocs", new Object[]{this.merge(op.getMap("externalDocs"), this.parseMap(this.mb.findFirstString(new String[]{mn + ".externalDocs"}), "Messages/externalDocs on class {0} method {1}", this.c, m), this.toMap(ms.externalDocs(), "@MethodSwagger(externalDocs) on class {0} method {1}", this.c, m))});
            if (op.containsKey((Object)"tags")) {
                for (Object tag : op.getList("tags").elements(String.class)) {
                    if (tagMap.containsKey(tag)) continue;
                    tagMap.put(tag, OMap.of((Object[])new Object[]{"name", tag}));
                }
            }
            OMap paramMap = new OMap();
            if (op.containsKey((Object)"parameters")) {
                Object tag;
                tag = op.getList("parameters").elements(OMap.class).iterator();
                while (tag.hasNext()) {
                    OMap param = (OMap)tag.next();
                    paramMap.put((Object)(param.getString("in") + '.' + ("body".equals(param.getString("in")) ? "body" : param.getString("name"))), (Object)param);
                }
            }
            for (RestMethodParam mp : restMethodContext.methodParams) {
                RestParamType in = mp.getParamType();
                mpi = mp.getMethodParamInfo();
                if (!in.isAny(RestParamType.BODY, RestParamType.QUERY, RestParamType.FORM_DATA, RestParamType.HEADER, RestParamType.PATH)) continue;
                String key = in.toString() + '.' + (in == RestParamType.BODY ? "body" : mp.getName());
                OMap param = paramMap.getMap(key, true);
                param.append("in", (Object)in);
                if (in != RestParamType.BODY) {
                    param.append("name", (Object)mp.name);
                }
                try {
                    if (mpi != null) {
                        if (in == RestParamType.BODY) {
                            for (Body a : mpi.getAnnotations(Body.class)) {
                                this.merge(param, a);
                            }
                        } else if (in == RestParamType.QUERY) {
                            for (Body a : mpi.getAnnotations(Query.class)) {
                                this.merge(param, (Query)a);
                            }
                        } else if (in == RestParamType.FORM_DATA) {
                            for (Body a : mpi.getAnnotations(FormData.class)) {
                                this.merge(param, (FormData)a);
                            }
                        } else if (in == RestParamType.HEADER) {
                            for (Body a : mpi.getAnnotations(Header.class)) {
                                this.merge(param, (Header)a);
                            }
                        } else if (in == RestParamType.PATH) {
                            for (Body a : mpi.getAnnotations(Path.class)) {
                                this.merge(param, (Path)a);
                            }
                        }
                    }
                }
                catch (ParseException e) {
                    throw new SwaggerException((Exception)((Object)e), "Malformed swagger JSON object encountered in {0} class {1} method parameter {2}", new Object[]{in, this.c, mpi});
                }
                if (!(in != RestParamType.BODY && in != RestParamType.PATH || param.containsKeyNotEmpty("required"))) {
                    param.put((Object)"required", (Object)true);
                }
                if (in == RestParamType.BODY) {
                    param.ase("schema", new Object[]{this.getSchema(param.getMap("schema"), mp.getType(), bs)});
                    this.addBodyExamples(restMethodContext, param, false, mp.getType());
                    continue;
                }
                this.mergePartSchema(param, this.getSchema(param.getMap("schema"), mp.getType(), bs));
                this.addParamExample(restMethodContext, param, in, mp.getType());
            }
            if (!paramMap.isEmpty()) {
                op.put((Object)"parameters", (Object)paramMap.values());
            }
            OMap responses = op.getMap("responses", true);
            for (ClassInfo eci : mi.getExceptionTypes()) {
                if (!eci.hasAnnotation(Response.class)) continue;
                Iterator la = eci.getAnnotations(Response.class);
                Set<Integer> codes = SwaggerGenerator.getCodes((List<Response>)((Object)la), 500);
                mpi = la.iterator();
                while (mpi.hasNext()) {
                    Response a = (Response)mpi.next();
                    for (Integer code : codes) {
                        OMap om = responses.getMap(String.valueOf(code), true);
                        this.merge(om, a);
                        if (om.containsKey((Object)"schema")) continue;
                        om.ase("schema", new Object[]{this.getSchema(om.getMap("schema"), eci.inner(), bs)});
                    }
                }
                for (MethodInfo ecmi : eci.getAllMethodsParentFirst()) {
                    ResponseHeader a = (ResponseHeader)ecmi.getLastAnnotation(ResponseHeader.class);
                    if (a == null) {
                        a = (ResponseHeader)ecmi.getResolvedReturnType().getLastAnnotation(ResponseHeader.class);
                    }
                    if (a == null || this.isMulti(a)) continue;
                    String ha = a.name();
                    for (Integer code : codes) {
                        OMap header = responses.getMap(String.valueOf(code), true).getMap("headers", true).getMap(ha, true);
                        this.merge(header, a);
                        this.mergePartSchema(header, this.getSchema(header, ecmi.getReturnType().innerType(), bs));
                    }
                }
            }
            if (mi.hasAnnotation(Response.class) || mi.getResolvedReturnType().hasAnnotation(Response.class)) {
                List la = mi.getAnnotations(Response.class);
                Set<Integer> codes = SwaggerGenerator.getCodes(la, 200);
                for (Response a : la) {
                    for (Integer code : codes) {
                        OMap om = responses.getMap(String.valueOf(code), true);
                        this.merge(om, a);
                        if (!om.containsKey((Object)"schema")) {
                            om.ase("schema", new Object[]{this.getSchema(om.getMap("schema"), m.getGenericReturnType(), bs)});
                        }
                        this.addBodyExamples(restMethodContext, om, true, m.getGenericReturnType());
                    }
                }
                if (mi.getReturnType().hasAnnotation(Response.class)) {
                    for (MethodInfo ecmi : mi.getReturnType().getAllMethodsParentFirst()) {
                        if (!ecmi.hasAnnotation(ResponseHeader.class)) continue;
                        ResponseHeader a = (ResponseHeader)ecmi.getLastAnnotation(ResponseHeader.class);
                        String ha = a.name();
                        if (this.isMulti(a)) continue;
                        for (Integer code : codes) {
                            OMap header = responses.getMap(String.valueOf(code), true).getMap("headers", true).getMap(ha, true);
                            this.merge(header, a);
                            this.mergePartSchema(header, this.getSchema(header, ecmi.getReturnType().innerType(), bs));
                        }
                    }
                }
            } else if (m.getGenericReturnType() != Void.TYPE) {
                OMap om = responses.getMap("200", true);
                if (!om.containsKey((Object)"schema")) {
                    om.ase("schema", new Object[]{this.getSchema(om.getMap("schema"), m.getGenericReturnType(), bs)});
                }
                this.addBodyExamples(restMethodContext, om, true, m.getGenericReturnType());
            }
            for (OMap mp : restMethodContext.methodParams) {
                Set<Integer> codes;
                List la;
                RestParamType in = mp.getParamType();
                ParamInfo mpi2 = mp.getMethodParamInfo();
                if (in == RestParamType.RESPONSE_HEADER) {
                    la = mpi2.getAnnotations(ResponseHeader.class);
                    codes = SwaggerGenerator.getCodes2(la, 200);
                    for (ResponseHeader a : la) {
                        if (this.isMulti(a)) continue;
                        for (Integer code : codes) {
                            OMap header = responses.getMap(String.valueOf(code), true).getMap("headers", true).getMap(mp.name, true);
                            this.merge(header, a);
                            this.mergePartSchema(header, this.getSchema(header, Value.getParameterType((Type)mp.type), bs));
                        }
                    }
                    continue;
                }
                if (in != RestParamType.RESPONSE) continue;
                la = mpi2.getAnnotations(Response.class);
                codes = SwaggerGenerator.getCodes(la, 200);
                for (ResponseHeader a : la) {
                    for (Integer code : codes) {
                        OMap response = responses.getMap(String.valueOf(code), true);
                        this.merge(response, (Response)a);
                    }
                }
                Type type = Value.getParameterType((Type)mp.type);
                if (type == null) continue;
                for (String code : responses.keySet()) {
                    OMap om = responses.getMap(code);
                    if (om.containsKey((Object)"schema")) continue;
                    om.ase("schema", new Object[]{this.getSchema(om.getMap("schema"), type, bs)});
                }
            }
            for (Map.Entry e : responses.entrySet()) {
                String key = (String)e.getKey();
                OMap val = responses.getMap(key);
                if (!StringUtils.isDecimal((String)key)) continue;
                val.appendIf(false, true, true, "description", (Object)RestUtils.getHttpResponseText(Integer.parseInt(key)));
            }
            if (responses.isEmpty()) {
                op.remove((Object)"responses");
            } else {
                op.put((Object)"responses", new TreeMap(responses));
            }
            if (!op.containsKey((Object)"consumes") && !(mConsumes = restMethodContext.supportedContentTypes).equals(consumes)) {
                op.put((Object)"consumes", mConsumes);
            }
            if (op.containsKey((Object)"produces") || (mProduces = restMethodContext.supportedAcceptTypes).equals(produces)) continue;
            op.put((Object)"produces", mProduces);
        }
        if (this.js.getBeanDefs() != null) {
            for (Map.Entry entry : this.js.getBeanDefs().entrySet()) {
                definitions.put(entry.getKey(), (Object)this.fixSwaggerExtensions((OMap)entry.getValue()));
            }
        }
        if (definitions.isEmpty()) {
            omSwagger.remove((Object)"definitions");
        }
        if (!tagMap.isEmpty()) {
            omSwagger.put((Object)"tags", tagMap.values());
        }
        if (consumes.isEmpty()) {
            omSwagger.remove((Object)"consumes");
        }
        if (produces.isEmpty()) {
            omSwagger.remove((Object)"produces");
        }
        try {
            String swaggerJson = omSwagger.toString((WriterSerializer)SimpleJsonSerializer.DEFAULT_READABLE);
            return (Swagger)this.jp.parse(swaggerJson, Swagger.class);
        }
        catch (Exception e) {
            throw new RestServletException(e, "Error detected in swagger.", new Object[0]);
        }
    }

    private boolean isMulti(ResponseHeader h) {
        return "*".equals(h.name()) || "*".equals(h.value());
    }

    private OMap resolve(OMap om) throws ParseException {
        OMap om2 = null;
        if (om.containsKey((Object)"_value")) {
            om = om.modifiable();
            om2 = this.parseMap(om.remove((Object)"_value"));
        } else {
            om2 = new OMap();
        }
        for (Map.Entry e : om.entrySet()) {
            Object val = e.getValue();
            if (val instanceof OMap) {
                val = this.resolve((OMap)val);
            } else if (val instanceof OList) {
                val = this.resolve((OList)val);
            } else if (val instanceof String) {
                val = this.resolve(val.toString());
            }
            om2.put(e.getKey(), val);
        }
        return om2;
    }

    private OList resolve(OList om) throws ParseException {
        OList ol2 = new OList();
        for (Object val : om) {
            if (val instanceof OMap) {
                val = this.resolve((OMap)val);
            } else if (val instanceof OList) {
                val = this.resolve((OList)val);
            } else if (val instanceof String) {
                val = this.resolve(val.toString());
            }
            ol2.add(val);
        }
        return ol2;
    }

    private String resolve(String[] ... s) {
        for (String[] ss : s) {
            if (ss.length == 0) continue;
            return this.resolve(SwaggerGenerator.joinnl(new String[][]{ss}));
        }
        return null;
    }

    private String resolve(String s) {
        if (s == null) {
            return null;
        }
        return this.vr.resolve(s.trim());
    }

    private OMap parseMap(String[] o, String location, Object ... args) throws ParseException {
        if (o.length == 0) {
            return OMap.EMPTY_MAP;
        }
        try {
            return this.parseMap(o);
        }
        catch (ParseException e) {
            throw new SwaggerException((Exception)((Object)e), "Malformed swagger JSON object encountered in " + location + ".", args);
        }
    }

    private OMap parseMap(String o, String location, Object ... args) throws ParseException {
        try {
            return this.parseMap(o);
        }
        catch (ParseException e) {
            throw new SwaggerException((Exception)((Object)e), "Malformed swagger JSON object encountered in " + location + ".", args);
        }
    }

    private OMap parseMap(Object o) throws ParseException {
        if (o == null) {
            return null;
        }
        if (o instanceof String[]) {
            o = SwaggerGenerator.joinnl(new String[][]{(String[])o});
        }
        if (o instanceof String) {
            String s = o.toString();
            if (s.isEmpty()) {
                return null;
            }
            if ("IGNORE".equalsIgnoreCase(s = this.resolve(s))) {
                return OMap.of((Object[])new Object[]{"ignore", true});
            }
            if (!StringUtils.isJsonObject((Object)s, (boolean)true)) {
                s = "{" + s + "}";
            }
            return OMap.ofJson((CharSequence)s);
        }
        if (o instanceof OMap) {
            return (OMap)o;
        }
        throw new SwaggerException(null, "Unexpected data type ''{0}''.  Expected OMap or String.", o.getClass().getName());
    }

    private OList parseList(Object o, String location, Object ... locationArgs) throws ParseException {
        try {
            String s;
            if (o == null) {
                return null;
            }
            String string = s = o instanceof String[] ? SwaggerGenerator.joinnl(new String[][]{(String[])o}) : o.toString();
            if (s.isEmpty()) {
                return null;
            }
            if (!StringUtils.isJsonArray((Object)(s = this.resolve(s)), (boolean)true)) {
                s = "[" + s + "]";
            }
            return OList.ofJson((CharSequence)s);
        }
        catch (ParseException e) {
            throw new SwaggerException((Exception)((Object)e), "Malformed swagger JSON array encountered in " + location + ".", locationArgs);
        }
    }

    private OList parseListOrCdl(Object o, String location, Object ... locationArgs) throws ParseException {
        try {
            String s;
            if (o == null) {
                return null;
            }
            String string = s = o instanceof String[] ? SwaggerGenerator.joinnl(new String[][]{(String[])o}) : o.toString();
            if (s.isEmpty()) {
                return null;
            }
            s = this.resolve(s);
            return StringUtils.parseListOrCdl((String)s);
        }
        catch (ParseException e) {
            throw new SwaggerException((Exception)((Object)e), "Malformed swagger JSON array encountered in " + location + ".", locationArgs);
        }
    }

    private OMap newMap(OMap om, String[] value, String location, Object ... locationArgs) throws ParseException {
        if (value.length == 0) {
            return om == null ? new OMap() : om;
        }
        OMap om2 = this.parseMap(SwaggerGenerator.joinnl(new String[][]{value}), location, locationArgs);
        if (om == null) {
            return om2;
        }
        return om.appendAll((Map)om2);
    }

    private OMap merge(OMap ... maps) {
        OMap m = maps[0];
        for (int i = 1; i < maps.length; ++i) {
            if (maps[i] == null) continue;
            if (m == null) {
                m = new OMap();
            }
            m.putAll((Map)maps[i]);
        }
        return m;
    }

    private OList merge(OList ... lists) {
        OList l = lists[0];
        for (int i = 1; i < lists.length; ++i) {
            if (lists[i] == null) continue;
            if (l == null) {
                l = new OList();
            }
            l.addAll((Collection)lists[i]);
        }
        return l;
    }

    @SafeVarargs
    private final <T> T firstNonEmpty(T ... t) {
        return (T)ObjectUtils.firstNonEmpty((Object[])t);
    }

    private OMap toMap(ExternalDocs a, String location, Object ... locationArgs) throws ParseException {
        if (AnnotationUtils.empty((ExternalDocs)a)) {
            return null;
        }
        OMap om = this.newMap(new OMap(), a.value(), location, locationArgs).ase("description", new Object[]{this.resolve(SwaggerGenerator.joinnl(new String[][]{a.description()}))}).ase("url", new Object[]{this.resolve(a.url())});
        return SwaggerGenerator.nullIfEmpty(om);
    }

    private OMap toMap(Contact a, String location, Object ... locationArgs) throws ParseException {
        if (AnnotationUtils.empty((Contact)a)) {
            return null;
        }
        OMap om = this.newMap(new OMap(), a.value(), location, locationArgs).ase("name", new Object[]{this.resolve(a.name())}).ase("url", new Object[]{this.resolve(a.url())}).ase("email", new Object[]{this.resolve(a.email())});
        return SwaggerGenerator.nullIfEmpty(om);
    }

    private OMap toMap(License a, String location, Object ... locationArgs) throws ParseException {
        if (AnnotationUtils.empty((License)a)) {
            return null;
        }
        OMap om = this.newMap(new OMap(), a.value(), location, locationArgs).ase("name", new Object[]{this.resolve(a.name())}).ase("url", new Object[]{this.resolve(a.url())});
        return SwaggerGenerator.nullIfEmpty(om);
    }

    private OMap toMap(Tag a, String location, Object ... locationArgs) throws ParseException {
        OMap om = this.newMap(new OMap(), a.value(), location, locationArgs);
        om.ase("name", new Object[]{this.resolve(a.name())}).ase("description", new Object[]{this.resolve(SwaggerGenerator.joinnl(new String[][]{a.description()}))}).asn("externalDocs", (Object)this.merge(om.getMap("externalDocs"), this.toMap(a.externalDocs(), location, locationArgs)));
        return SwaggerGenerator.nullIfEmpty(om);
    }

    private OList toList(Tag[] aa, String location, Object ... locationArgs) throws ParseException {
        if (aa.length == 0) {
            return null;
        }
        OList ol = new OList();
        for (Tag a : aa) {
            ol.add((Object)this.toMap(a, location, locationArgs));
        }
        return SwaggerGenerator.nullIfEmpty(ol);
    }

    private OMap getSchema(OMap schema, Type type, BeanSession bs) throws Exception {
        if (type == Swagger.class) {
            return null;
        }
        schema = SwaggerGenerator.newMap(schema);
        ClassMeta cm = bs.getClassMeta(type, new Type[0]);
        if (schema.getBoolean("ignore", Boolean.valueOf(false)).booleanValue()) {
            return null;
        }
        if (schema.containsKey((Object)"type") || schema.containsKey((Object)"$ref")) {
            return schema;
        }
        OMap om = this.fixSwaggerExtensions(schema.appendAll((Map)this.js.getSchema(cm)));
        return SwaggerGenerator.nullIfEmpty(om);
    }

    private OMap fixSwaggerExtensions(OMap om) {
        om.asn("discriminator", om.remove((Object)"x-discriminator")).asn("readOnly", om.remove((Object)"x-readOnly")).asn("xml", om.remove((Object)"x-xml")).asn("externalDocs", om.remove((Object)"x-externalDocs")).asn("example", om.remove((Object)"x-example"));
        return SwaggerGenerator.nullIfEmpty(om);
    }

    private void addBodyExamples(RestMethodContext sm, OMap piri, boolean response, Type type) throws Exception {
        OMap schema;
        String sex = piri.getString("x-example");
        if (sex == null && (schema = this.resolveRef(piri.getMap("schema"))) != null) {
            sex = schema.getString("example", schema.getString("x-example"));
        }
        if (StringUtils.isEmpty((String)sex)) {
            return;
        }
        Object example = null;
        if (StringUtils.isJson((String)sex)) {
            example = this.jp.parse(sex, type, new Type[0]);
        } else {
            ClassMeta cm = this.js.getClassMeta(type, new Type[0]);
            if (cm.hasStringMutater()) {
                example = cm.getStringMutater().mutate((Object)sex);
            }
        }
        String examplesKey = response ? "examples" : "x-examples";
        OMap examples = piri.getMap(examplesKey);
        if (examples == null) {
            examples = new OMap();
        }
        List mediaTypes = response ? sm.getSerializers().getSupportedMediaTypes() : sm.getParsers().getSupportedMediaTypes();
        for (MediaType mt : mediaTypes) {
            Serializer s2;
            if (mt == MediaType.HTML || (s2 = sm.getSerializers().getSerializer(mt)) == null) continue;
            SerializerSessionArgs args = SerializerSessionArgs.create().locale(this.locale).mediaType(mt).useWhitespace(Boolean.valueOf(true));
            try {
                String eVal = s2.createSession(args).serializeToString(example);
                examples.put((Object)s2.getPrimaryMediaType().toString(), (Object)eVal);
            }
            catch (Exception e) {
                System.err.println("Could not serialize to media type [" + mt + "]: " + e.getLocalizedMessage());
            }
        }
        if (!examples.isEmpty()) {
            piri.put((Object)examplesKey, (Object)examples);
        }
    }

    private void addParamExample(RestMethodContext sm, OMap piri, RestParamType in, Type type) throws Exception {
        String s = piri.getString("x-example");
        if (StringUtils.isEmpty((String)s)) {
            return;
        }
        OMap examples = piri.getMap("x-examples");
        if (examples == null) {
            examples = new OMap();
        }
        String paramName = piri.getString("name");
        if (in == RestParamType.QUERY) {
            s = "?" + StringUtils.urlEncodeLax((String)paramName) + "=" + StringUtils.urlEncodeLax((String)s);
        } else if (in == RestParamType.FORM_DATA) {
            s = paramName + "=" + s;
        } else if (in == RestParamType.HEADER) {
            s = paramName + ": " + s;
        } else if (in == RestParamType.PATH) {
            s = sm.getPathPattern().replace("{" + paramName + "}", StringUtils.urlEncodeLax((String)s));
        }
        examples.put((Object)"example", (Object)s);
        if (!examples.isEmpty()) {
            piri.put((Object)"x-examples", (Object)examples);
        }
    }

    private OMap resolveRef(OMap m) {
        String ref;
        if (m == null) {
            return null;
        }
        if (m.containsKey((Object)"$ref") && this.js.getBeanDefs() != null && (ref = m.getString("$ref")).startsWith("#/definitions/")) {
            return (OMap)this.js.getBeanDefs().get(ref.substring(14));
        }
        return m;
    }

    private OMap getOperation(OMap om, String path, String httpMethod) {
        if (!om.containsKey((Object)"paths")) {
            om.put((Object)"paths", (Object)new OMap());
        }
        if (!(om = om.getMap("paths")).containsKey((Object)path)) {
            om.put((Object)path, (Object)new OMap());
        }
        if (!(om = om.getMap(path)).containsKey((Object)httpMethod)) {
            om.put((Object)httpMethod, (Object)new OMap());
        }
        return om.getMap(httpMethod);
    }

    private static OMap newMap(OMap om) {
        if (om == null) {
            return new OMap();
        }
        return om.modifiable();
    }

    private OMap merge(OMap om, Body a) throws ParseException {
        if (AnnotationUtils.empty((Body)a)) {
            return om;
        }
        om = SwaggerGenerator.newMap(om);
        if (a.value().length > 0) {
            om.putAll((Map)this.parseMap(a.value()));
        }
        if (a.api().length > 0) {
            om.putAll((Map)this.parseMap(a.api()));
        }
        return om.ase("description", new Object[]{this.resolve(a.description(), a.d())}).ase("x-example", new Object[]{this.resolve(a.example(), a.ex())}).ase("x-examples", new Object[]{this.parseMap(a.examples()), this.parseMap(a.exs())}).asf("required", a.required() || a.r()).ase("schema", new Object[]{this.merge(om.getMap("schema"), a.schema())});
    }

    private OMap merge(OMap om, Query a) throws ParseException {
        if (AnnotationUtils.empty((Query)a)) {
            return om;
        }
        om = SwaggerGenerator.newMap(om);
        if (a.api().length > 0) {
            om.putAll((Map)this.parseMap(a.api()));
        }
        return om.asf("allowEmptyValue", a.allowEmptyValue() || a.aev()).ase("collectionFormat", new Object[]{a.collectionFormat(), a.cf()}).ase("default", new Object[]{SwaggerGenerator.joinnl(a._default(), a.df())}).ase("description", new Object[]{this.resolve(a.description(), a.d())}).ase("enum", new Object[]{this.toSet(a._enum()), this.toSet(a.e())}).ase("x-example", new Object[]{this.resolve(a.example(), a.ex())}).asf("exclusiveMaximum", a.exclusiveMaximum() || a.emax()).asf("exclusiveMinimum", a.exclusiveMinimum() || a.emin()).ase("format", new Object[]{a.format(), a.f()}).ase("items", new Object[]{this.merge(om.getMap("items"), a.items())}).ase("maximum", new Object[]{a.maximum(), a.max()}).asmo("maxItems", new Number[]{a.maxItems(), a.maxi()}).asmo("maxLength", new Number[]{a.maxLength(), a.maxl()}).ase("minimum", new Object[]{a.minimum(), a.min()}).asmo("minItems", new Number[]{a.minItems(), a.mini()}).asmo("minLength", new Number[]{a.minLength(), a.minl()}).ase("multipleOf", new Object[]{a.multipleOf(), a.mo()}).ase("pattern", new Object[]{a.pattern(), a.p()}).asf("required", a.required() || a.r()).ase("type", new Object[]{a.type(), a.t()}).asf("uniqueItems", a.uniqueItems() || a.ui());
    }

    private OMap merge(OMap om, FormData a) throws ParseException {
        if (AnnotationUtils.empty((FormData)a)) {
            return om;
        }
        om = SwaggerGenerator.newMap(om);
        if (a.api().length > 0) {
            om.putAll((Map)this.parseMap(a.api()));
        }
        return om.asf("allowEmptyValue", a.allowEmptyValue() || a.aev()).ase("collectionFormat", new Object[]{a.collectionFormat(), a.cf()}).ase("default", new Object[]{SwaggerGenerator.joinnl(a._default(), a.df())}).ase("description", new Object[]{this.resolve(a.description(), a.d())}).ase("enum", new Object[]{this.toSet(a._enum()), this.toSet(a.e())}).ase("x-example", new Object[]{this.resolve(a.example(), a.ex())}).asf("exclusiveMaximum", a.exclusiveMaximum() || a.emax()).asf("exclusiveMinimum", a.exclusiveMinimum() || a.emin()).ase("format", new Object[]{a.format(), a.f()}).ase("items", new Object[]{this.merge(om.getMap("items"), a.items())}).ase("maximum", new Object[]{a.maximum(), a.max()}).asmo("maxItems", new Number[]{a.maxItems(), a.maxi()}).asmo("maxLength", new Number[]{a.maxLength(), a.maxl()}).ase("minimum", new Object[]{a.minimum(), a.min()}).asmo("minItems", new Number[]{a.minItems(), a.mini()}).asmo("minLength", new Number[]{a.minLength(), a.minl()}).ase("multipleOf", new Object[]{a.multipleOf(), a.mo()}).ase("pattern", new Object[]{a.pattern(), a.p()}).asf("required", a.required()).ase("type", new Object[]{a.type(), a.t()}).asf("uniqueItems", a.uniqueItems() || a.ui());
    }

    private OMap merge(OMap om, Header a) throws ParseException {
        if (AnnotationUtils.empty((Header)a)) {
            return om;
        }
        om = SwaggerGenerator.newMap(om);
        if (a.api().length > 0) {
            om.putAll((Map)this.parseMap(a.api()));
        }
        return om.ase("collectionFormat", new Object[]{a.collectionFormat(), a.cf()}).ase("default", new Object[]{SwaggerGenerator.joinnl(a._default(), a.df())}).ase("description", new Object[]{this.resolve(a.description(), a.d())}).ase("enum", new Object[]{this.toSet(a._enum()), this.toSet(a.e())}).ase("x-example", new Object[]{this.resolve(a.example(), a.ex())}).asf("exclusiveMaximum", a.exclusiveMaximum() || a.emax()).asf("exclusiveMinimum", a.exclusiveMinimum() || a.emin()).ase("format", new Object[]{a.format(), a.f()}).ase("items", new Object[]{this.merge(om.getMap("items"), a.items())}).ase("maximum", new Object[]{a.maximum(), a.max()}).asmo("maxItems", new Number[]{a.maxItems(), a.maxi()}).asmo("maxLength", new Number[]{a.maxLength(), a.maxl()}).ase("minimum", new Object[]{a.minimum(), a.min()}).asmo("minItems", new Number[]{a.minItems(), a.mini()}).asmo("minLength", new Number[]{a.minLength(), a.minl()}).ase("multipleOf", new Object[]{a.multipleOf(), a.mo()}).ase("pattern", new Object[]{a.pattern(), a.p()}).asf("required", a.required() || a.r()).ase("type", new Object[]{a.type(), a.t()}).asf("uniqueItems", a.uniqueItems() || a.ui());
    }

    private OMap merge(OMap om, Path a) throws ParseException {
        if (AnnotationUtils.empty((Path)a)) {
            return om;
        }
        om = SwaggerGenerator.newMap(om);
        if (a.api().length > 0) {
            om.putAll((Map)this.parseMap(a.api()));
        }
        return om.ase("collectionFormat", new Object[]{a.collectionFormat(), a.cf()}).ase("description", new Object[]{this.resolve(a.description(), a.d())}).ase("enum", new Object[]{this.toSet(a._enum()), this.toSet(a.e())}).ase("x-example", new Object[]{this.resolve(a.example(), a.ex())}).asf("exclusiveMaximum", a.exclusiveMaximum() || a.emax()).asf("exclusiveMinimum", a.exclusiveMinimum() || a.emin()).ase("format", new Object[]{a.format(), a.f()}).ase("items", new Object[]{this.merge(om.getMap("items"), a.items())}).ase("maximum", new Object[]{a.maximum(), a.max()}).asmo("maxItems", new Number[]{a.maxItems(), a.maxi()}).asmo("maxLength", new Number[]{a.maxLength(), a.maxl()}).ase("minimum", new Object[]{a.minimum(), a.min()}).asmo("minItems", new Number[]{a.minItems(), a.mini()}).asmo("minLength", new Number[]{a.minLength(), a.minl()}).ase("multipleOf", new Object[]{a.multipleOf(), a.mo()}).ase("pattern", new Object[]{a.pattern(), a.p()}).ase("type", new Object[]{a.type(), a.t()}).asf("uniqueItems", a.uniqueItems() || a.ui());
    }

    private OMap merge(OMap om, Schema a) throws ParseException {
        if (AnnotationUtils.empty((Schema)a)) {
            return om;
        }
        om = SwaggerGenerator.newMap(om);
        if (a.value().length > 0) {
            om.putAll((Map)this.parseMap(a.value()));
        }
        return om.ase("additionalProperties", new Object[]{this.toOMap(a.additionalProperties())}).ase("allOf", new Object[]{SwaggerGenerator.joinnl(new String[][]{a.allOf()})}).ase("collectionFormat", new Object[]{a.collectionFormat(), a.cf()}).ase("default", new Object[]{SwaggerGenerator.joinnl(a._default(), a.df())}).ase("discriminator", new Object[]{a.discriminator()}).ase("description", new Object[]{this.resolve(new String[][]{a.description()}), this.resolve(new String[][]{a.d()})}).ase("enum", new Object[]{this.toSet(a._enum()), this.toSet(a.e())}).ase("x-example", new Object[]{this.resolve(new String[][]{a.example()}), this.resolve(new String[][]{a.ex()})}).ase("examples", new Object[]{this.parseMap(a.examples()), this.parseMap(a.exs())}).asf("exclusiveMaximum", a.exclusiveMaximum() || a.emax()).asf("exclusiveMinimum", a.exclusiveMinimum() || a.emin()).ase("externalDocs", new Object[]{this.merge(om.getMap("externalDocs"), a.externalDocs())}).ase("format", new Object[]{a.format(), a.f()}).ase("ignore", new Object[]{a.ignore() ? "true" : null}).ase("items", new Object[]{this.merge(om.getMap("items"), a.items())}).ase("maximum", new Object[]{a.maximum(), a.max()}).asmo("maxItems", new Number[]{a.maxItems(), a.maxi()}).asmo("maxLength", new Number[]{a.maxLength(), a.maxl()}).asmo("maxProperties", new Number[]{a.maxProperties(), a.maxp()}).ase("minimum", new Object[]{a.minimum(), a.min()}).asmo("minItems", new Number[]{a.minItems(), a.mini()}).asmo("minLength", new Number[]{a.minLength(), a.minl()}).asmo("minProperties", new Number[]{a.minProperties(), a.minp()}).ase("multipleOf", new Object[]{a.multipleOf(), a.mo()}).ase("pattern", new Object[]{a.pattern(), a.p()}).ase("properties", new Object[]{this.toOMap(a.properties())}).asf("readOnly", a.readOnly() || a.ro()).asf("required", a.required() || a.r()).ase("title", new Object[]{a.title()}).ase("type", new Object[]{a.type(), a.t()}).asf("uniqueItems", a.uniqueItems() || a.ui()).ase("xml", new Object[]{SwaggerGenerator.joinnl(new String[][]{a.xml()})}).ase("$ref", new Object[]{a.$ref()});
    }

    private OMap merge(OMap om, ExternalDocs a) throws ParseException {
        if (AnnotationUtils.empty((ExternalDocs)a)) {
            return om;
        }
        om = SwaggerGenerator.newMap(om);
        if (a.value().length > 0) {
            om.putAll((Map)this.parseMap(a.value()));
        }
        return om.ase("description", new Object[]{this.resolve(new String[][]{a.description()})}).ase("url", new Object[]{a.url()});
    }

    private OMap merge(OMap om, Items a) throws ParseException {
        if (AnnotationUtils.empty((Items)a)) {
            return om;
        }
        om = SwaggerGenerator.newMap(om);
        if (a.value().length > 0) {
            om.putAll((Map)this.parseMap(a.value()));
        }
        return om.ase("collectionFormat", new Object[]{a.collectionFormat(), a.cf()}).ase("default", new Object[]{SwaggerGenerator.joinnl(a._default(), a.df())}).ase("enum", new Object[]{this.toSet(a._enum()), this.toSet(a.e())}).ase("format", new Object[]{a.format(), a.f()}).asf("exclusiveMaximum", a.exclusiveMaximum() || a.emax()).asf("exclusiveMinimum", a.exclusiveMinimum() || a.emin()).ase("items", new Object[]{this.merge(om.getMap("items"), a.items())}).ase("maximum", new Object[]{a.maximum(), a.max()}).asmo("maxItems", new Number[]{a.maxItems(), a.maxi()}).asmo("maxLength", new Number[]{a.maxLength(), a.maxl()}).ase("minimum", new Object[]{a.minimum(), a.min()}).asmo("minItems", new Number[]{a.minItems(), a.mini()}).asmo("minLength", new Number[]{a.minLength(), a.minl()}).ase("multipleOf", new Object[]{a.multipleOf(), a.mo()}).ase("pattern", new Object[]{a.pattern(), a.p()}).asf("uniqueItems", a.uniqueItems() || a.ui()).ase("type", new Object[]{a.type(), a.t()}).ase("$ref", new Object[]{a.$ref()});
    }

    private OMap merge(OMap om, SubItems a) throws ParseException {
        if (AnnotationUtils.empty((SubItems)a)) {
            return om;
        }
        om = SwaggerGenerator.newMap(om);
        if (a.value().length > 0) {
            om.putAll((Map)this.parseMap(a.value()));
        }
        return om.ase("collectionFormat", new Object[]{a.collectionFormat(), a.cf()}).ase("default", new Object[]{SwaggerGenerator.joinnl(a._default(), a.df())}).ase("enum", new Object[]{this.toSet(a._enum()), this.toSet(a.e())}).asf("exclusiveMaximum", a.exclusiveMaximum() || a.emax()).asf("exclusiveMinimum", a.exclusiveMinimum() || a.emin()).ase("format", new Object[]{a.format(), a.f()}).ase("items", new Object[]{this.toOMap(a.items())}).ase("maximum", new Object[]{a.maximum(), a.max()}).asmo("maxItems", new Number[]{a.maxItems(), a.maxi()}).asmo("maxLength", new Number[]{a.maxLength(), a.maxl()}).ase("minimum", new Object[]{a.minimum(), a.min()}).asmo("minItems", new Number[]{a.minItems(), a.mini()}).asmo("minLength", new Number[]{a.minLength(), a.minl()}).ase("multipleOf", new Object[]{a.multipleOf(), a.mo()}).ase("pattern", new Object[]{a.pattern(), a.p()}).ase("type", new Object[]{a.type(), a.t()}).asf("uniqueItems", a.uniqueItems() || a.ui()).ase("$ref", new Object[]{a.$ref()});
    }

    private OMap merge(OMap om, Response a) throws ParseException {
        if (AnnotationUtils.empty((Response)a)) {
            return om;
        }
        om = SwaggerGenerator.newMap(om);
        if (a.api().length > 0) {
            om.putAll((Map)this.parseMap(a.api()));
        }
        return om.ase("description", new Object[]{this.resolve(a.description(), a.d())}).ase("x-example", new Object[]{this.resolve(a.example(), a.ex())}).ase("examples", new Object[]{this.parseMap(a.examples()), this.parseMap(a.exs())}).ase("headers", new Object[]{this.merge(om.getMap("headers"), a.headers())}).ase("schema", new Object[]{this.merge(om.getMap("schema"), a.schema())});
    }

    private OMap merge(OMap om, ResponseHeader[] a) throws ParseException {
        if (a.length == 0) {
            return om;
        }
        om = SwaggerGenerator.newMap(om);
        for (ResponseHeader aa : a) {
            String name = StringUtils.firstNonEmpty((String[])new String[]{aa.name(), aa.value()});
            if (StringUtils.isEmpty((String)name)) {
                throw new RuntimeException("@ResponseHeader used without name or value.");
            }
            om.getMap(name, true).putAll((Map)this.merge(null, aa));
        }
        return om;
    }

    private OMap merge(OMap om, ResponseHeader a) throws ParseException {
        if (AnnotationUtils.empty((ResponseHeader)a)) {
            return om;
        }
        om = SwaggerGenerator.newMap(om);
        if (a.api().length > 0) {
            om.putAll((Map)this.parseMap(a.api()));
        }
        return om.ase("collectionFormat", new Object[]{a.collectionFormat(), a.cf()}).ase("default", new Object[]{SwaggerGenerator.joinnl(a._default(), a.df())}).ase("description", new Object[]{this.resolve(a.description(), a.d())}).ase("enum", new Object[]{this.toSet(a._enum()), this.toSet(a.e())}).ase("x-example", new Object[]{this.resolve(a.example(), a.ex())}).asf("exclusiveMaximum", a.exclusiveMaximum() || a.emax()).asf("exclusiveMinimum", a.exclusiveMinimum() || a.emin()).ase("format", new Object[]{a.format(), a.f()}).ase("items", new Object[]{this.merge(om.getMap("items"), a.items())}).ase("maximum", new Object[]{a.maximum(), a.max()}).asmo("maxItems", new Number[]{a.maxItems(), a.maxi()}).asmo("maxLength", new Number[]{a.maxLength(), a.maxl()}).ase("minimum", new Object[]{a.minimum(), a.min()}).asmo("minItems", new Number[]{a.minItems(), a.mini()}).asmo("minLength", new Number[]{a.minLength(), a.minl()}).ase("multipleOf", new Object[]{a.multipleOf(), a.mo()}).ase("pattern", new Object[]{a.pattern(), a.p()}).ase("type", new Object[]{a.type(), a.t()}).asf("uniqueItems", a.uniqueItems() || a.ui()).ase("$ref", new Object[]{a.$ref()});
    }

    private OMap mergePartSchema(OMap param, OMap schema) {
        if (schema != null) {
            param.appendIf(false, true, true, "collectionFormat", schema.remove((Object)"collectionFormat")).appendIf(false, true, true, "default", schema.remove((Object)"default")).appendIf(false, true, true, "description", schema.remove((Object)"enum")).appendIf(false, true, true, "enum", schema.remove((Object)"enum")).appendIf(false, true, true, "x-example", schema.remove((Object)"x-example")).appendIf(false, true, true, "exclusiveMaximum", schema.remove((Object)"exclusiveMaximum")).appendIf(false, true, true, "exclusiveMinimum", schema.remove((Object)"exclusiveMinimum")).appendIf(false, true, true, "format", schema.remove((Object)"format")).appendIf(false, true, true, "items", schema.remove((Object)"items")).appendIf(false, true, true, "maximum", schema.remove((Object)"maximum")).appendIf(false, true, true, "maxItems", schema.remove((Object)"maxItems")).appendIf(false, true, true, "maxLength", schema.remove((Object)"maxLength")).appendIf(false, true, true, "minimum", schema.remove((Object)"minimum")).appendIf(false, true, true, "minItems", schema.remove((Object)"minItems")).appendIf(false, true, true, "minLength", schema.remove((Object)"minLength")).appendIf(false, true, true, "multipleOf", schema.remove((Object)"multipleOf")).appendIf(false, true, true, "pattern", schema.remove((Object)"pattern")).appendIf(false, true, true, "required", schema.remove((Object)"required")).appendIf(false, true, true, "type", schema.remove((Object)"type")).appendIf(false, true, true, "uniqueItems", schema.remove((Object)"uniqueItems"));
            if ("object".equals(param.getString("type")) && !schema.isEmpty()) {
                param.put((Object)"schema", (Object)schema);
            }
        }
        return param;
    }

    private OMap toOMap(String[] ss) throws ParseException {
        if (ss.length == 0) {
            return null;
        }
        String s = SwaggerGenerator.joinnl(new String[][]{ss});
        if (s.isEmpty()) {
            return null;
        }
        if (!StringUtils.isJsonObject((Object)s, (boolean)true)) {
            s = "{" + s + "}";
        }
        s = this.resolve(s);
        return OMap.ofJson((CharSequence)s);
    }

    private Set<String> toSet(String[] ss) throws ParseException {
        if (ss.length == 0) {
            return null;
        }
        String s = SwaggerGenerator.joinnl(new String[][]{ss});
        if (s.isEmpty()) {
            return null;
        }
        s = this.resolve(s);
        ASet set = ASet.of((Object[])new String[0]);
        for (Object o : StringUtils.parseListOrCdl((String)s)) {
            set.add(o.toString());
        }
        return set;
    }

    static String joinnl(String[] ... s) {
        for (Object[] objectArray : s) {
            if (objectArray.length == 0) continue;
            return StringUtils.joinnl((Object[])objectArray).trim();
        }
        return "";
    }

    private static Set<Integer> getCodes(List<Response> la, Integer def) {
        TreeSet<Integer> codes = new TreeSet<Integer>();
        for (Response a : la) {
            for (int i : a.value()) {
                codes.add(i);
            }
            for (int i : a.code()) {
                codes.add(i);
            }
        }
        if (codes.isEmpty() && def != null) {
            codes.add(def);
        }
        return codes;
    }

    private static Set<Integer> getCodes2(List<ResponseHeader> la, Integer def) {
        TreeSet<Integer> codes = new TreeSet<Integer>();
        for (ResponseHeader a : la) {
            for (int i : a.code()) {
                codes.add(i);
            }
        }
        if (codes.isEmpty() && def != null) {
            codes.add(def);
        }
        return codes;
    }

    private static OMap nullIfEmpty(OMap m) {
        return m == null || m.isEmpty() ? null : m;
    }

    private static OList nullIfEmpty(OList l) {
        return l == null || l.isEmpty() ? null : l;
    }
}

