/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.cp;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.juneau.cp.ResourceFinder;
import org.apache.juneau.internal.FileUtils;
import org.apache.juneau.internal.StringUtils;

public class BasicResourceFinder
implements ResourceFinder {
    public static final BasicResourceFinder INSTANCE = new BasicResourceFinder();
    private static final ResourceBundle.Control RB_CONTROL = ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_DEFAULT);
    private static final List<Locale> ROOT_LOCALE = Arrays.asList(Locale.ROOT);
    private final boolean includeFileSystem;
    private final boolean recursive;

    public BasicResourceFinder() {
        this(true, false);
    }

    public BasicResourceFinder(boolean includeFileSystem, boolean recursive) {
        this.includeFileSystem = includeFileSystem;
        this.recursive = recursive;
    }

    @Override
    public InputStream findResource(Class<?> baseClass, String name, Locale locale) throws IOException {
        if (BasicResourceFinder.isInvalidName(name)) {
            return null;
        }
        InputStream is = null;
        if (this.includeFileSystem) {
            is = this.findFileSystemResource(name, locale);
        }
        while (is == null && baseClass != null) {
            is = this.findClasspathResource(baseClass, name, locale);
            baseClass = this.recursive ? baseClass.getSuperclass() : null;
        }
        return is;
    }

    protected InputStream findClasspathResource(Class<?> baseClass, String name, Locale locale) throws IOException {
        if (locale == null) {
            return baseClass.getResourceAsStream(name);
        }
        for (String n : this.getCandidateFileNames(name, locale)) {
            InputStream is = baseClass.getResourceAsStream(n);
            if (is == null) continue;
            return is;
        }
        return null;
    }

    protected InputStream findFileSystemResource(String name, Locale locale) throws IOException {
        for (String n2 : this.getCandidateFileNames(name, locale)) {
            File f = new File(n2);
            if (!f.exists() || !f.isFile() || !f.canRead() || f.isAbsolute()) continue;
            return new FileInputStream(f);
        }
        return null;
    }

    Iterable<String> getCandidateFileNames(final String fileName, final Locale l) {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    final Iterator<Locale> locales;
                    String baseName;
                    String ext;
                    {
                        this.locales = BasicResourceFinder.getCandidateLocales(l).iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.locales.hasNext();
                    }

                    @Override
                    public String next() {
                        Locale l2 = this.locales.next();
                        if (l2.toString().isEmpty()) {
                            return fileName;
                        }
                        if (this.baseName == null) {
                            this.baseName = FileUtils.getBaseName(fileName);
                        }
                        if (this.ext == null) {
                            this.ext = FileUtils.getExtension(fileName);
                        }
                        return this.baseName + "_" + l2.toString() + (this.ext.isEmpty() ? "" : '.' + this.ext);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    static final List<Locale> getCandidateLocales(Locale locale) {
        if (locale == null) {
            return ROOT_LOCALE;
        }
        return RB_CONTROL.getCandidateLocales("", locale);
    }

    private static boolean isInvalidName(String name) {
        return StringUtils.isEmpty(name) || name.contains("..");
    }
}

