/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.xml.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.xml.annotation.Xml;
import org.apache.juneau.xml.annotation.XmlFormat;

public class XmlAnnotation
implements Xml {
    private String on = "";
    private String childName = "";
    private String namespace = "";
    private String prefix = "";
    private XmlFormat format = XmlFormat.DEFAULT;

    public XmlAnnotation(String on) {
        this.on(on);
    }

    public XmlAnnotation(Class<?> on) {
        this.on(on);
    }

    public XmlAnnotation(Method on) {
        this.on(on);
    }

    public XmlAnnotation(Field on) {
        this.on(on);
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return Xml.class;
    }

    @Override
    public String childName() {
        return this.childName;
    }

    public XmlAnnotation childName(String value) {
        this.childName = value;
        return this;
    }

    @Override
    public XmlFormat format() {
        return this.format;
    }

    public XmlAnnotation format(XmlFormat value) {
        this.format = value;
        return this;
    }

    @Override
    public String namespace() {
        return this.namespace;
    }

    public XmlAnnotation namespace(String value) {
        this.namespace = value;
        return this;
    }

    @Override
    public String on() {
        return this.on;
    }

    public XmlAnnotation on(String value) {
        this.on = value;
        return this;
    }

    public XmlAnnotation on(Class<?> value) {
        this.on = value.getName();
        return this;
    }

    public XmlAnnotation on(Method value) {
        this.on = MethodInfo.of(value).getFullName();
        return this;
    }

    public XmlAnnotation on(Field value) {
        this.on = value.getName();
        return this;
    }

    @Override
    public String prefix() {
        return this.prefix;
    }

    public XmlAnnotation prefix(String value) {
        this.prefix = value;
        return this;
    }
}

