/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.microservice.resources;

import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.dto.html5.Form;
import org.apache.juneau.dto.html5.HtmlBuilder;
import org.apache.juneau.html.annotation.HtmlDocConfig;
import org.apache.juneau.http.annotation.Content;
import org.apache.juneau.http.annotation.FormData;
import org.apache.juneau.http.annotation.Path;
import org.apache.juneau.http.annotation.Response;
import org.apache.juneau.http.annotation.Schema;
import org.apache.juneau.http.response.NotFound;
import org.apache.juneau.rest.annotation.OpSwagger;
import org.apache.juneau.rest.annotation.Rest;
import org.apache.juneau.rest.annotation.RestGet;
import org.apache.juneau.rest.annotation.RestPost;
import org.apache.juneau.rest.annotation.RestPut;
import org.apache.juneau.rest.config.BasicUniversalConfig;
import org.apache.juneau.rest.servlet.BasicRestServlet;

@Rest(path="/config", title={"Configuration"}, description={"Contents of configuration file."})
@HtmlDocConfig(navlinks={"up: request:/..", "api: servlet:/api", "stats: servlet:/stats", "edit: servlet:/edit"})
public class ConfigResource
extends BasicRestServlet
implements BasicUniversalConfig {
    private static final long serialVersionUID = 1L;

    @RestGet(path={"/"}, summary="Get config file contents", description={"Show contents of config file as a JsonMap."}, swagger=@OpSwagger(responses={"200:{ description:'Config file as a map of map of objects.', example:{'':{defaultKey:'defaultValue'},'Section1':{key1:'val1',key2:123}}}"}))
    public JsonMap getConfig() {
        return this.getContext().getConfig().toMap();
    }

    @RestGet(path={"/edit"}, summary="Render form entry page for editing config file", description={"Renders a form entry page for editing the raw text of a config file."})
    public Form getConfigEditForm() {
        return HtmlBuilder.form().id("form").action("servlet:/").method("POST").enctype("application/x-www-form-urlencoded").children(new Object[]{HtmlBuilder.div()._class("data").children(new Object[]{HtmlBuilder.table((Object[])new Object[]{HtmlBuilder.tr((Object[])new Object[]{HtmlBuilder.td().style("text-align:right").children(new Object[]{HtmlBuilder.button((String)"submit", (Object[])new Object[]{"Submit"}), HtmlBuilder.button((String)"reset", (Object[])new Object[]{"Reset"})})}), HtmlBuilder.tr((Object[])new Object[]{HtmlBuilder.th().child((Object)"Contents")}), HtmlBuilder.tr((Object[])new Object[]{HtmlBuilder.th().child((Object)HtmlBuilder.textarea().name("contents").rows((Number)40).cols((Object)120).style("white-space:pre;word-wrap:normal;overflow-x:scroll;font-family:monospace;").text((Object)this.getContext().getConfig().toString()))})})})});
    }

    @RestGet(path={"/{section}"}, summary="Get config file section contents", description={"Show contents of config file section as a JsonMap."}, swagger=@OpSwagger(responses={"200:{ description:'Config file section as a map of objects.', example:{key1:'val1',key2:123}}"}))
    public JsonMap getConfigSection(@Path(value="section") @Schema(d={"Section name in config file."}) String section) throws SectionNotFound {
        return this.getSection(section);
    }

    @RestGet(path={"/{section}/{key}"}, summary="Get config file entry value", description={"Show value of config file entry as a simple string."}, swagger=@OpSwagger(responses={"200:{ description:'Entry value.', example:'servlet:/htdocs/themes/dark.css'}"}))
    public String getConfigEntry(@Path(value="section") @Schema(d={"Section name in config file."}) String section, @Path(value="key") @Schema(d={"Key name in section."}) String key) throws SectionNotFound {
        return this.getSection(section).getString(key);
    }

    @RestPost(path={"/"}, summary="Update config file contents", description={"Update the contents of the config file from a FORM post."}, swagger=@OpSwagger(responses={"200:{ description:'Config file section as a map of objects.', example:{key1:'val1',key2:123}}"}))
    public JsonMap setConfigContentsFormPost(@FormData(value="contents") @Schema(d={"New contents in INI file format."}) String contents) throws Exception {
        return this.setConfigContents(new StringReader(contents));
    }

    @RestPut(path={"/"}, summary="Update config file contents", description={"Update the contents of the config file from raw text."}, swagger=@OpSwagger(responses={"200:{ description:'Config file section as a map of objects.', example:{key1:'val1',key2:123}}"}))
    public JsonMap setConfigContents(@Content @Schema(d={"New contents in INI file format."}) Reader contents) throws Exception {
        return this.getContext().getConfig().load(contents, true).toMap();
    }

    @RestPut(path={"/{section}"}, summary="Update config section contents", description={"Add or overwrite a config file section."}, swagger=@OpSwagger(responses={"200:{ description:'Config file section as a map of objects.', example:{key1:'val1',key2:123}}"}))
    public JsonMap setConfigSection(@Path(value="section") @Schema(d={"Section name in config file."}) String section, @Content @Schema(d={"New contents of config section as a simple map of key/value pairs."}) Map<String, Object> contents) throws Exception {
        this.getContext().getConfig().setSection(section, null, contents);
        return this.getSection(section);
    }

    @RestPut(path={"/{section}/{key}"}, summary="Update config entry value", description={"Add or overwrite a config file entry."}, swagger=@OpSwagger(responses={"200:{ description:'The updated value.', example:'servlet:/htdocs/themes/dark.css'}"}))
    public String setConfigValue(@Path(value="section") @Schema(d={"Section name in config file."}) String section, @Path(value="key") @Schema(d={"Key name in section."}) String key, @Content @Schema(d={"New value for entry."}) String value) throws SectionNotFound {
        this.getContext().getConfig().set(section + '/' + key, value);
        return this.getSection(section).getString(key);
    }

    private JsonMap getSection(String name) throws SectionNotFound {
        return (JsonMap)this.getContext().getConfig().getSection(name).asMap().orElseThrow(() -> new SectionNotFound());
    }

    @Response
    @Schema(description={"Section not found."})
    private class SectionNotFound
    extends NotFound {
        private static final long serialVersionUID = 1L;

        SectionNotFound() {
            super("Section not found.", new Object[0]);
        }
    }
}

