/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.util.NoSuchElementException;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.juneau.assertions.Assertions;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.internal.ThrowableUtils;

public class BasicHeaderIterator
implements HeaderIterator {
    private final Header[] entries;
    private final String name;
    private final boolean caseSensitive;
    private int currentIndex;

    public BasicHeaderIterator(Header[] headers, String name, boolean caseSensitive) {
        this.entries = Assertions.assertArgNotNull("headers", headers);
        this.name = name;
        this.caseSensitive = caseSensitive;
        this.currentIndex = this.findNext(-1);
    }

    private int findNext(int pos) {
        int from = pos;
        int to = this.entries.length - 1;
        boolean found = false;
        while (!found && from < to) {
            found = this.filter(++from);
        }
        return found ? from : -1;
    }

    private boolean filter(int index) {
        return this.name == null || this.eq(this.name, this.entries[index].getName());
    }

    @Override
    public boolean hasNext() {
        return this.currentIndex >= 0;
    }

    @Override
    public Header nextHeader() throws NoSuchElementException {
        int current = this.currentIndex;
        if (current < 0) {
            throw new NoSuchElementException("Iteration already finished.");
        }
        this.currentIndex = this.findNext(current);
        return this.entries[current];
    }

    @Override
    public final Object next() throws NoSuchElementException {
        return this.nextHeader();
    }

    @Override
    public void remove() {
        throw ThrowableUtils.unsupportedOperationException("Not supported.", new Object[0]);
    }

    private boolean eq(String s1, String s2) {
        return StringUtils.eq(!this.caseSensitive, s1, s2);
    }
}

