/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto;

import java.net.URI;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.common.internal.ThrowableUtils;
import org.apache.juneau.html.annotation.HtmlLink;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.SchemaValidationException;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.oapi.OpenApiSerializer;
import org.apache.juneau.serializer.SerializeException;

@HtmlLink
@Bean(findFluentSetters=true)
public class LinkString
implements Comparable<LinkString> {
    private String name;
    private URI uri;

    public LinkString() {
    }

    public LinkString(String name, String uri, Object ... uriArgs) {
        this.setName(name);
        this.setUri(uri, uriArgs);
    }

    public String getName() {
        return this.name;
    }

    public LinkString setName(String value) {
        this.name = value;
        return this;
    }

    public URI getUri() {
        return this.uri;
    }

    public LinkString setUri(URI value) {
        this.uri = value;
        return this;
    }

    public LinkString setUri(String value) {
        this.setUri(value, new Object[0]);
        return this;
    }

    public LinkString setUri(String value, Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            try {
                args[i] = OpenApiSerializer.DEFAULT.getSession().serialize(HttpPartType.PATH, null, args[i]);
                continue;
            }
            catch (SchemaValidationException | SerializeException e) {
                throw ThrowableUtils.asRuntimeException((Throwable)e);
            }
        }
        this.uri = URI.create(StringUtils.format((String)value, (Object[])args));
        return this;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(LinkString o) {
        return this.name.compareTo(o.name);
    }

    public boolean equals(Object o) {
        return o instanceof LinkString && ObjectUtils.eq((Object)this, (Object)((LinkString)o), (x, y) -> x.name.equals(y.name));
    }

    public int hashCode() {
        return super.hashCode();
    }
}

