/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.httppart.bean;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.juneau.AnnotationWorkList;
import org.apache.juneau.BeanContext;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.cp.BeanCreator;
import org.apache.juneau.http.annotation.Content;
import org.apache.juneau.http.annotation.FormData;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.annotation.Path;
import org.apache.juneau.http.annotation.Query;
import org.apache.juneau.http.annotation.Request;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.httppart.bean.RequestBeanPropertyMeta;
import org.apache.juneau.httppart.bean.Utils;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.ParamInfo;

public class RequestBeanMeta {
    private final ClassMeta<?> cm;
    private final Map<String, RequestBeanPropertyMeta> properties;
    private final HttpPartSerializer serializer;
    private final HttpPartParser parser;

    public static RequestBeanMeta create(ParamInfo mpi, AnnotationWorkList annotations) {
        if (mpi.hasNoAnnotation(Request.class)) {
            return null;
        }
        return new Builder(annotations).apply(mpi).build();
    }

    public static RequestBeanMeta create(Class<?> c, AnnotationWorkList annotations) {
        ClassInfo ci = ClassInfo.of(c);
        if (ci.hasNoAnnotation(Request.class)) {
            return null;
        }
        return new Builder(annotations).apply(c).build();
    }

    RequestBeanMeta(Builder b) {
        this.cm = b.cm;
        this.serializer = b.serializer.orElse(null);
        this.parser = b.parser.orElse(null);
        LinkedHashMap properties = CollectionUtils.map();
        b.properties.forEach((k, v) -> properties.put(k, v.build(this.serializer, this.parser)));
        this.properties = CollectionUtils.unmodifiable(properties);
    }

    public ClassMeta<?> getClassMeta() {
        return this.cm;
    }

    public RequestBeanPropertyMeta getProperty(String name) {
        return this.properties.get(name);
    }

    public Collection<RequestBeanPropertyMeta> getProperties() {
        return this.properties.values();
    }

    static class Builder {
        ClassMeta<?> cm;
        AnnotationWorkList annotations;
        BeanCreator<HttpPartSerializer> serializer = BeanCreator.of(HttpPartSerializer.class);
        BeanCreator<HttpPartParser> parser = BeanCreator.of(HttpPartParser.class);
        Map<String, RequestBeanPropertyMeta.Builder> properties = CollectionUtils.map();

        Builder(AnnotationWorkList annotations) {
            this.annotations = annotations;
        }

        Builder apply(ParamInfo mpi) {
            return this.apply(mpi.getParameterType().inner()).apply(mpi.getAnnotation(Request.class));
        }

        Builder apply(Class<?> c) {
            this.cm = BeanContext.DEFAULT.getClassMeta(c);
            this.apply(this.cm.getLastAnnotation(Request.class));
            this.cm.getInfo().forEachPublicMethod(x -> true, x -> {
                String n = x.getSimpleName();
                if (x.hasAnnotation(Header.class)) {
                    Utils.assertNoArgs(x, Header.class);
                    Utils.assertReturnNotVoid(x, Header.class);
                    this.properties.put(n, RequestBeanPropertyMeta.create(HttpPartType.HEADER, Header.class, x));
                } else if (x.hasAnnotation(Query.class)) {
                    Utils.assertNoArgs(x, Query.class);
                    Utils.assertReturnNotVoid(x, Query.class);
                    this.properties.put(n, RequestBeanPropertyMeta.create(HttpPartType.QUERY, Query.class, x));
                } else if (x.hasAnnotation(FormData.class)) {
                    Utils.assertNoArgs(x, FormData.class);
                    Utils.assertReturnNotVoid(x, FormData.class);
                    this.properties.put(n, RequestBeanPropertyMeta.create(HttpPartType.FORMDATA, FormData.class, x));
                } else if (x.hasAnnotation(Path.class)) {
                    Utils.assertNoArgs(x, Path.class);
                    Utils.assertReturnNotVoid(x, Path.class);
                    this.properties.put(n, RequestBeanPropertyMeta.create(HttpPartType.PATH, Path.class, x));
                } else if (x.hasAnnotation(Content.class)) {
                    Utils.assertNoArgs(x, Content.class);
                    Utils.assertReturnNotVoid(x, Content.class);
                    this.properties.put(n, RequestBeanPropertyMeta.create(HttpPartType.BODY, Content.class, x));
                }
            });
            return this;
        }

        Builder apply(Request a) {
            if (a != null) {
                if (ClassUtils.isNotVoid(a.serializer())) {
                    this.serializer.type(a.serializer());
                }
                if (ClassUtils.isNotVoid(a.parser())) {
                    this.parser.type(a.parser());
                }
            }
            return this;
        }

        RequestBeanMeta build() {
            return new RequestBeanMeta(this);
        }
    }
}

