/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules.materialize;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgram;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.rules.materialize.MaterializedViewRule;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexSimplify;
import org.apache.calcite.rex.RexTableInputRef;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.Pair;
import org.apache.kylin.guava30.shaded.common.collect.BiMap;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.apache.kylin.guava30.shaded.common.collect.Multimap;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class MaterializedViewJoinRule<C extends MaterializedViewRule.Config>
extends MaterializedViewRule<C> {
    MaterializedViewJoinRule(C config) {
        super(config);
    }

    @Override
    protected boolean isValidPlan(@Nullable Project topProject, RelNode node, RelMetadataQuery mq) {
        return this.isValidRelNodePlan(node, mq);
    }

    @Override
    protected @Nullable MaterializedViewRule.ViewPartialRewriting compensateViewPartial(RelBuilder relBuilder, RexBuilder rexBuilder, RelMetadataQuery mq, RelNode input, @Nullable Project topProject, RelNode node, Set<RexTableInputRef.RelTableRef> queryTableRefs, MaterializedViewRule.EquivalenceClasses queryEC, @Nullable Project topViewProject, RelNode viewNode, Set<RexTableInputRef.RelTableRef> viewTableRefs) {
        if (((MaterializedViewRule.Config)this.config).fastBailOut()) {
            for (RelNode relNode : node.getInputs()) {
                Set<RexTableInputRef.RelTableRef> tableReferences = mq.getTableReferences(relNode);
                if (tableReferences != null && !tableReferences.containsAll(viewTableRefs)) continue;
                return null;
            }
        }
        HashSet<RexTableInputRef.RelTableRef> extraTableRefs = new HashSet<RexTableInputRef.RelTableRef>();
        for (RexTableInputRef.RelTableRef tRef : queryTableRefs) {
            if (viewTableRefs.contains(tRef)) continue;
            extraTableRefs.add(tRef);
        }
        Multimap<Class<? extends RelNode>, RelNode> multimap = mq.getNodeTypes(node);
        if (multimap == null) {
            return null;
        }
        Collection tableScanNodes = multimap.get(TableScan.class);
        ArrayList<RelNode> newRels = new ArrayList<RelNode>();
        block2: for (RexTableInputRef.RelTableRef relTableRef : extraTableRefs) {
            int i = 0;
            for (RelNode relNode : tableScanNodes) {
                TableScan scan = (TableScan)relNode;
                if (!relTableRef.getQualifiedName().equals(scan.getTable().getQualifiedName()) || relTableRef.getEntityNumber() != i++) continue;
                newRels.add(relNode);
                continue block2;
            }
        }
        assert (extraTableRefs.size() == newRels.size());
        relBuilder.push(input);
        for (RelNode relNode : newRels) {
            relBuilder.push(relNode);
            relBuilder.join(JoinRelType.INNER, rexBuilder.makeLiteral(true));
        }
        RelNode newView = relBuilder.build();
        relBuilder.push(topViewProject != null ? topViewProject : viewNode);
        for (RelNode newRel : newRels) {
            relBuilder.push(newRel);
            relBuilder.join(JoinRelType.INNER, rexBuilder.makeLiteral(true));
        }
        RelNode relNode = relBuilder.build();
        return MaterializedViewRule.ViewPartialRewriting.of(newView, null, relNode);
    }

    @Override
    protected @Nullable RelNode rewriteQuery(RelBuilder relBuilder, RexBuilder rexBuilder, RexSimplify simplify, RelMetadataQuery mq, RexNode compensationColumnsEquiPred, RexNode otherCompensationPred, @Nullable Project topProject, RelNode node, BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef> viewToQueryTableMapping, MaterializedViewRule.EquivalenceClasses viewEC, MaterializedViewRule.EquivalenceClasses queryEC) {
        RelNode newNode = node;
        RelNode target = node;
        HepProgram unionRewritingPullProgram = ((MaterializedViewRule.Config)this.config).unionRewritingPullProgram();
        if (unionRewritingPullProgram != null) {
            HepPlanner tmpPlanner = new HepPlanner(unionRewritingPullProgram);
            tmpPlanner.setRoot(newNode);
            newNode = tmpPlanner.findBestExp();
            target = newNode.getInput(0);
        }
        List<RexNode> queryExprs = this.extractReferences(rexBuilder, target);
        if (!compensationColumnsEquiPred.isAlwaysTrue()) {
            RexNode newCompensationColumnsEquiPred = this.rewriteExpression(rexBuilder, mq, target, target, queryExprs, (BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef>)viewToQueryTableMapping.inverse(), queryEC, false, compensationColumnsEquiPred);
            if (newCompensationColumnsEquiPred == null) {
                return null;
            }
            compensationColumnsEquiPred = newCompensationColumnsEquiPred;
        }
        if (!otherCompensationPred.isAlwaysTrue()) {
            RexNode newOtherCompensationPred = this.rewriteExpression(rexBuilder, mq, target, target, queryExprs, (BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef>)viewToQueryTableMapping.inverse(), viewEC, true, otherCompensationPred);
            if (newOtherCompensationPred == null) {
                return null;
            }
            otherCompensationPred = newOtherCompensationPred;
        }
        RexNode queryCompensationPred = RexUtil.not(RexUtil.composeConjunction(rexBuilder, (Iterable<? extends RexNode>)ImmutableList.of((Object)compensationColumnsEquiPred, (Object)otherCompensationPred)));
        RelNode rewrittenPlan = relBuilder.push(target).filter(simplify.simplifyUnknownAsFalse(queryCompensationPred)).build();
        if (unionRewritingPullProgram != null) {
            rewrittenPlan = newNode.copy(newNode.getTraitSet(), (List<RelNode>)ImmutableList.of((Object)rewrittenPlan));
        }
        if (topProject != null) {
            return topProject.copy(topProject.getTraitSet(), (List<RelNode>)ImmutableList.of((Object)rewrittenPlan));
        }
        return rewrittenPlan;
    }

    @Override
    protected @Nullable RelNode createUnion(RelBuilder relBuilder, RexBuilder rexBuilder, @Nullable RelNode topProject, RelNode unionInputQuery, RelNode unionInputView) {
        relBuilder.push(unionInputQuery);
        relBuilder.push(unionInputView);
        relBuilder.union(true);
        ArrayList<RexNode> exprList = new ArrayList<RexNode>(relBuilder.peek().getRowType().getFieldCount());
        ArrayList<String> nameList = new ArrayList<String>(relBuilder.peek().getRowType().getFieldCount());
        for (int i = 0; i < relBuilder.peek().getRowType().getFieldCount(); ++i) {
            RelDataTypeField field = unionInputQuery.getRowType().getFieldList().get(i);
            exprList.add(rexBuilder.ensureType(field.getType(), rexBuilder.makeInputRef(relBuilder.peek(), i), true));
            nameList.add(field.getName());
        }
        relBuilder.project(exprList, nameList);
        return relBuilder.build();
    }

    @Override
    protected @Nullable RelNode rewriteView(RelBuilder relBuilder, RexBuilder rexBuilder, RexSimplify simplify, RelMetadataQuery mq, MaterializedViewRule.MatchModality matchModality, boolean unionRewriting, RelNode input, @Nullable Project topProject, RelNode node, @Nullable Project topViewProject, RelNode viewNode, BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef> queryToViewTableMapping, MaterializedViewRule.EquivalenceClasses queryEC) {
        List<RexNode> exprs = topProject == null ? this.extractReferences(rexBuilder, node) : topProject.getProjects();
        ArrayList<RexNode> exprsLineage = new ArrayList<RexNode>(exprs.size());
        for (RexNode expr : exprs) {
            Set<RexNode> lineages = mq.getExpressionLineage(node, expr);
            if (lineages == null) {
                return null;
            }
            if (lineages.size() != 1) {
                throw new IllegalStateException("We only support project - filter - join, thus expression lineage should map to a single expression, got: '" + lineages + "' for expr '" + expr + "' in node '" + node + "'");
            }
            exprsLineage.add(RexUtil.swapColumnReferences(rexBuilder, lineages.iterator().next(), queryEC.getEquivalenceClassesMap()));
        }
        List<RexNode> viewExprs = topViewProject == null ? this.extractReferences(rexBuilder, viewNode) : topViewProject.getProjects();
        List<RexNode> rewrittenExprs = this.rewriteExpressions(rexBuilder, mq, input, viewNode, viewExprs, (BiMap<RexTableInputRef.RelTableRef, RexTableInputRef.RelTableRef>)queryToViewTableMapping.inverse(), queryEC, true, exprsLineage);
        if (rewrittenExprs == null) {
            return null;
        }
        return relBuilder.push(input).project(rewrittenExprs).convert(topProject != null ? topProject.getRowType() : node.getRowType(), false).build();
    }

    @Override
    public Pair<@Nullable RelNode, RelNode> pushFilterToOriginalViewPlan(RelBuilder builder, @Nullable RelNode topViewProject, RelNode viewNode, RexNode cond) {
        return Pair.of(topViewProject, viewNode);
    }
}

