/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.util;

import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.rest.util.SparkUIUtil;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.SparderEnv;
import org.apache.spark.ui.SparkUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriComponentsBuilder;

@Component(value="sparderUIUtil")
public class SparderUIUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SparderUIUtil.class);
    public static final String UI_BASE = "/sparder";
    public static final String PROXY_LOCATION_BASE = KylinConfig.getInstanceFromEnv().getUIProxyLocation() + "/sparder";
    public static final String KYLIN_UI_BASE = "/kylin/sparder";
    private static final String SQL_EXECUTION_PAGE = "/SQL/execution/";
    private volatile String webUrl;
    private volatile String amSQLBase;
    private volatile String appId;
    private volatile String proxyBase;

    public void proxy(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        String currentWebUrl = this.getWebUrl();
        String uriPath = servletRequest.getRequestURI().substring(KYLIN_UI_BASE.length());
        if (!this.isProxyBaseEnabled()) {
            uriPath = uriPath.replace(this.proxyBase, "");
        }
        SparkUIUtil.resendSparkUIRequest((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse, (String)currentWebUrl, (String)uriPath, (String)PROXY_LOCATION_BASE);
    }

    public String getSQLTrackingPath(String id) throws IOException {
        this.checkVersion();
        return PROXY_LOCATION_BASE + (this.isProxyBaseEnabled() ? this.amSQLBase : SQL_EXECUTION_PAGE) + "?id=" + id;
    }

    private boolean isProxyBaseEnabled() {
        return Objects.nonNull(this.amSQLBase);
    }

    private String getWebUrl() throws IOException {
        this.checkVersion();
        return this.webUrl;
    }

    private void checkVersion() throws IOException {
        SparkContext sc = SparderEnv.getSparkSession().sparkContext();
        SparkUI ui = (SparkUI)sc.ui().get();
        if (ui.appId().equals(this.appId)) {
            return;
        }
        this.proxyBase = "/proxy/" + ui.appId();
        this.amSQLBase = null;
        try (ClientHttpResponse response = SparkUIUtil.execute((URI)UriComponentsBuilder.fromHttpUrl((String)ui.webUrl()).path(SQL_EXECUTION_PAGE).query("id=1").build().toUri(), (HttpMethod)HttpMethod.GET, (String)PROXY_LOCATION_BASE);){
            if (response.getStatusCode().is3xxRedirection()) {
                URI uri = response.getHeaders().getLocation();
                this.amSQLBase = Objects.requireNonNull(uri).getPath();
                this.webUrl = uri.getScheme() + "://" + uri.getHost() + ":" + uri.getPort();
                this.appId = ui.appId();
                return;
            }
            this.webUrl = ui.webUrl();
            this.appId = ui.appId();
        }
    }

    @Scheduled(cron="${kylin.query.engine.periodicGC.crontab:-}")
    public void periodicGC() {
        log.info("periodicGC start, crontab is {}", (Object)KylinConfig.getInstanceFromEnv().getQueryEnginePeriodicGCCrontab());
        System.gc();
    }
}

