/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.profiler;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.StandardCopyOption;
import java.util.Objects;
import org.apache.kylin.common.KylinConfigBase;
import org.apache.kylin.profiler.AsyncArchUtil;
import org.apache.kylin.profiler.AsyncProfilerTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncProfiler {
    private static final Logger logger = LoggerFactory.getLogger(AsyncProfiler.class);
    private static final String LIB_PARENT = "/async-profiler-lib/";
    private static AsyncProfiler profiler;
    private boolean loaded = false;

    public static synchronized AsyncProfiler getInstance(boolean loadLocalLib) {
        if (profiler == null) {
            profiler = new AsyncProfiler(loadLocalLib);
        }
        return profiler;
    }

    private AsyncProfiler(boolean loadLocalLib) {
        try {
            boolean isTestingOnLocalMac;
            boolean bl = isTestingOnLocalMac = System.getProperty("os.name", "").contains("Mac") || System.getProperty("os.name", "").contains("OS X");
            if (isTestingOnLocalMac) {
                this.loadLibAsyncProfilerSO("/async-profiler-lib/libasyncProfiler-mac.so");
            } else {
                String libName;
                AsyncArchUtil.ArchType archType = AsyncArchUtil.getProcessor();
                boolean isMuslLibc = AsyncArchUtil.isMuslLibc();
                logger.info("Machine's archType: {}, isMuslLibc: {}", (Object)archType, (Object)isMuslLibc);
                switch (archType) {
                    case LINUX_ARM64: {
                        libName = "libasyncProfiler-linux-arm64.so";
                        break;
                    }
                    default: {
                        libName = "libasyncProfiler-linux-x64.so";
                    }
                }
                File libPath = loadLocalLib ? new File(KylinConfigBase.getKylinHome() + "/lib/" + libName) : new File(libName);
                logger.info("AsyncProfiler libPath: {}, exists: {}", (Object)libPath.getAbsolutePath(), (Object)Files.exists(libPath.toPath(), new LinkOption[0]));
                if (libPath.exists()) {
                    System.load(libPath.getAbsolutePath());
                } else {
                    this.loadLibAsyncProfilerSO(LIB_PARENT + libName);
                }
            }
            this.loaded = true;
        }
        catch (Exception e) {
            logger.error("async lib loading failed.", (Throwable)e);
        }
    }

    private void loadLibAsyncProfilerSO(String libPath) throws IOException {
        File asyncProfilerLib = File.createTempFile("libasyncProfiler", ".so");
        Files.copy(Objects.requireNonNull(AsyncProfilerTool.class.getResourceAsStream(libPath)), asyncProfilerLib.toPath(), StandardCopyOption.REPLACE_EXISTING);
        logger.info("AsyncProfiler will try to load from libPath: {}, exists: {}", (Object)asyncProfilerLib.getAbsolutePath(), (Object)asyncProfilerLib.exists());
        System.load(asyncProfilerLib.getAbsolutePath());
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void stop() throws IllegalStateException {
        if (this.loaded) {
            this.stop0();
        } else {
            logger.error("invalid operation stop(). async lib loading failed.");
        }
    }

    public String execute(String command) throws IllegalArgumentException, IllegalStateException, IOException {
        if (this.loaded) {
            return this.execute0(command);
        }
        logger.error("invalid operation execute(). async lib loading failed.");
        return "";
    }

    public native void start0(String var1, long var2, boolean var4) throws IllegalStateException;

    public native void stop0() throws IllegalStateException;

    public native String execute0(String var1) throws IllegalArgumentException, IllegalStateException, IOException;

    public native void filterThread0(Thread var1, boolean var2);
}

