/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.util;

import java.util.Comparator;
import org.apache.kylin.rest.util.ModelTriple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.support.MutableSortDefinition;
import org.springframework.beans.support.SortDefinition;

public class ModelTripleComparator
implements Comparator<ModelTriple> {
    private static final Logger logger = LoggerFactory.getLogger(ModelTripleComparator.class);
    private final SortDefinition sortDefinition;
    private final BeanWrapperImpl beanWrapper = new BeanWrapperImpl(false);
    private int sortKey;

    public ModelTripleComparator(String property, boolean ascending, int sortKey) {
        this.sortDefinition = new MutableSortDefinition(property, false, ascending);
        this.sortKey = sortKey;
    }

    @Override
    public int compare(ModelTriple o1, ModelTriple o2) {
        int result;
        if (o1 == null || o2 == null) {
            return 0;
        }
        try {
            Object v2;
            Object v1;
            if (this.sortKey == 1) {
                v1 = this.getPropertyValue(o1.getDataflow());
                v2 = this.getPropertyValue(o2.getDataflow());
            } else if (this.sortKey == 2) {
                v1 = this.getPropertyValue(o1.getDataModel());
                v2 = this.getPropertyValue(o2.getDataModel());
            } else {
                v1 = o1.getCalcObject();
                v2 = o2.getCalcObject();
            }
            result = v1 != null ? (v2 != null ? ((Comparable)v1).compareTo(v2) : -1) : (v2 != null ? 1 : 0);
        }
        catch (RuntimeException ex) {
            logger.warn("Could not sort objects [{}] and [{}]", new Object[]{o1, o2, ex});
            return 0;
        }
        return this.sortDefinition.isAscending() ? result : -result;
    }

    public Object getPropertyValue(Object obj) {
        try {
            this.beanWrapper.setWrappedInstance(obj);
            return this.beanWrapper.getPropertyValue(this.sortDefinition.getProperty());
        }
        catch (BeansException ex) {
            logger.info("PropertyComparator could not access property - treating as null for sorting", (Throwable)ex);
            return null;
        }
    }
}

