/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rec;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.calcite.sql.parser.impl.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.apache.kylin.guava30.shaded.common.base.Throwables;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.rec.AbstractContext;
import org.apache.kylin.rec.AbstractProposer;
import org.apache.kylin.rec.common.AccelerateInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartMaster {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SmartMaster.class);
    private final String project;
    public final AbstractContext context;

    public SmartMaster(AbstractContext proposeContext) {
        this.context = proposeContext;
        this.project = proposeContext.getProject();
    }

    public AbstractProposer getProposer(String name) {
        for (AbstractProposer proposer : this.getContext().getProposers().getProposerList()) {
            if (!proposer.getIdentifierName().equalsIgnoreCase(name)) continue;
            return proposer;
        }
        throw new IllegalArgumentException("Wrong proposer name: " + name);
    }

    public void executePropose() {
        this.getContext().getProposers().execute();
    }

    @VisibleForTesting
    public void runUtWithContext(Consumer<AbstractContext> hook) {
        this.runWithContext(hook);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWithContext(Consumer<AbstractContext> hook) {
        long start = System.currentTimeMillis();
        try {
            this.getContext().getProposers().execute();
            this.getContext().saveMetadata();
            if (hook != null) {
                hook.accept(this.getContext());
            }
        }
        catch (Exception exception) {
            this.recordError(exception);
        }
        finally {
            log.info("The whole process of {} takes {}ms", (Object)this.context.getIdentifier(), (Object)(System.currentTimeMillis() - start));
            this.genDiagnoseInfo();
        }
    }

    private void recordError(Throwable throwable) {
        this.context.getAccelerateInfoMap().forEach((key, value) -> {
            value.getRelatedLayouts().clear();
            value.setFailedCause(throwable);
        });
    }

    private void genDiagnoseInfo() {
        if (this.context == null) {
            log.error("Unlikely exception without proposing context!");
            return;
        }
        Map<String, AccelerateInfo> accelerationMap = this.context.getAccelerateInfoMap();
        HashMap failureMap = Maps.newHashMap();
        int pendingNum = 0;
        for (Map.Entry<String, AccelerateInfo> entry : accelerationMap.entrySet()) {
            String expr;
            if (!entry.getValue().isNotSucceed()) continue;
            if (entry.getValue().isPending()) {
                ++pendingNum;
            }
            if (entry.getValue().getFailedCause() != null) {
                Throwable rootCause = Throwables.getRootCause((Throwable)entry.getValue().getFailedCause());
                String stackTraces = StringUtils.join((Object[])rootCause.getStackTrace(), (String)"\n");
                expr = rootCause instanceof ParseException ? "\nRoot cause: " + rootCause.getMessage().split("\n")[0] + "\n" + stackTraces : "\nRoot cause: " + rootCause.getMessage() + "\n" + stackTraces;
            } else {
                expr = "\nPending message: " + entry.getValue().getPendingMsg();
            }
            if (failureMap.get(expr) == null) {
                failureMap.putIfAbsent(expr, Sets.newHashSet());
            }
            ((Set)failureMap.get(expr)).add(entry.getKey());
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\n================== diagnosis log for auto-modeling ====================\n");
        sb.append("This round accelerates ").append(accelerationMap.size()).append(" queries.\n");
        if (failureMap.isEmpty()) {
            sb.append("No exceptions occurred.");
            sb.append("\n=======================================================================");
            log.info(sb.toString());
        } else {
            int failedNum = failureMap.values().stream().map(Set::size).reduce(Integer::sum).orElse(-1);
            sb.append("SUCCESS: ").append(accelerationMap.size() - failedNum);
            if (pendingNum != 0) {
                sb.append(", PENDING: ").append(pendingNum);
                sb.append(", FAILED: ").append(failedNum - pendingNum);
            } else {
                sb.append(", FAILED: ").append(failedNum);
            }
            sb.append(".\nClassified details are as follows:");
            failureMap.forEach((failedTypeInfo, sqlSet) -> {
                sb.append("\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
                sb.append((String)failedTypeInfo).append("\n----------------\n");
                sb.append(String.join((CharSequence)"\n----------------\n", sqlSet));
            });
            sb.append("\n=======================================================================");
            log.error(sb.toString());
        }
    }

    @Generated
    public String getProject() {
        return this.project;
    }

    @Generated
    public AbstractContext getContext() {
        return this.context;
    }

    static enum AccStatusType {
        SUCCESS,
        PENDING,
        FAILED;

    }
}

