/*
 * Decompiled with CFR 0.152.
 */
package springfox.bean.validators.plugins.parameter;

import java.math.BigDecimal;
import java.util.Optional;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.bean.validators.plugins.RangeAnnotations;
import springfox.documentation.service.AllowableRangeValues;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ExpandedParameterBuilderPlugin;
import springfox.documentation.spi.service.contexts.ParameterExpansionContext;

@Component
@Order(value=-2147483148)
public class ExpandedParameterSizeAnnotationPlugin
implements ExpandedParameterBuilderPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(ExpandedParameterSizeAnnotationPlugin.class);

    @Override
    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    @Override
    public void apply(ParameterExpansionContext context) {
        Optional<Size> size = context.findAnnotation(Size.class);
        if (size.isPresent()) {
            AllowableRangeValues values = RangeAnnotations.stringLengthRange(size.get());
            LOG.debug("Adding allowable Values: {} - {}", (Object)values.getMin(), (Object)values.getMax());
            values = new AllowableRangeValues(values.getMin(), values.getMax());
            context.getParameterBuilder().allowableValues(values);
            AllowableRangeValues finalValues = values;
            context.getRequestParameterBuilder().query(q -> {
                q.numericFacet(n -> {
                    n.minimum(ExpandedParameterSizeAnnotationPlugin.safeBigDecimal(finalValues.getMin()));
                    n.maximum(ExpandedParameterSizeAnnotationPlugin.safeBigDecimal(finalValues.getMax()));
                });
                q.stringFacet(s -> {
                    s.minLength(ExpandedParameterSizeAnnotationPlugin.safeBigDecimal(finalValues.getMin()).intValue());
                    s.maxLength(ExpandedParameterSizeAnnotationPlugin.safeBigDecimal(finalValues.getMax()).intValue());
                });
            });
        }
    }

    static BigDecimal safeBigDecimal(String doubleString) {
        if (doubleString == null) {
            return null;
        }
        try {
            return new BigDecimal(doubleString);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

