/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.response;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.List;
import lombok.Generated;
import org.apache.kylin.rest.util.AclPermissionUtil;
import org.springframework.security.acls.model.Permission;
import org.springframework.security.acls.model.Sid;
import org.springframework.util.Assert;

public class AccessEntryResponse {
    private Permission permission;
    private Serializable id;
    private Sid sid;
    private boolean granting;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="ext_permissions")
    private List<Permission> extPermissions;

    public AccessEntryResponse() {
    }

    public AccessEntryResponse(Serializable id, Sid sid, Permission permission, boolean granting) {
        Assert.notNull((Object)sid, (String)"Sid required");
        Assert.notNull((Object)permission, (String)"Permission required");
        this.id = id;
        this.sid = sid;
        this.permission = AclPermissionUtil.convertToBasePermission((Permission)permission);
        this.extPermissions = AclPermissionUtil.convertToCompositePermission((Permission)permission).getExtPermissions();
        this.granting = granting;
    }

    public Permission getPermission() {
        return this.permission;
    }

    public void setPermission(Permission permission) {
        this.permission = AclPermissionUtil.convertToBasePermission((Permission)permission);
        this.extPermissions = AclPermissionUtil.convertToCompositePermission((Permission)permission).getExtPermissions();
    }

    public Serializable getId() {
        return this.id;
    }

    public Sid getSid() {
        return this.sid;
    }

    public boolean isGranting() {
        return this.granting;
    }

    @Generated
    public List<Permission> getExtPermissions() {
        return this.extPermissions;
    }
}

