/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.metadata.user.ManagedUser;
import org.apache.kylin.metadata.usergroup.UserGroup;
import org.apache.kylin.rest.response.UserGroupResponseKI;

public interface IUserGroupService {
    public List<String> listAllAuthorities() throws IOException;

    public List<String> getAuthoritiesFilterByGroupName(String var1) throws IOException;

    public List<UserGroup> listUserGroups() throws IOException;

    public List<UserGroup> getUserGroupsFilterByGroupName(String var1) throws IOException;

    public String getGroupNameByUuid(String var1);

    public String getUuidByGroupName(String var1);

    public boolean exists(String var1) throws IOException;

    public List<ManagedUser> getGroupMembersByName(String var1) throws IOException;

    public List<String> getAllUserGroups() throws IOException;

    public Set<String> listUserGroups(String var1);

    public void addGroup(String var1) throws IOException;

    public void deleteGroup(String var1) throws IOException;

    public void modifyGroupUsers(String var1, List<String> var2) throws IOException;

    public Map<String, List<String>> getUserAndUserGroup() throws IOException;

    public List<UserGroupResponseKI> getUserGroupResponse(List<UserGroup> var1) throws IOException;

    public void addGroups(List<String> var1);

    default public boolean isAdminGroup(String group) {
        return "ROLE_ADMIN".equalsIgnoreCase(group) || KylinConfig.getInstanceFromEnv().getLDAPAdminRole().equalsIgnoreCase(group);
    }
}

