/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence;

import java.util.Arrays;
import java.util.Collections;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.RawResourceFilter;
import org.apache.kylin.common.persistence.resources.ProjectRawResource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class RawResourceFilterTest {
    RawResourceFilterTest() {
    }

    @Test
    void testBasicFilter() {
        ProjectRawResource project = new ProjectRawResource();
        project.setName("p1");
        project.setMetaKey("p1");
        project.setUuid("uuid_p1");
        project.setMvcc(0L);
        project.setProject("_global");
        project.setTs(Long.valueOf(System.currentTimeMillis()));
        RawResourceFilter filter = new RawResourceFilter();
        filter.addConditions("uuid", Arrays.asList("uuid_p1", "uuid_p2"), RawResourceFilter.Operator.IN);
        filter.addConditions("mvcc", Collections.singletonList(4L), RawResourceFilter.Operator.LT);
        filter.addConditions("mvcc", Collections.singletonList(0L), RawResourceFilter.Operator.LE);
        filter.addConditions("ts", Collections.singletonList(100L), RawResourceFilter.Operator.GT);
        filter.addConditions("name", Collections.singletonList("p1"), RawResourceFilter.Operator.EQUAL);
        filter.addConditions("metaKey", Collections.singletonList("p1"), RawResourceFilter.Operator.EQUAL_CASE_INSENSITIVE);
        filter.addConditions("project", Collections.singletonList("ob"), RawResourceFilter.Operator.LIKE_CASE_INSENSITIVE);
        Assertions.assertTrue((boolean)filter.isMatch((RawResource)project));
        filter.addConditions("mvcc", Collections.singletonList(1L), RawResourceFilter.Operator.GE);
        Assertions.assertFalse((boolean)filter.isMatch((RawResource)project));
    }

    @Test
    void testReturnFalseWhenValueIsNull() {
        ProjectRawResource project = new ProjectRawResource();
        Assertions.assertFalse((boolean)RawResourceFilter.equalFilter((String)"reservedFiled1", null).isMatch((RawResource)project));
        Assertions.assertFalse((boolean)RawResourceFilter.equalFilter((String)"reservedFiled2", null).isMatch((RawResource)project));
        Assertions.assertFalse((boolean)RawResourceFilter.equalFilter((String)"reservedFiled3", null).isMatch((RawResource)project));
    }

    @Test
    void testUnsupportedFiled() {
        ProjectRawResource project = new ProjectRawResource();
        project.setId(Long.valueOf(1L));
        byte[] bytes = "abc".getBytes();
        project.setContent(bytes);
        RawResourceFilter filter = new RawResourceFilter();
        filter.addConditions("id", Collections.singletonList("1"), RawResourceFilter.Operator.EQUAL);
        filter.addConditions("content", Collections.singletonList(bytes), RawResourceFilter.Operator.EQUAL);
        Assertions.assertThrows(IllegalArgumentException.class, () -> filter.isMatch((RawResource)project));
    }

    @Test
    void testUnknownFiled() {
        ProjectRawResource project = new ProjectRawResource();
        RawResourceFilter filter = new RawResourceFilter();
        filter.addConditions("undefinedKey", Collections.singletonList("1"), RawResourceFilter.Operator.EQUAL);
        Assertions.assertThrows(IllegalArgumentException.class, () -> filter.isMatch((RawResource)project));
    }

    @Test
    void testNotValidValue() {
        ProjectRawResource project = new ProjectRawResource();
        project.setMvcc(10L);
        RawResourceFilter filter = RawResourceFilter.simpleFilter((RawResourceFilter.Operator)RawResourceFilter.Operator.EQUAL_CASE_INSENSITIVE, (String)"mvcc", (Object)1L);
        Assertions.assertThrows(AssertionError.class, () -> filter.isMatch((RawResource)project));
        RawResourceFilter filter2 = RawResourceFilter.simpleFilter((RawResourceFilter.Operator)RawResourceFilter.Operator.LIKE_CASE_INSENSITIVE, (String)"mvcc", (Object)1L);
        Assertions.assertThrows(AssertionError.class, () -> filter2.isMatch((RawResource)project));
    }
}

