/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.loader;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.NLocalFileMetadataTestCase;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.loader.ParserClassLoaderState;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ParserClassLoaderStateTest
extends NLocalFileMetadataTestCase {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private static final String PROJECT = "streaming_test";
    private static final String JAR_NAME = "custom_parser.jar";
    private static String JAR_ABS_PATH;

    @Before
    public void setup() throws Exception {
        this.createTestMetadata(new String[0]);
        this.init();
    }

    @After
    public void teardown() {
        this.cleanupTestMetadata();
        ParserClassLoaderState.getInstance((String)PROJECT).setLoadedJars((Set)Sets.newCopyOnWriteArraySet());
    }

    public void init() {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        Path metaPath = new Path(kylinConfig.getMetadataUrl().toString());
        Path jarPath = new Path(String.format("%s/%s/%s", metaPath.getParent().toString(), "jars", JAR_NAME));
        JAR_ABS_PATH = new File(jarPath.toString()).toURI().toString();
    }

    @Test
    public void testRegisterAndUnRegisterJar() {
        HashSet newPaths = Sets.newHashSet((Object[])new String[]{JAR_ABS_PATH});
        ParserClassLoaderState instance = ParserClassLoaderState.getInstance((String)PROJECT);
        instance.registerJars((Set)newPaths);
        try {
            instance.registerJars((Set)newPaths);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IllegalArgumentException));
        }
        instance.unregisterJar((Set)newPaths);
        this.thrown.expect(IllegalArgumentException.class);
        instance.setLoadedJars(null);
        instance.unregisterJar((Set)Sets.newHashSet((Object[])new String[]{"test"}));
    }
}

