/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.tree.Blocks;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.linq4j.tree.Node;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.sql.type.SqlTypeFactoryImpl;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.query.engine.KylinConnectionConfig;
import org.apache.kylin.query.relnode.ColumnRowType;
import org.apache.kylin.query.relnode.OlapAggregateRel;
import org.apache.kylin.query.relnode.OlapContext;
import org.apache.kylin.query.relnode.OlapMinusRel;
import org.apache.kylin.query.relnode.OlapProjectRel;
import org.apache.kylin.query.relnode.OlapRel;
import org.apache.kylin.query.relnode.OlapSortRel;
import org.apache.kylin.query.relnode.OlapToEnumerableConverter;
import org.apache.kylin.query.relnode.OlapUnionRel;
import org.apache.kylin.query.schema.OlapTable;
import org.apache.kylin.query.util.ICutContextStrategy;

public class OlapTableScan
extends TableScan
implements EnumerableRel,
OlapRel {
    private OlapTable olapTable;
    private String tableName;
    private int[] fields;
    private ColumnRowType columnRowType;
    private KylinConfig kylinConfig;
    private OlapContext context;
    private Set<OlapContext> subContexts = Sets.newHashSet();
    private String alias;
    private String backupAlias;
    private boolean contextVisited = false;

    public OlapTableScan(RelOptCluster cluster, RelOptTable table, OlapTable olapTable, int[] fields) {
        super(cluster, cluster.traitSetOf((RelTrait)CONVENTION), table);
        this.olapTable = olapTable;
        this.fields = fields;
        this.tableName = olapTable.getTableName();
        this.rowType = this.getRowType();
        this.kylinConfig = KylinConfig.getInstanceFromEnv();
    }

    private static RelOptCluster emptyCluster() {
        VolcanoPlanner emptyPlanner = new VolcanoPlanner();
        SqlTypeFactoryImpl typeFactory = new SqlTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        return RelOptCluster.create((RelOptPlanner)emptyPlanner, (RexBuilder)new RexBuilder((RelDataTypeFactory)typeFactory));
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        Preconditions.checkArgument((boolean)inputs.isEmpty());
        return new OlapTableScan(this.getCluster(), this.table, this.olapTable, this.fields);
    }

    public RelDataType deriveRowType() {
        List fieldList = this.table.getRowType().getFieldList();
        List list = Arrays.stream(this.fields).mapToObj(fieldList::get).collect(Collectors.toList());
        return this.getCluster().getTypeFactory().createStructType(list);
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq).multiplyBy(0.05);
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("ctx", (Object)this.displayCtxId(this.context)).item("fields", (Object)Primitive.asList((int[])this.fields));
    }

    @Override
    public void implementOlap(OlapRel.OlapImpl olapImpl) {
        this.context.getAllTableScans().add(this);
        this.columnRowType = this.buildColumnRowType();
        if (this.context.getOlapSchema() == null) {
            this.context.setOlapSchema(this.olapTable.getSchema());
        }
        if (this.context.getFirstTableScan() == null) {
            this.context.setFirstTableScan(this);
        }
        if (this.needCollectionColumns(olapImpl.getParentNodeStack())) {
            for (TblColRef tblColRef : this.columnRowType.getAllColumns()) {
                if (tblColRef.getName().startsWith("_KY_") || tblColRef.getColumnDesc().isComputedColumn() && !KylinConnectionConfig.current().exposeComputedColumn()) continue;
                this.context.getAllColumns().add(tblColRef);
            }
        }
    }

    private boolean needCollectionColumns(Deque<RelNode> allParents) {
        OlapRel topProjParent = null;
        for (RelNode tempParent : allParents) {
            if (tempParent instanceof OlapToEnumerableConverter) continue;
            if (!(tempParent instanceof OlapRel)) break;
            OlapRel parent = (OlapRel)tempParent;
            if (parent instanceof OlapSortRel) {
                ((OlapSortRel)parent).setNeedPushToSubCtx(true);
            }
            if (topProjParent == null && parent instanceof OlapProjectRel && !((OlapProjectRel)parent).isMerelyPermutation()) {
                topProjParent = parent;
            }
            if (!(parent instanceof OlapUnionRel) && !(parent instanceof OlapMinusRel) && !(parent instanceof OlapAggregateRel)) continue;
            topProjParent = null;
        }
        if (topProjParent != null) {
            ((OlapProjectRel)topProjParent).setNeedPushInfoToSubCtx(true);
        }
        return topProjParent == null;
    }

    private ColumnRowType buildColumnRowType() {
        this.alias = ("T_" + this.context.getAllTableScans().size() + "_" + Integer.toHexString(System.identityHashCode(this))).toUpperCase(Locale.ROOT);
        TableRef tableRef = TblColRef.tableForUnknownModel((String)this.alias, (TableDesc)this.olapTable.getSourceTable());
        ArrayList<TblColRef> columns = new ArrayList<TblColRef>();
        for (ColumnDesc sourceColumn : this.olapTable.getSourceColumns()) {
            TblColRef colRef = TblColRef.columnForUnknownModel((TableRef)tableRef, (ColumnDesc)sourceColumn);
            columns.add(colRef);
        }
        if (columns.size() != this.rowType.getFieldCount()) {
            throw new IllegalStateException("RowType=" + this.rowType.getFieldCount() + ", ColumnRowType=" + columns.size());
        }
        return new ColumnRowType(columns);
    }

    public TableRef getTableRef() {
        return this.columnRowType.getColumnByIndex(0).getTableRef();
    }

    public TblColRef makeRewriteColumn(String name) {
        return this.getTableRef().makeFakeColumn(name);
    }

    public void fixColumnRowTypeWithModel(NDataModel model, Map<String, String> aliasMap) {
        String newAlias = aliasMap.get(this.alias);
        for (TblColRef col : this.columnRowType.getAllColumns()) {
            TblColRef.fixUnknownModel((NDataModel)model, (String)newAlias, (TblColRef)col);
        }
        this.backupAlias = this.alias;
        this.alias = newAlias;
    }

    public void unfixColumnRowTypeWithModel() {
        this.alias = this.backupAlias;
        this.backupAlias = null;
        for (TblColRef col : this.columnRowType.getAllColumns()) {
            TblColRef.unfixUnknownModel((TblColRef)col);
        }
    }

    @Override
    public EnumerableRel implementEnumerable(List<EnumerableRel> inputs) {
        return this;
    }

    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        String execFunction = this.context.genExecFunc(this);
        PhysType physType = PhysTypeImpl.of((JavaTypeFactory)implementor.getTypeFactory(), (RelDataType)this.getRowType(), (JavaRowFormat)JavaRowFormat.ARRAY, (boolean)false);
        MethodCallExpression exprCall = Expressions.call((Expression)this.table.getExpression(OlapTable.class), (String)execFunction, (Expression[])new Expression[]{implementor.getRootExpression(), Expressions.constant((Object)this.context.getId())});
        return implementor.result(physType, Blocks.toBlock((Node)exprCall));
    }

    public void setColumnRowType(ColumnRowType columnRowType) {
        this.columnRowType = columnRowType;
    }

    @Override
    public void implementRewrite(OlapRel.RewriteImpl rewriteImpl) {
        if (this.context != null) {
            this.context.getRewriteFields().entrySet().forEach(rewriteField -> {
                String fieldName = (String)rewriteField.getKey();
                RelDataTypeField field = this.rowType.getField(fieldName, true, false);
                if (field != null) {
                    RelDataType fieldType = field.getType();
                    rewriteField.setValue(fieldType);
                }
            });
        }
    }

    @Override
    public boolean hasSubQuery() {
        return false;
    }

    @Override
    public RelTraitSet replaceTraitSet(RelTrait trait) {
        RelTraitSet oldTraitSet = this.traitSet;
        this.traitSet = this.traitSet.replace(trait);
        return oldTraitSet;
    }

    public OlapTableScan cleanRelOptCluster() {
        OlapTableScan tableScan = new OlapTableScan(OlapTableScan.emptyCluster(), this.table, this.olapTable, this.fields);
        tableScan.getCluster().getPlanner().clear();
        tableScan.columnRowType = this.columnRowType;
        tableScan.olapTable = this.olapTable;
        tableScan.fields = this.fields;
        tableScan.tableName = this.tableName;
        tableScan.context = this.context;
        tableScan.kylinConfig = this.kylinConfig;
        tableScan.digest = this.digest;
        tableScan.alias = this.alias;
        return tableScan;
    }

    @Override
    public void implementCutContext(ICutContextStrategy.ContextCutImpl contextCutImpl) {
    }

    @Override
    public boolean pushRelInfoToContext(OlapContext context) {
        return context == this.context;
    }

    @Override
    public void implementContext(OlapRel.ContextImpl contextImpl, OlapRel.ContextVisitorState state) {
        this.contextVisited = true;
        TableDesc sourceTable = this.getOlapTable().getSourceTable();
        state.merge(OlapRel.ContextVisitorState.of(false, true, sourceTable.isIncrementLoading()));
        if (contextImpl.getFirstTableDesc() == null) {
            contextImpl.setFirstTableDesc(sourceTable);
        }
        state.setHasFirstTable(contextImpl.getFirstTableDesc().equals((Object)sourceTable));
    }

    @Generated
    public OlapTable getOlapTable() {
        return this.olapTable;
    }

    @Generated
    public String getTableName() {
        return this.tableName;
    }

    @Generated
    public int[] getFields() {
        return this.fields;
    }

    @Override
    @Generated
    public ColumnRowType getColumnRowType() {
        return this.columnRowType;
    }

    @Override
    @Generated
    public OlapContext getContext() {
        return this.context;
    }

    @Override
    @Generated
    public Set<OlapContext> getSubContexts() {
        return this.subContexts;
    }

    @Generated
    public String getAlias() {
        return this.alias;
    }

    @Generated
    public String getBackupAlias() {
        return this.backupAlias;
    }

    @Generated
    public boolean isContextVisited() {
        return this.contextVisited;
    }

    @Generated
    private KylinConfig getKylinConfig() {
        return this.kylinConfig;
    }

    @Override
    @Generated
    public void setContext(OlapContext context) {
        this.context = context;
    }

    @Override
    @Generated
    public void setSubContexts(Set<OlapContext> subContexts) {
        this.subContexts = subContexts;
    }
}

