/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.kylin.rest.controller.NBasicController;
import org.apache.kylin.rest.request.IndexGlutenCacheRequest;
import org.apache.kylin.rest.request.InternalTableGlutenCacheRequest;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.response.GlutenCacheResponse;
import org.apache.kylin.rest.service.GlutenCacheService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"}, produces={"application/vnd.apache.kylin-v4+json", "application/vnd.apache.kylin-v4-public+json"})
public class GlutenCacheController
extends NBasicController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GlutenCacheController.class);
    @Autowired
    private GlutenCacheService glutenCacheService;

    @PostMapping(value={"/cache/gluten_cache"})
    @ApiOperation(value="gluten cache", tags={"Gluten"})
    @ResponseBody
    public EnvelopeResponse<GlutenCacheResponse> glutenCache(@RequestBody List<String> cacheCommands) {
        this.checkCollectionRequiredArg("cacheCommands", cacheCommands);
        GlutenCacheResponse result = this.glutenCacheService.glutenCache(cacheCommands);
        return new EnvelopeResponse("000", (Object)result, "");
    }

    @PostMapping(value={"/cache/gluten_cache_async"})
    @ApiOperation(value="gluten cache", tags={"Gluten"})
    @ResponseBody
    public EnvelopeResponse<String> glutenCacheAsync(@RequestBody List<String> cacheCommands) {
        this.checkCollectionRequiredArg("cacheCommands", cacheCommands);
        this.glutenCacheService.glutenCacheAsync(cacheCommands);
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @PostMapping(value={"/internal_table/gluten_cache"})
    @ApiOperation(value="index gluten cache", tags={"Gluten"})
    @ResponseBody
    public EnvelopeResponse<String> internalTableGlutenCache(@RequestBody InternalTableGlutenCacheRequest request, HttpServletRequest servletRequest) throws Exception {
        log.info("Internal table gluten cache request is [{}]", (Object)request);
        String projectName = this.checkProjectName(request.getProject());
        request.setProject(projectName);
        this.checkRequiredArg("database", request.getDatabase());
        this.checkRequiredArg("table", request.getTable());
        this.glutenCacheService.internalTableGlutenCache(request, servletRequest);
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @PostMapping(value={"/index/gluten_cache"})
    @ApiOperation(value="index gluten cache", tags={"Gluten"})
    @ResponseBody
    public EnvelopeResponse<String> indexGlutenCache(@RequestBody IndexGlutenCacheRequest request, HttpServletRequest servletRequest) throws Exception {
        log.info("Index gluten cache request is [{}]", (Object)request);
        String projectName = this.checkProjectName(request.getProject());
        request.setProject(projectName);
        this.checkRequiredArg("model", request.getModel());
        this.glutenCacheService.indexGlutenCache(request, servletRequest);
        return new EnvelopeResponse("000", (Object)"", "");
    }
}

