/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache.store;

import alluxio.client.file.cache.store.PageStoreOptions;
import alluxio.client.file.cache.store.PageStoreType;
import alluxio.shaded.client.com.google.common.base.MoreObjects;

public class LocalPageStoreOptions
extends PageStoreOptions {
    private static final double LOCAL_OVERHEAD_RATIO = 0.05;
    private int mFileBuckets = 1000;

    public LocalPageStoreOptions() {
        this.mOverheadRatio = 0.05;
    }

    public LocalPageStoreOptions setFileBuckets(int fileBuckets) {
        this.mFileBuckets = fileBuckets;
        return this;
    }

    public int getFileBuckets() {
        return this.mFileBuckets;
    }

    @Override
    public PageStoreType getType() {
        return PageStoreType.LOCAL;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("AlluxioVersion", this.mAlluxioVersion).add("CacheSize", this.mCacheSize).add("FileBuckets", this.mFileBuckets).add("OverheadRatio", this.mOverheadRatio).add("PageSize", this.mPageSize).add("RootDirs", this.mRootDirs).add("TimeoutDuration", this.mTimeoutDuration).add("TimeoutThreads", this.mTimeoutThreads).toString();
    }
}

