/*
 * Decompiled with CFR 0.152.
 */
package alluxio.client.file.cache.store;

import alluxio.client.file.cache.PageId;
import alluxio.client.file.cache.PageInfo;
import alluxio.client.file.cache.PageStore;
import alluxio.client.file.cache.store.MemoryPageStoreOptions;
import alluxio.exception.PageNotFoundException;
import alluxio.exception.status.ResourceExhaustedException;
import alluxio.shaded.client.com.google.common.annotations.VisibleForTesting;
import alluxio.shaded.client.com.google.common.base.Preconditions;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class MemoryPageStore
implements PageStore {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryPageStore.class);
    private final long mPageSize;
    private final long mCapacity;
    private ConcurrentHashMap<PageId, byte[]> mPageStoreMap = null;

    public MemoryPageStore(MemoryPageStoreOptions options) {
        this.mPageSize = options.getPageSize();
        this.mCapacity = (long)((double)options.getCacheSize() / (1.0 + options.getOverheadRatio()));
        this.mPageStoreMap = new ConcurrentHashMap();
    }

    @Override
    public void put(PageId pageId, byte[] page) throws ResourceExhaustedException, IOException {
        PageId pageKey = this.getKeyFromPageId(pageId);
        try {
            byte[] mPage = new byte[page.length];
            System.arraycopy(page, 0, mPage, 0, page.length);
            this.mPageStoreMap.put(pageKey, mPage);
        }
        catch (Exception e) {
            throw new IOException("Failed to put cached data in memory for page " + pageId);
        }
    }

    @Override
    public int get(PageId pageId, int pageOffset, int bytesToRead, byte[] buffer, int bufferOffset) throws IOException, PageNotFoundException {
        Preconditions.checkArgument(buffer != null, "buffer is null");
        Preconditions.checkArgument(pageOffset >= 0, "page offset should be non-negative");
        Preconditions.checkArgument(buffer.length >= bufferOffset, "page offset %s should be less or equal than buffer length %s", bufferOffset, buffer.length);
        PageId pageKey = this.getKeyFromPageId(pageId);
        if (!this.mPageStoreMap.containsKey(pageKey)) {
            throw new PageNotFoundException(pageId.getFileId() + "_" + pageId.getPageIndex());
        }
        byte[] mPage = this.mPageStoreMap.get(pageKey);
        Preconditions.checkArgument(pageOffset <= mPage.length, "page offset %s exceeded page size %s", pageOffset, mPage.length);
        int bytesLeft = Math.min(mPage.length - pageOffset, buffer.length - bufferOffset);
        bytesLeft = Math.min(bytesLeft, bytesToRead);
        System.arraycopy(mPage, pageOffset, buffer, bufferOffset, bytesLeft);
        return bytesLeft;
    }

    @Override
    public void delete(PageId pageId) throws IOException, PageNotFoundException {
        PageId pageKey = this.getKeyFromPageId(pageId);
        if (!this.mPageStoreMap.containsKey(pageKey)) {
            throw new PageNotFoundException(pageId.getFileId() + "_" + pageId.getPageIndex());
        }
        this.mPageStoreMap.remove(pageKey);
        LOG.info("Remove cached page, size: {}", (Object)this.mPageStoreMap.size());
    }

    @VisibleForTesting
    public PageId getKeyFromPageId(PageId pageId) {
        return pageId;
    }

    @Override
    public void close() {
        this.mPageStoreMap.clear();
        this.mPageStoreMap = null;
    }

    @Override
    public Stream<PageInfo> getPages() throws IOException {
        return new ArrayList(0).stream();
    }

    @Override
    public long getCacheSize() {
        return this.mCapacity;
    }
}

