/*
 * Decompiled with CFR 0.152.
 */
package alluxio.grpc;

import alluxio.grpc.GrpcConnection;
import alluxio.security.authentication.AuthenticatedChannelClientDriver;
import alluxio.shaded.client.com.google.common.base.MoreObjects;
import alluxio.shaded.client.io.grpc.CallOptions;
import alluxio.shaded.client.io.grpc.Channel;
import alluxio.shaded.client.io.grpc.ClientCall;
import alluxio.shaded.client.io.grpc.ClientInterceptor;
import alluxio.shaded.client.io.grpc.ClientInterceptors;
import alluxio.shaded.client.io.grpc.ForwardingClientCall;
import alluxio.shaded.client.io.grpc.ForwardingClientCallListener;
import alluxio.shaded.client.io.grpc.Metadata;
import alluxio.shaded.client.io.grpc.MethodDescriptor;
import alluxio.shaded.client.io.grpc.Status;
import alluxio.shaded.client.javax.annotation.Nullable;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class GrpcChannel
extends Channel {
    private final GrpcConnection mConnection;
    private Channel mTrackedChannel;
    private ChannelResponseTracker mResponseTracker;
    private AuthenticatedChannelClientDriver mAuthDriver;
    private boolean mChannelReleased = false;

    public GrpcChannel(GrpcConnection connection, @Nullable AuthenticatedChannelClientDriver authDriver) {
        this.mConnection = connection;
        this.mAuthDriver = authDriver;
        this.mResponseTracker = new ChannelResponseTracker();
        this.mConnection.interceptChannel(this.mResponseTracker);
        this.mTrackedChannel = this.mConnection.getChannel();
    }

    @Override
    public <RequestT, ResponseT> ClientCall<RequestT, ResponseT> newCall(MethodDescriptor<RequestT, ResponseT> methodDescriptor, CallOptions callOptions) {
        return this.mTrackedChannel.newCall(methodDescriptor, callOptions);
    }

    @Override
    public String authority() {
        return this.mTrackedChannel.authority();
    }

    public void intercept(ClientInterceptor interceptor) {
        this.mTrackedChannel = ClientInterceptors.intercept(this.mTrackedChannel, interceptor);
    }

    public synchronized void shutdown() {
        if (this.mAuthDriver != null) {
            this.mAuthDriver.close();
            this.mAuthDriver = null;
        }
        if (!this.mChannelReleased) {
            try {
                this.mConnection.close();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to release the connection.", e);
            }
            this.mChannelReleased = true;
        }
    }

    public boolean isShutdown() {
        return this.mChannelReleased;
    }

    public boolean isHealthy() {
        boolean healthy = this.mResponseTracker.isChannelHealthy();
        if (this.mAuthDriver != null) {
            healthy &= this.mAuthDriver.isAuthenticated();
        }
        return healthy;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("ChannelKey", this.mConnection.getChannelKey()).add("ChannelHealthy", this.isHealthy()).add("ChannelReleased", this.mChannelReleased).toString();
    }

    public String toStringShort() {
        return this.mConnection.getChannelKey().toStringShort();
    }

    private class ChannelResponseTracker
    implements ClientInterceptor {
        private boolean mChannelHealthy = true;

        private ChannelResponseTracker() {
        }

        public boolean isChannelHealthy() {
            return this.mChannelHealthy;
        }

        @Override
        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
            return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

                @Override
                public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                    super.start(new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                        @Override
                        public void onClose(Status status, Metadata trailers) {
                            if (status == Status.UNAUTHENTICATED || status == Status.UNAVAILABLE) {
                                ChannelResponseTracker.this.mChannelHealthy = false;
                            }
                            super.onClose(status, trailers);
                        }
                    }, headers);
                }
            };
        }
    }
}

