/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.authorization;

import alluxio.security.authorization.AclAction;
import alluxio.security.authorization.Mode;
import alluxio.shaded.client.com.google.common.base.MoreObjects;
import alluxio.shaded.client.com.google.common.base.Objects;
import alluxio.shaded.client.com.google.common.collect.ImmutableSet;
import alluxio.shaded.client.javax.annotation.concurrent.NotThreadSafe;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Set;

@NotThreadSafe
public final class AclActions
implements Serializable {
    private static final long serialVersionUID = 4500558548535992938L;
    private static final int ACTIONS_BITSET_INITIAL_BITS = 3;
    private BitSet mActions;

    public AclActions() {
        this.mActions = new BitSet(3);
    }

    public AclActions(AclActions actions) {
        this.mActions = (BitSet)actions.mActions.clone();
    }

    public AclActions(Set<AclAction> actions) {
        this.mActions = new BitSet(3);
        for (AclAction action : actions) {
            this.mActions.set(action.ordinal());
        }
    }

    public Set<AclAction> getActions() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        int i = this.mActions.nextSetBit(0);
        while (i >= 0) {
            builder.add((Object)AclAction.ofOrdinal(i));
            i = this.mActions.nextSetBit(i + 1);
        }
        return builder.build();
    }

    public void updateByModeBits(Mode.Bits bits) {
        Mode.Bits[] indexedBits = new Mode.Bits[]{Mode.Bits.READ, Mode.Bits.WRITE, Mode.Bits.EXECUTE};
        for (int i = 0; i < 3; ++i) {
            if (bits.imply(indexedBits[i])) {
                this.mActions.set(i);
                continue;
            }
            this.mActions.clear(i);
        }
    }

    public void add(AclAction action) {
        this.mActions.set(action.ordinal());
    }

    public void merge(AclActions actions) {
        this.mActions.or(actions.mActions);
    }

    public void mask(AclActions actions) {
        this.mActions.and(actions.mActions);
    }

    public boolean contains(AclAction action) {
        return this.mActions.get(action.ordinal());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AclActions)) {
            return false;
        }
        AclActions that = (AclActions)o;
        return Objects.equal(this.mActions, that.mActions);
    }

    public int hashCode() {
        return Objects.hashCode(this.mActions);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("actions", this.getActions()).toString();
    }

    public String toCliString() {
        return this.toModeBits().toString();
    }

    public Mode.Bits toModeBits() {
        Mode.Bits bits = Mode.Bits.NONE;
        if (this.contains(AclAction.READ)) {
            bits = bits.or(Mode.Bits.READ);
        }
        if (this.contains(AclAction.WRITE)) {
            bits = bits.or(Mode.Bits.WRITE);
        }
        if (this.contains(AclAction.EXECUTE)) {
            bits = bits.or(Mode.Bits.EXECUTE);
        }
        return bits;
    }
}

