/*
 * Decompiled with CFR 0.152.
 */
package alluxio.shaded.client.org.apache.zookeeper.cli;

import alluxio.shaded.client.org.apache.commons.cli.CommandLine;
import alluxio.shaded.client.org.apache.commons.cli.Options;
import alluxio.shaded.client.org.apache.commons.cli.ParseException;
import alluxio.shaded.client.org.apache.commons.cli.PosixParser;
import alluxio.shaded.client.org.apache.zookeeper.KeeperException;
import alluxio.shaded.client.org.apache.zookeeper.cli.CliCommand;
import alluxio.shaded.client.org.apache.zookeeper.cli.CliException;
import alluxio.shaded.client.org.apache.zookeeper.cli.CliParseException;
import alluxio.shaded.client.org.apache.zookeeper.cli.CliWrapperException;
import alluxio.shaded.client.org.apache.zookeeper.cli.MalformedPathException;
import alluxio.shaded.client.org.apache.zookeeper.cli.StatPrinter;
import alluxio.shaded.client.org.apache.zookeeper.data.Stat;

public class StatCommand
extends CliCommand {
    private static final Options options = new Options();
    private String[] args;
    private CommandLine cl;

    public StatCommand() {
        super("stat", "[-w] path");
    }

    @Override
    public CliCommand parse(String[] cmdArgs) throws CliParseException {
        PosixParser parser = new PosixParser();
        try {
            this.cl = parser.parse(options, cmdArgs);
        }
        catch (ParseException ex) {
            throw new CliParseException(ex);
        }
        this.args = this.cl.getArgs();
        if (this.args.length < 2) {
            throw new CliParseException(this.getUsageStr());
        }
        this.retainCompatibility(cmdArgs);
        return this;
    }

    private void retainCompatibility(String[] cmdArgs) throws CliParseException {
        if (this.args.length > 2) {
            cmdArgs[2] = "-w";
            this.err.println("'stat path [watch]' has been deprecated. Please use 'stat [-w] path' instead.");
            PosixParser parser = new PosixParser();
            try {
                this.cl = parser.parse(options, cmdArgs);
            }
            catch (ParseException ex) {
                throw new CliParseException(ex);
            }
            this.args = this.cl.getArgs();
        }
    }

    @Override
    public boolean exec() throws CliException {
        Stat stat;
        String path = this.args[1];
        boolean watch = this.cl.hasOption("w");
        try {
            stat = this.zk.exists(path, watch);
        }
        catch (IllegalArgumentException ex) {
            throw new MalformedPathException(ex.getMessage());
        }
        catch (KeeperException | InterruptedException ex) {
            throw new CliWrapperException(ex);
        }
        if (stat == null) {
            throw new CliWrapperException(new KeeperException.NoNodeException(path));
        }
        new StatPrinter(this.out).print(stat);
        return watch;
    }

    static {
        options.addOption("w", false, "watch");
    }
}

