/*
 * Decompiled with CFR 0.152.
 */
package jodd.inex;

import java.util.ArrayList;
import java.util.List;
import jodd.inex.InExRuleMatcher;

@Deprecated
public class InExRules<V, D, R>
implements InExRuleMatcher<V, R> {
    protected List<Rule<R>> rules;
    protected final InExRuleMatcher<V, R> inExRuleMatcher;
    protected int includesCount;
    protected int excludesCount;
    protected boolean blacklist = true;

    public InExRules<String, String, String> create() {
        return new InExRules<String, String, String>();
    }

    public InExRules() {
        this.inExRuleMatcher = this;
    }

    public InExRules(InExRuleMatcher<V, R> inExRuleMatcher) {
        this.inExRuleMatcher = inExRuleMatcher;
    }

    public int totalRules() {
        if (this.rules == null) {
            return 0;
        }
        return this.rules.size();
    }

    public int totalIncludeRules() {
        return this.includesCount;
    }

    public int totalExcludeRules() {
        return this.excludesCount;
    }

    public boolean hasRules() {
        if (this.rules == null) {
            return false;
        }
        return !this.rules.isEmpty();
    }

    public R getRule(int index) {
        return this.rules.get((int)index).value;
    }

    public void reset() {
        if (this.rules != null) {
            this.rules.clear();
        }
        this.excludesCount = 0;
        this.includesCount = 0;
        this.blacklist = true;
    }

    public void blacklist() {
        this.blacklist = true;
    }

    public boolean isBlacklist() {
        return this.blacklist;
    }

    public void whitelist() {
        this.blacklist = false;
    }

    public boolean isWhitelist() {
        return !this.blacklist;
    }

    public void detectMode() {
        if (this.excludesCount == 0 && this.includesCount > 0) {
            this.whitelist();
        } else if (this.excludesCount > 0 && this.includesCount == 0) {
            this.blacklist();
        }
    }

    public void include(D rule) {
        this.addRule(rule, true);
    }

    public void exclude(D rule) {
        this.addRule(rule, false);
    }

    protected void addRule(D ruleDefinition, boolean include) {
        if (this.rules == null) {
            this.rules = new ArrayList<Rule<R>>();
        }
        if (include) {
            ++this.includesCount;
        } else {
            ++this.excludesCount;
        }
        Rule<R> newRule = new Rule<R>(this.makeRule(ruleDefinition), include);
        if (this.rules.contains(newRule)) {
            return;
        }
        this.rules.add(newRule);
    }

    protected R makeRule(D rule) {
        return (R)rule;
    }

    public boolean match(V value) {
        return this.match(value, this.blacklist);
    }

    public boolean match(V value, boolean blacklist) {
        if (this.rules == null) {
            return blacklist;
        }
        boolean include = blacklist;
        if (include) {
            include = this.processExcludes(value, true);
            include = this.processIncludes(value, include);
        } else {
            include = this.processIncludes(value, false);
            include = this.processExcludes(value, include);
        }
        return include;
    }

    public boolean apply(V value, boolean flag) {
        return this.apply(value, this.blacklist, flag);
    }

    public boolean apply(V value, boolean blacklist, boolean flag) {
        if (this.rules == null) {
            return flag;
        }
        if (blacklist) {
            flag = this.processExcludes(value, flag);
            flag = this.processIncludes(value, flag);
        } else {
            flag = this.processIncludes(value, flag);
            flag = this.processExcludes(value, flag);
        }
        return flag;
    }

    protected boolean processIncludes(V value, boolean include) {
        if (this.includesCount > 0 && !include) {
            for (Rule<R> rule : this.rules) {
                if (!rule.include || !this.inExRuleMatcher.accept(value, rule.value, true)) continue;
                include = true;
                break;
            }
        }
        return include;
    }

    protected boolean processExcludes(V value, boolean include) {
        if (this.excludesCount > 0 && include) {
            for (Rule<R> rule : this.rules) {
                if (rule.include || !this.inExRuleMatcher.accept(value, rule.value, false)) continue;
                include = false;
                break;
            }
        }
        return include;
    }

    @Override
    public boolean accept(V value, R rule, boolean include) {
        return value.equals(rule);
    }

    public static class Rule<R> {
        public final R value;
        public final boolean include;

        public Rule(R value, boolean include) {
            this.value = value;
            this.include = include;
        }

        public String toString() {
            return (this.include ? "+" : "-") + this.value.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Rule rule = (Rule)o;
            if (this.include != rule.include) {
                return false;
            }
            return this.value.equals(rule.value);
        }

        public int hashCode() {
            int result = this.value.hashCode();
            result = 31 * result + (this.include ? 1 : 0);
            return result;
        }
    }
}

