/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.engine.spark.job.StepEnum;
import org.apache.kylin.job.execution.DefaultExecutable;
import org.apache.kylin.job.execution.DefaultExecutableOnTable;
import org.apache.kylin.job.factory.JobFactory;
import org.apache.kylin.job.handler.InternalTableJobHandler;
import org.apache.kylin.metadata.project.EnhancedUnitOfWork;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.table.InternalTableDesc;
import org.apache.kylin.metadata.table.InternalTableManager;
import org.apache.kylin.metadata.table.InternalTablePartition;
import org.apache.kylin.util.DataRangeUtils;
import org.sparkproject.guava.base.Preconditions;

public class InternalTableLoadingJob
extends DefaultExecutableOnTable {
    public InternalTableLoadingJob() {
    }

    public InternalTableLoadingJob(Object notSetId) {
        super(notSetId);
    }

    public static InternalTableLoadingJob create(InternalTableJobHandler.InternalTableJobBuildParam param) {
        KylinConfig projectConfig = NProjectManager.getProjectConfig((String)param.getProject());
        InternalTableManager tableManager = InternalTableManager.getInstance((KylinConfig)projectConfig, (String)param.getProject());
        InternalTableDesc internalTable = tableManager.getInternalTableDesc(param.getTable());
        Preconditions.checkArgument((param.getSubmitter() != null ? 1 : 0) != 0);
        InternalTableLoadingJob job = new InternalTableLoadingJob();
        job.setSubmitter(param.getSubmitter());
        job.setName(param.getJobType().toString());
        job.setJobType(param.getJobType());
        job.setId(param.getJobId());
        job.setTargetSubject(internalTable.getIdentity());
        job.setProject(internalTable.getProject());
        job.setParam("project", internalTable.getProject());
        job.setParam("jobId", param.getJobId());
        job.setParam("table", internalTable.getIdentity());
        job.setParam("incrementalBuild", param.getIncrementalBuild());
        job.setParam("outputMode", param.getIsRefresh());
        job.setParam("startTime", param.getStartDate());
        job.setParam("endTime", param.getEndDate());
        job.setParam("deletePartitionValues", param.getDeletePartitionValues());
        job.setParam("deletePartition", param.getDeletePartition());
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        StepEnum.BUILD_INTERNAL.create((DefaultExecutable)job, config);
        StepEnum.UPDATE_METADATA.create((DefaultExecutable)job, config);
        if (InternalTableLoadingJob.isPreloadedCacheEnable(internalTable, projectConfig)) {
            StepEnum.LOAD_GLUTEN_CACHE.create((DefaultExecutable)job, config);
        }
        return job;
    }

    private static boolean isPreloadedCacheEnable(InternalTableDesc internalTable, KylinConfig projectConfig) {
        if (internalTable.isPreloadedCacheEnable()) {
            return true;
        }
        return projectConfig.isInternalTablePreloadCacheEnabled();
    }

    public void cancelJob() {
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            InternalTableManager internalTableManager = InternalTableManager.getInstance((KylinConfig)this.getConfig(), (String)this.getProject());
            InternalTableDesc internalTable = internalTableManager.getInternalTableDesc(this.getTableIdentity());
            if (null == internalTable) {
                logger.debug("internalTable is null, maybe internalTable is deleted ?");
                return true;
            }
            String tableName = this.getParam("table");
            String startDate = this.getParam("startTime");
            String endDate = this.getParam("endTime");
            InternalTablePartition tablePartition = internalTable.getTablePartition();
            String[] curJobRange = new String[]{"0", "0"};
            if (null != tablePartition && StringUtils.isNotEmpty((CharSequence)tablePartition.getDatePartitionFormat()) && StringUtils.isNotEmpty((CharSequence)startDate)) {
                SimpleDateFormat fmt = new SimpleDateFormat(tablePartition.getDatePartitionFormat(), Locale.ROOT);
                curJobRange = new String[]{fmt.format(Long.parseLong(startDate)), fmt.format(Long.parseLong(endDate))};
            }
            logger.info("starting merging delta partitions for internal table {}", (Object)tableName);
            if (null != tablePartition && StringUtils.isNotEmpty((CharSequence)tablePartition.getDatePartitionFormat())) {
                List partitionRange = DataRangeUtils.mergeTimeRange((List)tablePartition.getPartitionValues(), (String)tablePartition.getDatePartitionFormat());
                internalTable.setPartitionRange(partitionRange);
            }
            List jobRange = internalTable.getJobRange();
            String[] finalCurJobRange = curJobRange;
            jobRange.removeIf(rang -> rang[0].equals(finalCurJobRange[0]) && rang[1].equals(finalCurJobRange[1]));
            internalTable.setJobRange(jobRange);
            internalTableManager.saveOrUpdateInternalTable(internalTable);
            logger.info("release job_range for internal table {} , range {}.", (Object)tableName, (Object)jobRange);
            return true;
        }, (String)this.getProject());
    }

    static {
        JobFactory.register((String)"INTERNAL_TABLE_JOB_FACTORY", (JobFactory)new InternalTableJobFactory());
    }

    public static class InternalTableJobFactory
    extends JobFactory {
        protected InternalTableJobFactory() {
        }

        protected InternalTableLoadingJob create(JobFactory.JobBuildParams jobBuildParams) {
            return InternalTableLoadingJob.create((InternalTableJobHandler.InternalTableJobBuildParam)jobBuildParams);
        }
    }
}

