/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.insert.render;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class FieldAndValueAndParameters {
    private final String fieldName;
    private final String valuePhrase;
    private final Map<String, Object> parameters;

    private FieldAndValueAndParameters(Builder builder) {
        this.fieldName = Objects.requireNonNull(builder.fieldName);
        this.valuePhrase = Objects.requireNonNull(builder.valuePhrase);
        this.parameters = builder.parameters;
    }

    public String fieldName() {
        return this.fieldName;
    }

    public String valuePhrase() {
        return this.valuePhrase;
    }

    public Map<String, Object> parameters() {
        return this.parameters;
    }

    public static Builder withFieldName(String fieldName) {
        return new Builder().withFieldName(fieldName);
    }

    public static class Builder {
        private String fieldName;
        private String valuePhrase;
        private final Map<String, Object> parameters = new HashMap<String, Object>();

        public Builder withFieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public Builder withValuePhrase(String valuePhrase) {
            this.valuePhrase = valuePhrase;
            return this;
        }

        public Builder withParameter(String key, Object value) {
            this.parameters.put(key, value);
            return this;
        }

        public FieldAndValueAndParameters build() {
            return new FieldAndValueAndParameters(this);
        }

        public Optional<FieldAndValueAndParameters> buildOptional() {
            return Optional.of(this.build());
        }
    }
}

