/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.realization;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.ParameterDesc;
import org.apache.kylin.metadata.model.TblColRef;

public class SQLDigest {
    private final String factTable;
    private Set<TblColRef> allColumns;
    private final List<JoinDesc> joinDescs;
    private List<TblColRef> groupByColumns;
    private final Set<TblColRef> subqueryJoinParticipants;
    private final Set<TblColRef> metricColumns;
    private List<FunctionDesc> aggregations;
    private final Set<TblColRef> filterColumns;
    private final List<TblColRef> sortColumns;
    private final List<OrderEnum> sortOrders;
    public boolean isRawQuery;
    private int limit = Integer.MAX_VALUE;
    private final boolean limitPrecedesAggr;

    public SQLDigest(String factTable, Set<TblColRef> allColumns, List<JoinDesc> joinDescs, List<TblColRef> groupByColumns, Set<TblColRef> subqueryJoinParticipants, Set<TblColRef> metricColumns, List<FunctionDesc> aggregations, Set<TblColRef> filterColumns, List<TblColRef> sortColumns, List<OrderEnum> sortOrders, int limit, boolean limitPrecedesAggr) {
        this.factTable = factTable;
        this.allColumns = allColumns;
        this.joinDescs = joinDescs;
        this.groupByColumns = groupByColumns;
        this.subqueryJoinParticipants = subqueryJoinParticipants;
        this.metricColumns = metricColumns;
        this.aggregations = aggregations;
        this.filterColumns = filterColumns;
        this.sortColumns = sortColumns;
        this.sortOrders = sortOrders;
        this.isRawQuery = this.isDigestOfRawQuery();
        this.limit = limit;
        this.limitPrecedesAggr = limitPrecedesAggr;
        this.includeSubqueryJoinParticipants();
        this.allColumns = Collections.unmodifiableSet(allColumns);
    }

    public boolean isDigestOfRawQuery() {
        return this.groupByColumns.isEmpty() && this.aggregations.isEmpty();
    }

    public void includeSubqueryJoinParticipants() {
        if (this.isRawQuery) {
            this.allColumns.addAll(this.subqueryJoinParticipants);
        } else {
            this.groupByColumns.addAll(this.subqueryJoinParticipants);
            this.allColumns.addAll(this.subqueryJoinParticipants);
        }
    }

    public String toString() {
        return "fact table " + this.factTable + ",group by " + this.groupByColumns + ",filter on " + this.filterColumns + ",with aggregates" + this.aggregations + ".";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SQLDigest)) {
            return false;
        }
        SQLDigest sqlDigest = (SQLDigest)o;
        return this.isDigestOfRawQuery() == sqlDigest.isDigestOfRawQuery() && this.limit == sqlDigest.limit && this.limitPrecedesAggr == sqlDigest.limitPrecedesAggr && this.factTable.equals(sqlDigest.factTable) && SQLDigest.equalsIgnoreOrder(this.allColumns, sqlDigest.allColumns) && SQLDigest.equalsIgnoreOrder(this.joinDescs, sqlDigest.joinDescs) && SQLDigest.equalsIgnoreOrder(this.groupByColumns, sqlDigest.groupByColumns) && this.subqueryJoinParticipants.equals(sqlDigest.subqueryJoinParticipants) && SQLDigest.equalsIgnoreOrder(this.metricColumns, sqlDigest.metricColumns) && SQLDigest.equalsIgnoreOrder(this.aggregations, sqlDigest.aggregations) && SQLDigest.equalsIgnoreOrder(this.filterColumns, sqlDigest.filterColumns) && SQLDigest.equalsIgnoreOrder(this.sortColumns, sqlDigest.sortColumns) && this.sortOrders.equals(sqlDigest.sortOrders);
    }

    private static boolean equalsIgnoreOrder(Collection c1, Collection c2) {
        if (c1 == c2) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        if (c1.size() != c2.size()) {
            return false;
        }
        for (Object o1 : c1) {
            boolean findO1OnC2 = false;
            for (Object o2 : c2) {
                if (!SQLDigest.objectEquals(o1, o2)) continue;
                findO1OnC2 = true;
                break;
            }
            if (findO1OnC2) continue;
            return false;
        }
        for (Object o2 : c2) {
            boolean findO2OnC1 = false;
            for (Object o1 : c1) {
                if (!SQLDigest.objectEquals(o2, o1)) continue;
                findO2OnC1 = true;
                break;
            }
            if (findO2OnC1) continue;
            return false;
        }
        return true;
    }

    private static boolean equalsConsiderOrder(Collection l1, Collection l2) {
        if (l1 == l2) {
            return true;
        }
        if (l1 == null || l2 == null) {
            return false;
        }
        if (l1.size() != l2.size()) {
            return false;
        }
        Iterator e1 = l1.iterator();
        Iterator e2 = l1.iterator();
        while (e1.hasNext() && e2.hasNext()) {
            Object o1 = e1.next();
            Object o2 = e2.next();
            if (o1 != null ? SQLDigest.objectEquals(o1, o2) : o2 == null) continue;
            return false;
        }
        return !e1.hasNext() && !e2.hasNext();
    }

    private static boolean objectEquals(Object o1, Object o2) {
        if (o1 instanceof TblColRef && o2 instanceof TblColRef) {
            return SQLDigest.equals((TblColRef)o1, (TblColRef)o2);
        }
        if (o1 instanceof ParameterDesc && o2 instanceof ParameterDesc) {
            return SQLDigest.equals((ParameterDesc)o1, (ParameterDesc)o2);
        }
        if (o1 instanceof FunctionDesc && o2 instanceof FunctionDesc) {
            return SQLDigest.equals((FunctionDesc)o1, (FunctionDesc)o2);
        }
        if (o1 instanceof JoinDesc && o2 instanceof JoinDesc) {
            return SQLDigest.equals((JoinDesc)o1, (JoinDesc)o2);
        }
        return false;
    }

    private static boolean equals(JoinDesc j1, JoinDesc j2) {
        if (j1 == j2) {
            return true;
        }
        if (j1 == null || j2 == null) {
            return false;
        }
        if (!Arrays.equals(j1.getForeignKey(), j2.getForeignKey())) {
            return false;
        }
        if (!Arrays.equals(j1.getPrimaryKey(), j2.getPrimaryKey())) {
            return false;
        }
        if (!SQLDigest.equalsConsiderOrder(Lists.newArrayList((Object[])j1.getForeignKeyColumns()), Lists.newArrayList((Object[])j2.getForeignKeyColumns()))) {
            return false;
        }
        if (!SQLDigest.equalsConsiderOrder(Lists.newArrayList((Object[])j1.getPrimaryKeyColumns()), Lists.newArrayList((Object[])j2.getPrimaryKeyColumns()))) {
            return false;
        }
        return j1.getType().equalsIgnoreCase(j2.getType());
    }

    private static boolean equals(FunctionDesc f1, FunctionDesc f2) {
        if (f1 == f2) {
            return true;
        }
        if (f1 == null || f2 == null) {
            return false;
        }
        if (!Objects.equals(f1.getExpression(), f2.getExpression())) {
            return false;
        }
        if (f1.isCountDistinct()) {
            if (CollectionUtils.isEmpty(f1.getParameters())) {
                return !CollectionUtils.isNotEmpty(f2.getParameters());
            }
            return SQLDigest.equalsIgnoreOrder(f1.getParameters(), f2.getParameters());
        }
        if (f1.isCountConstant() && f2.isCountConstant()) {
            return true;
        }
        if (CollectionUtils.isEmpty(f1.getParameters())) {
            return !CollectionUtils.isNotEmpty(f2.getParameters());
        }
        return SQLDigest.equalsConsiderOrder(f1.getParameters(), f2.getParameters());
    }

    private static boolean equals(ParameterDesc p1, ParameterDesc p2) {
        if (p1 == p2) {
            return true;
        }
        if (p1 == null || p2 == null) {
            return false;
        }
        if (p1.getType() != null ? !p1.getType().equals(p2.getType()) : p2.getType() != null) {
            return false;
        }
        if (p1.isColumnType() != p2.isColumnType()) {
            return false;
        }
        if (p1.isColumnType() && !SQLDigest.equals(p2.getColRef(), p1.getColRef())) {
            return false;
        }
        return p1.isColumnType() || p1.getValue().equals(p2.getValue());
    }

    private static boolean equals(TblColRef t1, TblColRef t2) {
        if (t1 == t2) {
            return true;
        }
        if (t1 == null || t2 == null) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)t1.getColumnDesc().getTable().getIdentity(), (CharSequence)t2.getColumnDesc().getTable().getIdentity())) {
            return false;
        }
        if (!StringUtils.equals((CharSequence)t1.getColumnDesc().getName(), (CharSequence)t2.getColumnDesc().getName())) {
            return false;
        }
        if (!(t1.getTableRef() != null ? t1.getTableRef().equals(t2.getTableRef()) : t2.getTableRef() == null)) {
            return false;
        }
        return t1.isInnerColumn() == t2.isInnerColumn();
    }

    public boolean equalsWithoutAlias(SQLDigest other) {
        if (this.equals(other)) {
            return true;
        }
        return this.toStringWithoutAlias().equals(other.toStringWithoutAlias());
    }

    public String toStringWithoutAlias() {
        List newGroupByColumns = this.groupByColumns.stream().map(TblColRef::getColumnWithTableAndSchema).collect(Collectors.toList());
        List newFilterColumns = this.filterColumns.stream().map(TblColRef::getColumnWithTableAndSchema).collect(Collectors.toList());
        List newAggregations = this.aggregations.stream().map(FunctionDesc::toStringWithoutAlias).collect(Collectors.toList());
        return "fact table " + this.factTable + ",group by " + newGroupByColumns + ",filter on " + newFilterColumns + ",with aggregates" + newAggregations + ".";
    }

    public int hashCode() {
        return Objects.hash(this.factTable, this.allColumns, this.joinDescs, this.groupByColumns, this.subqueryJoinParticipants, this.metricColumns, this.aggregations, this.filterColumns, this.sortColumns, this.sortOrders, this.isDigestOfRawQuery(), this.limit, this.limitPrecedesAggr);
    }

    @Generated
    public String getFactTable() {
        return this.factTable;
    }

    @Generated
    public Set<TblColRef> getAllColumns() {
        return this.allColumns;
    }

    @Generated
    public List<JoinDesc> getJoinDescs() {
        return this.joinDescs;
    }

    @Generated
    public List<TblColRef> getGroupByColumns() {
        return this.groupByColumns;
    }

    @Generated
    public Set<TblColRef> getSubqueryJoinParticipants() {
        return this.subqueryJoinParticipants;
    }

    @Generated
    public Set<TblColRef> getMetricColumns() {
        return this.metricColumns;
    }

    @Generated
    public List<FunctionDesc> getAggregations() {
        return this.aggregations;
    }

    @Generated
    public Set<TblColRef> getFilterColumns() {
        return this.filterColumns;
    }

    @Generated
    public List<TblColRef> getSortColumns() {
        return this.sortColumns;
    }

    @Generated
    public List<OrderEnum> getSortOrders() {
        return this.sortOrders;
    }

    @Generated
    public boolean isRawQuery() {
        return this.isRawQuery;
    }

    @Generated
    public int getLimit() {
        return this.limit;
    }

    @Generated
    public boolean isLimitPrecedesAggr() {
        return this.limitPrecedesAggr;
    }

    @Generated
    public void setGroupByColumns(List<TblColRef> groupByColumns) {
        this.groupByColumns = groupByColumns;
    }

    @Generated
    public void setAggregations(List<FunctionDesc> aggregations) {
        this.aggregations = aggregations;
    }

    public static enum OrderEnum {
        ASCENDING,
        DESCENDING;

    }
}

