/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.streaming;

import java.sql.SQLException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.Singletons;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.persistence.transaction.UnitOfWork;
import org.apache.kylin.metadata.streaming.ConsumptionRateStats;
import org.apache.kylin.metadata.streaming.JdbcStreamingJobStatsStore;
import org.apache.kylin.metadata.streaming.RowCountDetailByTime;
import org.apache.kylin.metadata.streaming.StreamingJobStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingJobStatsManager {
    private static final Logger logger = LoggerFactory.getLogger(StreamingJobStatsManager.class);
    private String sJSMetricMeasurement;
    private JdbcStreamingJobStatsStore jdbcSJSStore;

    public static StreamingJobStatsManager getInstance() {
        return (StreamingJobStatsManager)Singletons.getInstance(StreamingJobStatsManager.class);
    }

    public StreamingJobStatsManager() throws Exception {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        if (!UnitOfWork.isAlreadyInTransaction()) {
            logger.info("Initializing StreamingJobStatsManager with KylinConfig Id: {} ", (Object)System.identityHashCode(config));
        }
        String metadataIdentifier = StorageURL.replaceUrl((StorageURL)config.getMetadataUrl());
        this.sJSMetricMeasurement = metadataIdentifier + "_" + "streaming_job_stats";
        this.jdbcSJSStore = new JdbcStreamingJobStatsStore(config);
    }

    public int insert(StreamingJobStats stats) {
        return this.jdbcSJSStore.insert(stats);
    }

    public void insert(List<StreamingJobStats> statsList) {
        this.jdbcSJSStore.insert(statsList);
    }

    public void dropTable() throws SQLException {
        this.jdbcSJSStore.dropTable();
    }

    public void deleteAllStreamingJobStats() {
        this.jdbcSJSStore.deleteStreamingJobStats(-1L);
    }

    public void deleteSJSIfRetainTimeReached() {
        long retainTime = StreamingJobStatsManager.getRetainTime();
        this.jdbcSJSStore.deleteStreamingJobStats(retainTime);
    }

    public static long getRetainTime() {
        return new Date(System.currentTimeMillis() - KylinConfig.getInstanceFromEnv().getStreamingJobStatsSurvivalThreshold() * 24L * 60L * 60L * 1000L).getTime();
    }

    public List<RowCountDetailByTime> queryRowCountDetailByTime(long startTime, String jobId) {
        return this.jdbcSJSStore.queryRowCountDetailByTime(startTime, jobId);
    }

    public ConsumptionRateStats countAvgConsumptionRate(long startTime, String jobId) {
        return this.jdbcSJSStore.queryAvgConsumptionRate(startTime, jobId);
    }

    public List<StreamingJobStats> queryStreamingJobStats(long startTime, String jobId) {
        return this.jdbcSJSStore.queryByJobId(startTime, jobId);
    }

    public StreamingJobStats getLatestOneByJobId(String jobId) {
        return this.jdbcSJSStore.getLatestOneByJobId(jobId);
    }

    public Map<String, Long> queryDataLatenciesByJobIds(List<String> jobIds) {
        if (jobIds.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.jdbcSJSStore.queryDataLatenciesByJobIds(jobIds);
    }

    @Generated
    public void setSJSMetricMeasurement(String sJSMetricMeasurement) {
        this.sJSMetricMeasurement = sJSMetricMeasurement;
    }

    @Generated
    public String getSJSMetricMeasurement() {
        return this.sJSMetricMeasurement;
    }
}

