/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.security;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.rest.security.AceImpl;
import org.apache.kylin.rest.security.LegacyAceInfo;
import org.apache.kylin.rest.security.MutableAclRecord;
import org.apache.kylin.rest.security.ObjectIdentityImpl;
import org.apache.kylin.rest.security.SidInfo;
import org.springframework.security.acls.domain.GrantedAuthoritySid;
import org.springframework.security.acls.domain.PermissionFactory;
import org.springframework.security.acls.domain.PrincipalSid;
import org.springframework.security.acls.model.AccessControlEntry;
import org.springframework.security.acls.model.Acl;
import org.springframework.security.acls.model.NotFoundException;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.acls.model.OwnershipAcl;
import org.springframework.security.acls.model.Permission;
import org.springframework.security.acls.model.PermissionGrantingStrategy;
import org.springframework.security.acls.model.Sid;
import org.springframework.security.acls.model.UnloadedSidException;
import org.springframework.util.Assert;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class AclRecord
extends RootPersistentEntity
implements Acl,
OwnershipAcl {
    PermissionFactory aclPermissionFactory;
    @JsonProperty(value="domainObjectInfo")
    private ObjectIdentityImpl domainObjectInfo;
    @JsonProperty(value="parentDomainObjectInfo")
    private ObjectIdentityImpl parentDomainObjectInfo;
    @JsonProperty(value="ownerInfo")
    private SidInfo ownerInfo;
    @JsonProperty(value="entriesInheriting")
    private boolean entriesInheriting;
    @JsonProperty(value="entries")
    private List<AceImpl> entries;
    @JsonProperty(value="allAceInfo")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Map<String, LegacyAceInfo> legacyAceInfo;
    private PermissionGrantingStrategy permissionGrantingStrategy;
    private Acl parentAcl;

    public AclRecord() {
    }

    public AclRecord(ObjectIdentity oid, Sid owner) {
        this.domainObjectInfo = new ObjectIdentityImpl(oid);
        this.ownerInfo = new SidInfo(owner);
    }

    public void init(Acl parentAcl, PermissionFactory aclPermissionFactory, PermissionGrantingStrategy permissionGrantingStrategy) {
        this.aclPermissionFactory = aclPermissionFactory;
        this.permissionGrantingStrategy = permissionGrantingStrategy;
        this.parentAcl = parentAcl;
        if (this.entries == null) {
            this.entries = new ArrayList<AceImpl>();
        }
        if (this.legacyAceInfo != null) {
            for (LegacyAceInfo legacy : this.legacyAceInfo.values()) {
                this.entries.add(new AceImpl(legacy));
            }
            this.legacyAceInfo = null;
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            this.entries.get(i).init(this, i);
        }
        this.entries.sort(AceImpl.SID_ORDER);
    }

    public String resourceName() {
        return String.valueOf(this.domainObjectInfo.getIdentifier());
    }

    public MetadataType resourceType() {
        return MetadataType.ACL;
    }

    public SidInfo getOwnerInfo() {
        return this.ownerInfo;
    }

    public void setOwnerInfo(SidInfo ownerInfo) {
        this.ownerInfo = ownerInfo;
    }

    public boolean isEntriesInheriting() {
        return this.entriesInheriting;
    }

    public void setEntriesInheriting(boolean entriesInheriting) {
        this.entriesInheriting = entriesInheriting;
    }

    public final ObjectIdentityImpl getDomainObjectInfo() {
        return this.domainObjectInfo;
    }

    public void setDomainObjectInfo(ObjectIdentityImpl domainObjectInfo) {
        this.domainObjectInfo = domainObjectInfo;
    }

    public ObjectIdentityImpl getParentDomainObjectInfo() {
        return this.parentDomainObjectInfo;
    }

    public void setParentDomainObjectInfo(ObjectIdentityImpl parentDomainObjectInfo) {
        this.parentDomainObjectInfo = parentDomainObjectInfo;
    }

    public Map<String, LegacyAceInfo> getAllAceInfo() {
        return this.legacyAceInfo;
    }

    public void setAllAceInfo(Map<String, LegacyAceInfo> allAceInfo) {
        this.legacyAceInfo = allAceInfo;
    }

    public ObjectIdentity getObjectIdentity() {
        return this.getDomainObjectInfo();
    }

    public Sid getOwner() {
        return this.ownerInfo.getSidObj();
    }

    public void setOwner(Sid newOwner) {
        this.ownerInfo = new SidInfo(newOwner);
    }

    public Acl getParentAcl() {
        return this.parentAcl;
    }

    public void setParent(Acl newParent) {
        AclRecord newP = newParent instanceof MutableAclRecord ? ((MutableAclRecord)newParent).getAclRecord() : (AclRecord)newParent;
        this.parentDomainObjectInfo = newP.domainObjectInfo;
        this.parentAcl = newP;
    }

    public List<AccessControlEntry> getEntries() {
        return Collections.unmodifiableList(this.entries);
    }

    public AccessControlEntry getAccessControlEntryAt(int entryIndex) {
        return this.entries.get(entryIndex);
    }

    public Sid getAceBySidAndPrincipal(String name, boolean principal) {
        List sids = this.entries.stream().map(AceImpl::getSid).collect(Collectors.toList());
        for (Sid sid : sids) {
            if (principal && sid instanceof PrincipalSid && name.equalsIgnoreCase(((PrincipalSid)sid).getPrincipal())) {
                return sid;
            }
            if (principal || !(sid instanceof GrantedAuthoritySid) || !Objects.equals(name, ((GrantedAuthoritySid)sid).getGrantedAuthority())) continue;
            return sid;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Permission getPermission(Sid sid) {
        List<AceImpl> list = this.entries;
        synchronized (list) {
            int p = Collections.binarySearch(this.entries, new AceImpl(sid, null), AceImpl.SID_ORDER);
            if (p >= 0) {
                return this.entries.get(p).getPermission();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upsertAce(Permission permission, Sid sid) {
        Assert.notNull((Object)sid, (String)"Sid required");
        AceImpl ace = new AceImpl(sid, permission);
        List<AceImpl> list = this.entries;
        synchronized (list) {
            int p = Collections.binarySearch(this.entries, ace, AceImpl.SID_ORDER);
            if (p >= 0) {
                if (permission == null) {
                    this.entries.remove(p);
                } else {
                    this.entries.get(p).setPermission(permission);
                }
            } else if (permission != null) {
                ace.init(this, this.entries.size());
                this.entries.add(-p - 1, ace);
            }
        }
    }

    public void deleteAce(Sid sid) {
        this.upsertAce(null, sid);
    }

    public void insertAce(int atIndexLocation, Permission permission, Sid sid, boolean granting) throws NotFoundException {
        Assert.state((boolean)granting, (String)"Granting must be true");
        this.upsertAce(permission, sid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAce(int aceIndex, Permission permission) throws NotFoundException {
        this.verifyAceIndexExists(aceIndex);
        List<AceImpl> list = this.entries;
        synchronized (list) {
            AceImpl ace = this.entries.get(aceIndex);
            ace.setPermission(permission);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAce(int aceIndex) throws NotFoundException {
        this.verifyAceIndexExists(aceIndex);
        List<AceImpl> list = this.entries;
        synchronized (list) {
            this.entries.remove(aceIndex);
        }
    }

    private void verifyAceIndexExists(int aceIndex) {
        if (aceIndex < 0) {
            throw new NotFoundException("aceIndex must be greater than or equal to zero");
        }
        if (aceIndex >= this.entries.size()) {
            throw new NotFoundException("aceIndex must refer to an index of the AccessControlEntry list. List size is " + this.entries.size() + ", index was " + aceIndex);
        }
    }

    public boolean isGranted(List<Permission> permission, List<Sid> sids, boolean administrativeMode) throws NotFoundException, UnloadedSidException {
        Assert.notEmpty(sids, (String)"SIDs required");
        Assert.notEmpty(permission, (String)"Permissions required");
        return this.permissionGrantingStrategy.isGranted((Acl)this, permission, sids, administrativeMode);
    }

    public boolean isSidLoaded(List<Sid> sids) {
        return true;
    }
}

