/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.pushdown;

import java.util.List;
import org.apache.kylin.common.Singletons;
import org.apache.kylin.common.persistence.transaction.UnitOfWork;
import org.apache.kylin.common.util.ClassLoaderUtils;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.metadata.query.StructField;
import org.apache.kylin.query.pushdown.PushdownResponse;
import org.apache.kylin.query.pushdown.SparkSqlClient;
import org.apache.spark.sql.SparderEnv;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple3;

public class SparkSubmitter {
    public static final Logger logger = LoggerFactory.getLogger(SparkSubmitter.class);
    private OverriddenSparkSession overriddenSparkSession;

    public static SparkSubmitter getInstance() {
        return (SparkSubmitter)Singletons.getInstance(SparkSubmitter.class);
    }

    public OverriddenSparkSession overrideSparkSession(SparkSession ss) {
        this.overriddenSparkSession = new OverriddenSparkSession(ss);
        return this.overriddenSparkSession;
    }

    public void clearOverride() {
        this.overriddenSparkSession = null;
    }

    private SparkSession getSparkSession() {
        return this.overriddenSparkSession != null ? this.overriddenSparkSession.ss : SparderEnv.getSparkSession();
    }

    public PushdownResponse submitPushDownTask(String sql, String project) {
        if (UnitOfWork.isAlreadyInTransaction()) {
            logger.warn("execute spark job with transaction lock");
        }
        Thread.currentThread().setContextClassLoader(ClassLoaderUtils.getSparkClassLoader());
        SparkSession ss = this.getSparkSession();
        Tuple3<Iterable<List<String>>, Object, List<StructField>> results = SparkSqlClient.executeSqlToIterable(ss, sql, RandomUtil.randomUUID(), project);
        return new PushdownResponse((List)results._3(), (Iterable)results._1(), (Integer)results._2());
    }

    public class OverriddenSparkSession
    implements AutoCloseable {
        private SparkSession ss;

        public OverriddenSparkSession(SparkSession ss) {
            this.ss = ss;
        }

        @Override
        public void close() throws Exception {
            SparkSubmitter.this.clearOverride();
        }
    }
}

