/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.queue.CircularFifoQueue;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.Singletons;
import org.apache.kylin.query.util.LoadDesc;
import org.apache.spark.sql.SparderEnv;
import org.apache.spark.status.api.v1.ExecutorSummary;
import org.apache.spark.status.api.v1.StageData;
import org.apache.spark.status.api.v1.StageStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class LoadCounter {
    private static final long PERIOD_SECONDS = KylinConfig.getInstanceFromEnv().getLoadCounterPeriodSeconds();
    private static final Logger logger = LoggerFactory.getLogger(LoadCounter.class);
    private CircularFifoQueue<Integer> pendingQueue = new CircularFifoQueue(KylinConfig.getInstanceFromEnv().getLoadCounterCapacity());

    public static LoadCounter getInstance() {
        return (LoadCounter)Singletons.getInstance(LoadCounter.class, v -> new LoadCounter());
    }

    private static double median(List<Integer> total) {
        Collections.sort(total);
        int size = total.size();
        if (size == 0) {
            return 0.0;
        }
        double j = size % 2 == 1 ? (double)total.get((size - 1) / 2).intValue() : ((double)(total.get(size / 2 - 1) + total.get(size / 2)) + 0.0) / 2.0;
        return j;
    }

    public void init(ScheduledExecutorService executorService) {
        logger.info("Start load pending task");
        executorService.scheduleWithFixedDelay(this::fetchTaskCount, 20L, PERIOD_SECONDS, TimeUnit.SECONDS);
    }

    void fetchTaskCount() {
        try {
            this.pendingQueue.add((Object)this.getPendingTaskCount());
        }
        catch (Exception ex) {
            logger.error("Error when fetch spark pending task", (Throwable)ex);
        }
    }

    public int getPendingTaskCount() {
        Seq activeStage = SparderEnv.getSparkSession().sparkContext().statusStore().activeStages();
        return JavaConverters.seqAsJavaList((Seq)activeStage).stream().filter(stage -> StageStatus.ACTIVE == stage.status()).map(stageData -> stageData.numTasks() - stageData.numActiveTasks() - stageData.numCompleteTasks()).mapToInt(i -> i).sum();
    }

    public int getRunningTaskCount() {
        Seq activeStage = SparderEnv.getSparkSession().sparkContext().statusStore().activeStages();
        return JavaConverters.seqAsJavaList((Seq)activeStage).stream().filter(stage -> StageStatus.ACTIVE == stage.status()).map(StageData::numActiveTasks).mapToInt(i -> i).sum();
    }

    public LoadDesc getLoadDesc() {
        ArrayList<Integer> points = new ArrayList<Integer>((Collection<Integer>)this.pendingQueue);
        logger.trace("Points is {}", points);
        double mean = LoadCounter.median(points);
        Seq executorSummary = SparderEnv.getSparkSession().sparkContext().statusStore().executorList(true);
        int coreNum = JavaConverters.seqAsJavaList((Seq)executorSummary).stream().map(ExecutorSummary::totalCores).mapToInt(i -> i).sum();
        LoadDesc loadDesc = new LoadDesc(mean / (double)coreNum, coreNum, points);
        logger.debug("LoadDesc is {}", (Object)loadDesc);
        return loadDesc;
    }

    public int getSlotCount() {
        return SparderEnv.getTotalCore();
    }
}

