/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.builders;

import java.util.ArrayList;
import java.util.List;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.service.OpenIdConnectScheme;
import springfox.documentation.service.VendorExtension;

public class OpenIdConnectSchemeBuilder {
    private String name;
    private String description;
    private final List<VendorExtension> extensions = new ArrayList<VendorExtension>();
    private String openIdConnectUrl;

    public OpenIdConnectSchemeBuilder name(String name) {
        this.name = name;
        return this;
    }

    public OpenIdConnectSchemeBuilder description(String description) {
        this.description = description;
        return this;
    }

    public OpenIdConnectSchemeBuilder extensions(List<VendorExtension> extensions) {
        this.extensions.addAll(BuilderDefaults.nullToEmptyList(extensions));
        return this;
    }

    public OpenIdConnectSchemeBuilder openIdConnectUrl(String openIdConnectUrl) {
        this.openIdConnectUrl = openIdConnectUrl;
        return this;
    }

    public OpenIdConnectScheme build() {
        return new OpenIdConnectScheme(this.name, this.description, this.extensions, this.openIdConnectUrl);
    }
}

