/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.org.apache.hadoop.hive.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.io.HiveIOExceptionHandler;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.io.HiveIOExceptionNextHandleResult;

public class HiveIOExceptionHandlerChain {
    public static final String HIVE_IO_EXCEPTION_HANDLE_CHAIN = "hive.io.exception.handlers";
    private List<HiveIOExceptionHandler> handlerChain;

    public static HiveIOExceptionHandlerChain getHiveIOExceptionHandlerChain(JobConf conf) {
        String[] handlerArr;
        HiveIOExceptionHandlerChain chain = new HiveIOExceptionHandlerChain();
        String exceptionHandlerStr = conf.get(HIVE_IO_EXCEPTION_HANDLE_CHAIN);
        ArrayList<HiveIOExceptionHandler> handlerChain = new ArrayList<HiveIOExceptionHandler>();
        if (exceptionHandlerStr != null && !exceptionHandlerStr.trim().equals("") && (handlerArr = exceptionHandlerStr.split(",")) != null && handlerArr.length > 0) {
            for (String handlerStr : handlerArr) {
                if (handlerStr.trim().equals("")) continue;
                try {
                    Class<?> handlerCls = Class.forName(handlerStr);
                    HiveIOExceptionHandler handler = (HiveIOExceptionHandler)ReflectionUtils.newInstance(handlerCls, null);
                    handlerChain.add(handler);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        chain.setHandlerChain(handlerChain);
        return chain;
    }

    protected List<HiveIOExceptionHandler> getHandlerChain() {
        return this.handlerChain;
    }

    protected void setHandlerChain(List<HiveIOExceptionHandler> handlerChain) {
        this.handlerChain = handlerChain;
    }

    public RecordReader<?, ?> handleRecordReaderCreationException(Exception e) throws IOException {
        RecordReader<?, ?> ret = null;
        if (this.handlerChain != null && this.handlerChain.size() > 0) {
            for (HiveIOExceptionHandler handler : this.handlerChain) {
                ret = handler.handleRecordReaderCreationException(e);
                if (ret == null) continue;
                return ret;
            }
        }
        throw new IOException(e);
    }

    public boolean handleRecordReaderNextException(Exception e) throws IOException {
        HiveIOExceptionNextHandleResult result = new HiveIOExceptionNextHandleResult();
        if (this.handlerChain != null && this.handlerChain.size() > 0) {
            for (HiveIOExceptionHandler handler : this.handlerChain) {
                handler.handleRecorReaderNextException(e, result);
                if (!result.getHandled()) continue;
                return result.getHandleResult();
            }
        }
        throw new IOException(e);
    }
}

