/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.analysis;

import java.io.IOException;
import java.util.Random;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;

public final class CrankyTokenFilter
extends TokenFilter {
    final Random random;
    int thingToDo;

    public CrankyTokenFilter(TokenStream input, Random random) {
        super(input);
        this.random = random;
    }

    public boolean incrementToken() throws IOException {
        if (this.thingToDo == 0 && this.random.nextBoolean()) {
            throw new IOException("Fake IOException from TokenStream.incrementToken()");
        }
        return this.input.incrementToken();
    }

    public void end() throws IOException {
        super.end();
        if (this.thingToDo == 1 && this.random.nextBoolean()) {
            throw new IOException("Fake IOException from TokenStream.end()");
        }
    }

    public void reset() throws IOException {
        super.reset();
        this.thingToDo = this.random.nextInt(100);
        if (this.thingToDo == 2 && this.random.nextBoolean()) {
            throw new IOException("Fake IOException from TokenStream.reset()");
        }
    }

    public void close() throws IOException {
        super.close();
        if (this.thingToDo == 3 && this.random.nextBoolean()) {
            throw new IOException("Fake IOException from TokenStream.close()");
        }
    }
}

