/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.io;

import org.apache.sis.internal.util.Numerics;
import org.apache.sis.io.TableAppender;

public final class Region {
    final int[] targetSize;
    final long startAt;
    private final long[] skips;
    private long[] skipBytes;
    public final long length;

    public Region(long[] lArray, long[] lArray2, long[] lArray3, int[] nArray) {
        int n = lArray.length;
        this.targetSize = new int[n];
        this.skips = new long[n + 1];
        long l = 0L;
        long l2 = 1L;
        long l3 = 0L;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            long l4 = lArray2[n2];
            long l5 = Numerics.ceilDiv(lArray3[n2] - l4, (long)n3);
            long l6 = l4 + ((l5 - 1L) * (long)n3 + 1L);
            long l7 = lArray[n2];
            assert (l5 > 0L && l4 >= 0L && l6 > l4 && l6 <= l7) : n2;
            this.targetSize[n2] = Math.toIntExact(l5);
            l = Math.addExact(l, Math.multiplyExact(l2, l4));
            l3 = Math.addExact(l3, Math.multiplyExact(l2, l7 - (l6 - l4)));
            this.skips[n2] = Math.addExact(this.skips[n2], Math.multiplyExact(l2, (long)(n3 - 1)));
            l2 = Math.multiplyExact(l2, l7);
            this.skips[++n2] = l3;
        }
        this.startAt = l;
        this.length = l2;
    }

    public void setAdditionalByteOffset(int n, long l) {
        if (this.skipBytes == null) {
            this.skipBytes = new long[this.getDimension()];
        }
        this.skipBytes[n] = l;
    }

    public final int getDimension() {
        return this.targetSize.length;
    }

    final int contiguousDataDimension() {
        int n;
        int n2 = this.skips.length - 1;
        for (n = 0; n < n2 && this.skips[n] == 0L; ++n) {
        }
        if (this.skipBytes != null) {
            int n3 = Math.min(n, this.skipBytes.length);
            for (int i = 0; i < n3; ++i) {
                if (this.skipBytes[i] == 0L) continue;
                return i;
            }
        }
        return n;
    }

    final long offset(long l) {
        if (this.skipBytes != null) {
            l = Math.addExact(l, this.skipBytes[0]);
        }
        return Math.multiplyExact(this.startAt, l);
    }

    final long stride(int n, int n2, int n3) {
        long l = Math.multiplyExact(Math.addExact(this.skips[n], (long)n2), (long)n3);
        if (this.skipBytes != null) {
            l = Math.addExact(l, this.skipBytes[n]);
        }
        return l;
    }

    final int targetLength(int n) {
        long l = 1L;
        for (int i = 0; i < n; ++i) {
            l *= (long)this.targetSize[i];
        }
        return Math.toIntExact(l);
    }

    public String toString() {
        TableAppender tableAppender = new TableAppender(" ");
        tableAppender.setCellAlignment((byte)1);
        tableAppender.append("size").nextColumn();
        tableAppender.append("skip").nextLine();
        for (int i = 0; i < this.targetSize.length; ++i) {
            tableAppender.append(String.valueOf(this.targetSize[i])).nextColumn();
            tableAppender.append(String.valueOf(this.skips[i])).nextLine();
        }
        return tableAppender.toString();
    }
}

